/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert die Mindeststandzeit eines Zustands.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 41
 */
public class AtlMindeststandzeitZustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _zustandsschluessel
			= new String
			()
			;
			private 	RelativerZeitstempel
			 _mindeststandzeit
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Zustandsschluessel.
		*/
			public String
			 getZustandsschluessel() {
			return _zustandsschluessel;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _zustandsschluessel der neue Wert von Zustandsschluessel.
		*/
		public void setZustandsschluessel(String
		 _zustandsschluessel) {
			if (_zustandsschluessel.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._zustandsschluessel = _zustandsschluessel;
		}
	
		/**
		Angabe einer Zeitdauer.
		<p>
		
		</p>
		
		@return der Wert von Mindeststandzeit.
		*/
			public 	RelativerZeitstempel
			 getMindeststandzeit() {
			return _mindeststandzeit;
		}
	
		/**
		Angabe einer Zeitdauer.
		<p>
		
		</p>
		
		@param _mindeststandzeit der neue Wert von Mindeststandzeit.
		*/
		public void setMindeststandzeit(	RelativerZeitstempel
		 _mindeststandzeit) {
			this._mindeststandzeit = _mindeststandzeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getZustandsschluessel() != null) {
					datum.getTextValue("Zustandsschluessel").setText(getZustandsschluessel());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Mindeststandzeit").setMillis(getMindeststandzeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setZustandsschluessel(daten.getTextValue("Zustandsschluessel").getText());
				// ZeitstempelAttributTyp
					setMindeststandzeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Mindeststandzeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlMindeststandzeitZustand clone() {
		AtlMindeststandzeitZustand klon = new AtlMindeststandzeitZustand();
		
						klon.setZustandsschluessel(getZustandsschluessel());
						klon.setMindeststandzeit(getMindeststandzeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
