/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Warnung oder ein Alarm an einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 43
 */
public class AtlWetterstationAlarmstatus implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationAlarm
			 _alarm
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
			 _sensor
			;
			private 	RelativerZeitstempel
			 _zeitreserve
			;
	
		/**
		Ein Alarm einer Wetterstation.
		<p>
		
		</p>
		
		@return der Wert von Alarm.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationAlarm
			 getAlarm() {
			return _alarm;
		}
	
		/**
		Ein Alarm einer Wetterstation.
		<p>
		
		</p>
		
		@param _alarm der neue Wert von Alarm.
		*/
		public void setAlarm(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationAlarm
		 _alarm) {
			this._alarm = _alarm;
		}
	
		/**
		Die verschiedenen Sensoren einer Wetterstation.
		<p>
		
		</p>
		
		@return der Wert von Sensor.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
			 getSensor() {
			return _sensor;
		}
	
		/**
		Die verschiedenen Sensoren einer Wetterstation.
		<p>
		
		</p>
		
		@param _sensor der neue Wert von Sensor.
		*/
		public void setSensor(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
		 _sensor) {
			this._sensor = _sensor;
		}
	
		/**
		Die Zeitreserve ist optional. Für Alarme ohne Zeitreserve wird der Wert auf 0 gesetzt.
		<p>
		
		</p>
		
		@return der Wert von Zeitreserve.
		*/
			public 	RelativerZeitstempel
			 getZeitreserve() {
			return _zeitreserve;
		}
	
		/**
		Die Zeitreserve ist optional. Für Alarme ohne Zeitreserve wird der Wert auf 0 gesetzt.
		<p>
		
		</p>
		
		@param _zeitreserve der neue Wert von Zeitreserve.
		*/
		public void setZeitreserve(	RelativerZeitstempel
		 _zeitreserve) {
			this._zeitreserve = _zeitreserve;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAlarm() != null) {
	                if (getAlarm().isZustand()) {
	                    datum.getUnscaledValue("Alarm").setText(getAlarm().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Alarm").set(getAlarm().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSensor() != null) {
	                if (getSensor().isZustand()) {
	                    datum.getUnscaledValue("Sensor").setText(getSensor().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Sensor").set(getSensor().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitreserve").setMillis(getZeitreserve().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Alarm").isState()) {
							setAlarm(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationAlarm
							.getZustand(daten.getScaledValue("Alarm").getText()));
						} else {
						setAlarm(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationAlarm
						(daten.
							getUnscaledValue
						("Alarm").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Sensor").isState()) {
							setSensor(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
							.getZustand(daten.getScaledValue("Sensor").getText()));
						} else {
						setSensor(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
						(daten.
							getUnscaledValue
						("Sensor").
								byteValue
						()));
						}
				// ZeitstempelAttributTyp
					setZeitreserve(new
						RelativerZeitstempel
						(daten.getTimeValue("Zeitreserve").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlWetterstationAlarmstatus clone() {
		AtlWetterstationAlarmstatus klon = new AtlWetterstationAlarmstatus();
		
						klon.setAlarm(getAlarm());
						klon.setSensor(getSensor());
						klon.setZeitreserve(getZeitreserve());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
