/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Störungsstatus einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class AttStoerungsStatus extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_0_OK = new AttStoerungsStatus("Ok", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_1_TEILSTOERUNG = new AttStoerungsStatus("Teilstörung", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_2_TOTALSTOERUNG = new AttStoerungsStatus("Totalstörung", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_3_STROMAUSFALL = new AttStoerungsStatus("Stromausfall", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_4_NICHT_VERBUNDEN = new AttStoerungsStatus("Nicht verbunden", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_5_SYSTEMFEHLER = new AttStoerungsStatus("Systemfehler", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStoerungsStatus ZUSTAND_6_TUERKONTAKT = new AttStoerungsStatus("Türkontakt", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStoerungsStatus getZustand(final 		Byte
	 value) {
		for (AttStoerungsStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStoerungsStatus getZustand(final String value) {
		for (AttStoerungsStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStoerungsStatus> getZustaende() {
		List<AttStoerungsStatus> list = new ArrayList<AttStoerungsStatus>();
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1_TEILSTOERUNG);
		list.add(ZUSTAND_2_TOTALSTOERUNG);
		list.add(ZUSTAND_3_STROMAUSFALL);
		list.add(ZUSTAND_4_NICHT_VERBUNDEN);
		list.add(ZUSTAND_5_SYSTEMFEHLER);
		list.add(ZUSTAND_6_TUERKONTAKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StoerungsStatus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStoerungsStatus(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStoerungsStatus(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
