/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Die Messwerte einer Wetterstation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 37
 */
public class OdMesswerte extends AbstractOnlineDatensatz<OdMesswerte.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Normiert,
					Aspekte.Aggregation1,
					Aspekte.PrognoseExtern,
					Aspekte.Aufbereitet,
					Aspekte.PrognoseIntern,
					Aspekte.Ungeprueft,
					Aspekte.PrognoseResultat,
					Aspekte.Aggregation2,
					Aspekte.Online,
					Aspekte.PrognoseML1,
				};
			}
	
			/**
			 * Aspekt für die normierten Daten der externen Prognose.	 
			 *
			 * <p>
			 * &lt;absatz&gt;Die externen Prognosewerte kommen i.d.R. mit einem anderen Horizont,
						Intervall und Intervallbeginn als die Onlinedaten. Beispiel: Onlinedaten kommen
						alle fünf Minuten, beginnend an einer ganzen 5-Minuten-Grenze. Die externen
						Prognosewerte kommen jede halbe Stunde um ca. 10 Minuten vor um&#47;halb.
						Sie werden deshalb auf das Zeitraster der Onlinedaten interpoliert und normiert,
						um mit ihnen vergleichbar und verknüpfbar zu sein. Diese normierten Werte werden
						hier publiziert.
						&lt;&#47;absatz&gt;
	         * </p>
			 */
			public static final Aspekt Normiert = new Aspekte("Normiert", "asp.normiert");
			
			/**
			 * Aspekt Aggregation1.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Aggregation1 = new Aspekte("Aggregation1", "asp.aggregation1");
			
			/**
			 * Aspekt Prognose Extern.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseExtern = new Aspekte("Prognose Extern", "asp.prognoseExtern");
			
			/**
			 * Aspekt Prognose Freie Definition.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Aufbereitet = new Aspekte("Aufbereitet", "asp.aufbereitet");
			
			/**
			 * Aspekt Prognose Intern.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseIntern = new Aspekte("Prognose Intern", "asp.prognoseIntern");
			
			/**
			 * Aspekt für die ungeprüften Daten der Erfassung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Ungeprueft = new Aspekte("Ungeprüft", "asp.ungeprueft");
			
			/**
			 * Aspekt Prognose Resultat.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseResultat = new Aspekte("Prognose Resultat", "asp.prognoseResultat");
			
			/**
			 * Aspekt Aggregation2.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Aggregation2 = new Aspekte("Aggregation2", "asp.aggregation2");
			
			/**
			 * Online Daten.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Online = new Aspekte("Online", "asp.online");
			
			/**
			 * Aspekt Prognose Machine Learning 1.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt PrognoseML1 = new Aspekte("Prognose ML1", "asp.prognoseML1");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Zeitstempel
				 _beginnGueltigkeit
				;
				private 	RelativerZeitstempel
				 _horizont
				;
				private 	Zeitstempel
				 _bestimmt
				;
				private 	Zeitstempel
				 _publiziert
				;
				@Defaultwert(wert = "Unbekannt")
				private String
				 _messwertTyp
				= new String
				()
				;
				@Defaultwert(wert = "Unbekannt")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
				 _sensor
				;
				@Defaultwert(wert = "0")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 _wert
				;
				@Defaultwert(wert = "nicht ermittelbar")
				private String
				 _text
				= new String
				()
				;
				@Defaultwert(wert = "Ungültig")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttMesswertStatus
				 _status
				;
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von BeginnGueltigkeit.
			*/
				public 	Zeitstempel
				 getBeginnGueltigkeit() {
				return _beginnGueltigkeit;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _beginnGueltigkeit der neue Wert von BeginnGueltigkeit.
			*/
			public void setBeginnGueltigkeit(	Zeitstempel
			 _beginnGueltigkeit) {
				this._beginnGueltigkeit = _beginnGueltigkeit;
			}
		
			/**
			Angabe einer Zeitdauer.
			<p>
			
			</p>
			
			@return der Wert von Horizont.
			*/
				public 	RelativerZeitstempel
				 getHorizont() {
				return _horizont;
			}
		
			/**
			Angabe einer Zeitdauer.
			<p>
			
			</p>
			
			@param _horizont der neue Wert von Horizont.
			*/
			public void setHorizont(	RelativerZeitstempel
			 _horizont) {
				this._horizont = _horizont;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von Bestimmt.
			*/
				public 	Zeitstempel
				 getBestimmt() {
				return _bestimmt;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _bestimmt der neue Wert von Bestimmt.
			*/
			public void setBestimmt(	Zeitstempel
			 _bestimmt) {
				this._bestimmt = _bestimmt;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@return der Wert von Publiziert.
			*/
				public 	Zeitstempel
				 getPubliziert() {
				return _publiziert;
			}
		
			/**
			Angabe eines Zeitpunktes.
			<p>
			
			</p>
			
			@param _publiziert der neue Wert von Publiziert.
			*/
			public void setPubliziert(	Zeitstempel
			 _publiziert) {
				this._publiziert = _publiziert;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von MesswertTyp.
			*/
				public String
				 getMesswertTyp() {
				return _messwertTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _messwertTyp der neue Wert von MesswertTyp.
			*/
			public void setMesswertTyp(String
			 _messwertTyp) {
				if (_messwertTyp.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._messwertTyp = _messwertTyp;
			}
		
			/**
			Die verschiedenen Sensoren einer Wetterstation.
			<p>
			
			</p>
			
			@return der Wert von Sensor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
				 getSensor() {
				return _sensor;
			}
		
			/**
			Die verschiedenen Sensoren einer Wetterstation.
			<p>
			
			</p>
			
			@param _sensor der neue Wert von Sensor.
			*/
			public void setSensor(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
			 _sensor) {
				this._sensor = _sensor;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@return der Wert von Wert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
				 getWert() {
				return _wert;
			}
		
			/**
			Positve oder negative Zahl mit 4 Nachkommastellen.
			<p>
			
			</p>
			
			@param _wert der neue Wert von Wert.
			*/
			public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
			 _wert) {
				this._wert = _wert;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Text.
			*/
				public String
				 getText() {
				return _text;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _text der neue Wert von Text.
			*/
			public void setText(String
			 _text) {
				if (_text.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._text = _text;
			}
		
			/**
			Status für UFD Messwerte.
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttMesswertStatus
				 getStatus() {
				return _status;
			}
		
			/**
			Status für UFD Messwerte.
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttMesswertStatus
			 _status) {
				this._status = _status;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("beginnGueltigkeit").setMillis(getBeginnGueltigkeit().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("horizont").setMillis(getHorizont().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("bestimmt").setMillis(getBestimmt().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("publiziert").setMillis(getPubliziert().getTime());
					// ZeichenkettenAttributTyp
					if (getMesswertTyp() != null) {
						datum.getTextValue("messwertTyp").setText(getMesswertTyp());
					}
					// GanzzahlAttributTyp
					if (getSensor() != null) {
		                if (getSensor().isZustand()) {
		                    datum.getUnscaledValue("sensor").setText(getSensor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sensor").set(getSensor().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWert() != null) {
		                if (getWert().isZustand()) {
		                    datum.getUnscaledValue("wert").setText(getWert().toString());
		                } else {
							datum.
							getScaledValue
		                	("wert").set(getWert().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getText() != null) {
						datum.getTextValue("text").setText(getText());
					}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("status").set(getStatus().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setBeginnGueltigkeit(new
							Zeitstempel
							(daten.getTimeValue("beginnGueltigkeit").getMillis()));
					// ZeitstempelAttributTyp
						setHorizont(new
							RelativerZeitstempel
							(daten.getTimeValue("horizont").getMillis()));
					// ZeitstempelAttributTyp
						setBestimmt(new
							Zeitstempel
							(daten.getTimeValue("bestimmt").getMillis()));
					// ZeitstempelAttributTyp
						setPubliziert(new
							Zeitstempel
							(daten.getTimeValue("publiziert").getMillis()));
					// ZeichenkettenAttributTyp
						setMesswertTyp(daten.getTextValue("messwertTyp").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sensor").isState()) {
								setSensor(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
								.getZustand(daten.getScaledValue("sensor").getText()));
							} else {
							setSensor(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttWetterstationSensor
							(daten.
								getUnscaledValue
							("sensor").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttZahl4NachKommaStellen
							(daten.
								getScaledValue
							("wert").
								doubleValue
							()));
					// ZeichenkettenAttributTyp
						setText(daten.getTextValue("text").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttMesswertStatus
								.getZustand(daten.getScaledValue("status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttMesswertStatus
							(daten.
								getUnscaledValue
							("status").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBeginnGueltigkeit(getBeginnGueltigkeit());
							klon.setHorizont(getHorizont());
							klon.setBestimmt(getBestimmt());
							klon.setPubliziert(getPubliziert());
							klon.setMesswertTyp(getMesswertTyp());
							klon.setSensor(getSensor());
							klon.setWert(getWert());
							klon.setText(getText());
							klon.setStatus(getStatus());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.messwerte";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdMesswerte(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
