/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisbufr.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die MesswertTypen, die für einen Wetterstation
					exportiert werden sollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBUFRExportWetterstation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.Wetterstation
			 _wetterstation
			;
			private Feld<String
			> _schluessel = new Feld<String
			>(0, true);
	
		/**
		Referenz auf eine Wetterstation.
		<p>
		
		</p>
		
		@return der Wert von Wetterstation.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.Wetterstation
			 getWetterstation() {
			return _wetterstation;
		}
	
		/**
		Referenz auf eine Wetterstation.
		<p>
		
		</p>
		
		@param _wetterstation der neue Wert von Wetterstation.
		*/
		public void setWetterstation(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.Wetterstation
		 _wetterstation) {
			this._wetterstation = _wetterstation;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Schluessel.
		*/
			public Feld<String
			> getSchluessel() {
			return _schluessel;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soWetterstation = getWetterstation();
					final SystemObject tmpWetterstation;
						if (soWetterstation instanceof SystemObject) {
							tmpWetterstation = (SystemObject)soWetterstation;
						} else if(soWetterstation instanceof SystemObjekt){
							tmpWetterstation = ((SystemObjekt)soWetterstation).getSystemObject();
						} else{
							tmpWetterstation = null;
						}
					datum.getReferenceValue("wetterstation").setSystemObject(tmpWetterstation);
				// ZeichenkettenAttributTyp
				if (getSchluessel() != null) {
					final Data.TextArray arraySchluessel = datum.getTextArray("schluessel");
					arraySchluessel.setLength(getSchluessel().size());
					for (int i = 0; i < arraySchluessel.getLength(); ++i) {
						arraySchluessel.getTextValue(i).setText(getSchluessel().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idWetterstation = daten.getReferenceValue("wetterstation").getId();
					final SystemObjekt tmpWetterstation;
					if (idWetterstation == 0) {
						tmpWetterstation = null;
					} else {
						final SystemObject soWetterstation = factory.getDav().getDataModel().getObject(idWetterstation);
						if (soWetterstation == null) {
								tmpWetterstation = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.impl.WetterstationUngueltig(idWetterstation);
						} else {
							tmpWetterstation = factory.getModellobjekt(soWetterstation);
						}
					}
					setWetterstation((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.Wetterstation
					) tmpWetterstation);
				// ZeichenkettenAttributTyp
					final Data.TextArray arraySchluessel = daten.getTextArray("schluessel");
					for (int i = 0; i < arraySchluessel.getLength(); ++i) {
						getSchluessel().add(arraySchluessel.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBUFRExportWetterstation clone() {
		AtlBUFRExportWetterstation klon = new AtlBUFRExportWetterstation();
		
						klon.setWetterstation(getWetterstation());
					klon._schluessel = getSchluessel().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
