/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
GlätteAlarmStatus.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AttUfdsGlaetteAlarmStatus extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist und kein Interpolation sinnvoll möglich ist (z.B. ist die Geschwindigkeit nicht ermittelbar, wenn kein Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_1N_NICHT_ERMITTELBAR = new AttUfdsGlaetteAlarmStatus("nicht ermittelbar", 		Short
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_2N_FEHLERHAFT = new AttUfdsGlaetteAlarmStatus("fehlerhaft", 		Short
	.valueOf("-2"));

	/**
	Daten nicht ermittelbar, da bereits Basiswerte fehlerhaft.
	<p>
	Wird gesetzt, wenn Daten, die zur Berechnung dieses Werts notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen (z.B. Nenner = 0 in der Berechnungsformel) nicht möglich war.
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttUfdsGlaetteAlarmStatus("nicht ermittelbar/fehlerhaft", 		Short
	.valueOf("-3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_0_KEIN = new AttUfdsGlaetteAlarmStatus("kein", 		Short
	.valueOf("0"));

	/**
	Warnung vor potentiell gefährlichen Bedinungen; 1. Alarmstufe.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_1_A1 = new AttUfdsGlaetteAlarmStatus("A1", 		Short
	.valueOf("1"));

	/**
	Warnung vor potentieller Glätte; 2. Alarmstufe.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_2_A2 = new AttUfdsGlaetteAlarmStatus("A2", 		Short
	.valueOf("2"));

	/**
	Alarm, Glätte definitiv vorhanden; 3. Alarmstufe.
	<p>
	
	</p>
	*/
	public static final AttUfdsGlaetteAlarmStatus ZUSTAND_3_A3 = new AttUfdsGlaetteAlarmStatus("A3", 		Short
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttUfdsGlaetteAlarmStatus getZustand(final 		Short
	 value) {
		for (AttUfdsGlaetteAlarmStatus e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttUfdsGlaetteAlarmStatus getZustand(final String value) {
		for (AttUfdsGlaetteAlarmStatus e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttUfdsGlaetteAlarmStatus> getZustaende() {
		List<AttUfdsGlaetteAlarmStatus> list = new ArrayList<AttUfdsGlaetteAlarmStatus>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		list.add(ZUSTAND_0_KEIN);
		list.add(ZUSTAND_1_A1);
		list.add(ZUSTAND_2_A2);
		list.add(ZUSTAND_3_A3);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut UfdsGlätteAlarmStatus.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttUfdsGlaetteAlarmStatus(final 		Short
	 value) {
		super(value);
	}
	
	private AttUfdsGlaetteAlarmStatus(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
