/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor der ZeitReserveEisGlätte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface UfdsZeitReserveEisGlaette extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UmfeldDatenSensor
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.ufdsZeitReserveEisGlätte"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter für die Langzeit-PL-Prüfung des Sensorwertes. Neben der Prüfung für das eingestellte Vergleichsintervall wird zusätzlich auch die PL-Prüfung jeweils für den Tag durchgeführt. Die zusätzlichen Parameter gelten somit sowohl für das Tagesintervall als auch für das Vergleichsintervall.
	<p>
	
	</p>
	@return der Datensatz UfdsLangzeitPLPruefungZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsLangzeitPLPruefungZeitReserveEisGlaette getPdUfdsLangzeitPLPruefungZeitReserveEisGlaette();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für die meteorologische Kontrolle des Sensorwertes (Prüfung, ob Sensorwert sinnvolle Ergebnisse im Vergleich mit meteorologisch vergleichbaren Sensoren liefert).
	<p>
	
	</p>
	@return der Datensatz UfdsMeteorologischeKontrolleZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsMeteorologischeKontrolleZeitReserveEisGlaette getPdUfdsMeteorologischeKontrolleZeitReserveEisGlaette();
	
	/**
	Parameter zur Messwertersetzung.
	<p>
	
	</p>
	@return der Datensatz UfdsMessWertErsetzung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parameter mit den Hysteresschwellwerten zur Abbildung des Sensorwertes auf eine Stufe.
	<p>
	
	</p>
	@return der Datensatz UfdsKlassifizierungZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsKlassifizierungZeitReserveEisGlaette getPdUfdsKlassifizierungZeitReserveEisGlaette();
	
	/**
	Parameter zur Messwertersetzung.
	<p>
	
	</p>
	@return der Datensatz UfdsAusfallUeberwachung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung();
	
	/**
	Parameter zur exponentiellen Glättung mit wanderndem Abweichungswinkel für den Sensorwert. Geglätteter Wert wird zur Bildung der Sensorwert-Stufe verwendet.
	<p>
	
	</p>
	@return der Datensatz UfdsAggregationZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAggregationZeitReserveEisGlaette getPdUfdsAggregationZeitReserveEisGlaette();
	
	/**
	Sensorwert.
	<p>
	
	</p>
	@return der Datensatz UfdsZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsZeitReserveEisGlaette getOdUfdsZeitReserveEisGlaette();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz UmfeldDatenSensor.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor();
	
	/**
	Parameter für die Anstieg-Abstieg-Kontrolle (Prüfung, ob die Änderungsgeschwindigkeit zweier aufeinander folgender Sensorwerte unterhalb einer parametrierbaren Grenze liegt).
	<p>
	
	</p>
	@return der Datensatz UfdsAnstiegAbstiegKontrolleZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAnstiegAbstiegKontrolleZeitReserveEisGlaette getPdUfdsAnstiegAbstiegKontrolleZeitReserveEisGlaette();
	
	/**
	Referenz auf ein Linienobjekt mit Offsetangabe vom Begin der Linie. Darüber läßt sich dessen Koordinate ermitteln. Liegen mehrer Objekte auf einem Linienobjekt, läßt sich über die Offsets die Topologie ermitteln.
	<p>
	
	</p>
	@return der Datensatz PunktLiegtAufLinienObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt();
	
	/**
	Aus dem Sensorwert über die exponentielle Glättung und die Klassifizierung mit Hysterese ermittelte Stufe (Abbildung eines kontinuierlichen Sensorwertes auf eine diskrete Stufe).
	<p>
	
	</p>
	@return der Datensatz UfdsStufeZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsStufeZeitReserveEisGlaette getOdUfdsStufeZeitReserveEisGlaette();
	
	/**
	Parameter für die Differentialkontrolle (Prüfung. ob Sensorwert innerhalb eines parametrierbaren Zeitbereichs Schwankungen aufweist, ansonsten ist Sensorwert inplausibel).
	<p>
	
	</p>
	@return der Datensatz UfdsDifferenzialKontrolleZeitReserveEisGlaette.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsDifferenzialKontrolleZeitReserveEisGlaette getPdUfdsDifferenzialKontrolleZeitReserveEisGlaette();
	
	/**
	Zeitreserve Eisglätte als lingustische Variable.
	<p>
	
	</p>
	@return der Datensatz UfdsZeitReserveEisGlaetteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsZeitReserveEisGlaetteFuzzy getOdUfdsZeitReserveEisGlaetteFuzzy();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Fuzzy-Set (Parameter) für Zeitreserve Eisglätte.
	<p>
	
	</p>
	@return der Datensatz UfdsParameterZeitReserveEisGlaetteFuzzy.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsParameterZeitReserveEisGlaetteFuzzy getPdUfdsParameterZeitReserveEisGlaetteFuzzy();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
