/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Werte für den Sensor der GlätteAlarmStatus.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class UfdsGlaetteAlarmStatusImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.objekte.UfdsGlaetteAlarmStatus { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public UfdsGlaetteAlarmStatusImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public UfdsGlaetteAlarmStatusImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein UfdsGlätteAlarmStatus.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsKlassifizierungGlaetteAlarmStatus getPdUfdsKlassifizierungGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsKlassifizierungGlaetteAlarmStatus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsStufeGlaetteAlarmStatus getOdUfdsStufeGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsStufeGlaetteAlarmStatus.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung getPdUfdsMessWertErsetzung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsMessWertErsetzung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsParameterGlaetteAlarmStatusFuzzy getPdUfdsParameterGlaetteAlarmStatusFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsParameterGlaetteAlarmStatusFuzzy.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung getPdUfdsAusfallUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.parameter.PdUfdsAusfallUeberwachung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsGlaetteAlarmStatusFuzzy getOdUfdsGlaetteAlarmStatusFuzzy() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsGlaetteAlarmStatusFuzzy.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsLangzeitPLPruefungGlaetteAlarmStatus getPdUfdsLangzeitPLPruefungGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsLangzeitPLPruefungGlaetteAlarmStatus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor getKdUmfeldDatenSensor() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.konfigurationsdaten.KdUmfeldDatenSensor.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAnstiegAbstiegKontrolleGlaetteAlarmStatus getPdUfdsAnstiegAbstiegKontrolleGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAnstiegAbstiegKontrolleGlaetteAlarmStatus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsMeteorologischeKontrolleGlaetteAlarmStatus getPdUfdsMeteorologischeKontrolleGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsMeteorologischeKontrolleGlaetteAlarmStatus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsGlaetteAlarmStatus getOdUfdsGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.onlinedaten.OdUfdsGlaetteAlarmStatus.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsDifferenzialKontrolleGlaetteAlarmStatus getPdUfdsDifferenzialKontrolleGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsDifferenzialKontrolleGlaetteAlarmStatus.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAggregationGlaetteAlarmStatus getPdUfdsAggregationGlaetteAlarmStatus() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswisumfelddatenzrg.parameter.PdUfdsAggregationGlaetteAlarmStatus.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
