/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einstellungen zur Verwaltung eines FTP
					Downloads&#47; FTP Uploads.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdFtpParameter extends AbstractParameterDatensatz<PdFtpParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _host
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _port
				;
				private String
				 _login
				= new String
				()
				;
				private String
				 _password
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttFtpDataTransferTyp
				 _ftpDataTransferTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _passivFtp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttProxyTyp
				 _proxyTyp
				;
				private String
				 _proxyHost
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _proxyPort
				;
				private String
				 _proxyLogin
				= new String
				()
				;
				private String
				 _proxyPassword
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Host.
			*/
				public String
				 getHost() {
				return _host;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _host der neue Wert von Host.
			*/
			public void setHost(String
			 _host) {
				if (_host.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._host = _host;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von Port.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getPort() {
				return _port;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _port der neue Wert von Port.
			*/
			public void setPort(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _port) {
				this._port = _port;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Login.
			*/
				public String
				 getLogin() {
				return _login;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _login der neue Wert von Login.
			*/
			public void setLogin(String
			 _login) {
				if (_login.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._login = _login;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Password.
			*/
				public String
				 getPassword() {
				return _password;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _password der neue Wert von Password.
			*/
			public void setPassword(String
			 _password) {
				if (_password.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._password = _password;
			}
		
			/**
			FTP Data Transfer Typ: Text|Binary|Auto.
			<p>
			
			</p>
			
			@return der Wert von FtpDataTransferTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttFtpDataTransferTyp
				 getFtpDataTransferTyp() {
				return _ftpDataTransferTyp;
			}
		
			/**
			FTP Data Transfer Typ: Text|Binary|Auto.
			<p>
			
			</p>
			
			@param _ftpDataTransferTyp der neue Wert von FtpDataTransferTyp.
			*/
			public void setFtpDataTransferTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttFtpDataTransferTyp
			 _ftpDataTransferTyp) {
				this._ftpDataTransferTyp = _ftpDataTransferTyp;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von PassivFtp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getPassivFtp() {
				return _passivFtp;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _passivFtp der neue Wert von PassivFtp.
			*/
			public void setPassivFtp(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _passivFtp) {
				this._passivFtp = _passivFtp;
			}
		
			/**
			Proxy Typen.
			<p>
			
			</p>
			
			@return der Wert von ProxyTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttProxyTyp
				 getProxyTyp() {
				return _proxyTyp;
			}
		
			/**
			Proxy Typen.
			<p>
			
			</p>
			
			@param _proxyTyp der neue Wert von ProxyTyp.
			*/
			public void setProxyTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttProxyTyp
			 _proxyTyp) {
				this._proxyTyp = _proxyTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ProxyHost.
			*/
				public String
				 getProxyHost() {
				return _proxyHost;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _proxyHost der neue Wert von ProxyHost.
			*/
			public void setProxyHost(String
			 _proxyHost) {
				if (_proxyHost.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._proxyHost = _proxyHost;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von ProxyPort.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getProxyPort() {
				return _proxyPort;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _proxyPort der neue Wert von ProxyPort.
			*/
			public void setProxyPort(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _proxyPort) {
				this._proxyPort = _proxyPort;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ProxyLogin.
			*/
				public String
				 getProxyLogin() {
				return _proxyLogin;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _proxyLogin der neue Wert von ProxyLogin.
			*/
			public void setProxyLogin(String
			 _proxyLogin) {
				if (_proxyLogin.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._proxyLogin = _proxyLogin;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ProxyPassword.
			*/
				public String
				 getProxyPassword() {
				return _proxyPassword;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _proxyPassword der neue Wert von ProxyPassword.
			*/
			public void setProxyPassword(String
			 _proxyPassword) {
				if (_proxyPassword.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._proxyPassword = _proxyPassword;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getHost() != null) {
						datum.getTextValue("host").setText(getHost());
					}
					// GanzzahlAttributTyp
					if (getPort() != null) {
		                if (getPort().isZustand()) {
		                    datum.getUnscaledValue("port").setText(getPort().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("port").set(getPort().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getLogin() != null) {
						datum.getTextValue("login").setText(getLogin());
					}
					// ZeichenkettenAttributTyp
					if (getPassword() != null) {
						datum.getTextValue("password").setText(getPassword());
					}
					// GanzzahlAttributTyp
					if (getFtpDataTransferTyp() != null) {
		                if (getFtpDataTransferTyp().isZustand()) {
		                    datum.getUnscaledValue("ftpDataTransferTyp").setText(getFtpDataTransferTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ftpDataTransferTyp").set(getFtpDataTransferTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPassivFtp() != null) {
		                if (getPassivFtp().isZustand()) {
		                    datum.getUnscaledValue("passivFtp").setText(getPassivFtp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("passivFtp").set(getPassivFtp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getProxyTyp() != null) {
		                if (getProxyTyp().isZustand()) {
		                    datum.getUnscaledValue("proxyTyp").setText(getProxyTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("proxyTyp").set(getProxyTyp().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getProxyHost() != null) {
						datum.getTextValue("proxyHost").setText(getProxyHost());
					}
					// GanzzahlAttributTyp
					if (getProxyPort() != null) {
		                if (getProxyPort().isZustand()) {
		                    datum.getUnscaledValue("proxyPort").setText(getProxyPort().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("proxyPort").set(getProxyPort().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getProxyLogin() != null) {
						datum.getTextValue("proxyLogin").setText(getProxyLogin());
					}
					// ZeichenkettenAttributTyp
					if (getProxyPassword() != null) {
						datum.getTextValue("proxyPassword").setText(getProxyPassword());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setHost(daten.getTextValue("host").getText());
					// GanzzahlAttributTyp
							setPort(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("port").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setLogin(daten.getTextValue("login").getText());
					// ZeichenkettenAttributTyp
						setPassword(daten.getTextValue("password").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ftpDataTransferTyp").isState()) {
								setFtpDataTransferTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttFtpDataTransferTyp
								.getZustand(daten.getScaledValue("ftpDataTransferTyp").getText()));
							} else {
							setFtpDataTransferTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttFtpDataTransferTyp
							(daten.
								getUnscaledValue
							("ftpDataTransferTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("passivFtp").isState()) {
								setPassivFtp(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("passivFtp").getText()));
							} else {
							setPassivFtp(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("passivFtp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("proxyTyp").isState()) {
								setProxyTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttProxyTyp
								.getZustand(daten.getScaledValue("proxyTyp").getText()));
							} else {
							setProxyTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltransfer.attribute.AttProxyTyp
							(daten.
								getUnscaledValue
							("proxyTyp").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setProxyHost(daten.getTextValue("proxyHost").getText());
					// GanzzahlAttributTyp
							setProxyPort(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("proxyPort").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setProxyLogin(daten.getTextValue("proxyLogin").getText());
					// ZeichenkettenAttributTyp
						setProxyPassword(daten.getTextValue("proxyPassword").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setHost(getHost());
							klon.setPort(getPort());
							klon.setLogin(getLogin());
							klon.setPassword(getPassword());
							klon.setFtpDataTransferTyp(getFtpDataTransferTyp());
							klon.setPassivFtp(getPassivFtp());
							klon.setProxyTyp(getProxyTyp());
							klon.setProxyHost(getProxyHost());
							klon.setProxyPort(getProxyPort());
							klon.setProxyLogin(getProxyLogin());
							klon.setProxyPassword(getProxyPassword());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ftpParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdFtpParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
