/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bestimmt, ob bei einer Korrektur über die Angabe freier
					Stellplätze der zugrunde liegende Zählwert oder die logische Anzahl
					freier Stellplätze angepasst werden soll bzw. wurde.
<p>
Der Bediener soll die Möglichkeit haben, Korrekturwerte anhand der
					konkreten Situation qualifizieren zu können.
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							&lt;wichtig&gt;Gezählt:&lt;&#47;wichtig&gt;
							Der Versand des Korrekturwertes soll eine Anpassung des aktuellen
							Rechenwertes der Auslastung zur Folge haben. Diese Option wählt
							der Bediener, wenn die Anzahl von Fahrzeugen aufgrund von
							Messungenauigkeiten der zugrunde liegenden Erfassungstechnik
							falsch bestimmt wurde oder ein Neustart der Anlage erfolgte.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							&lt;wichtig&gt;Logisch ermittelt:&lt;&#47;wichtig&gt;
							Der Versand des Korrekturwertes soll eine Anpassung des Wertes
							'Logische Kapazität' aus dem Parametersatz atg.turParameterAnlage
							am Anlagenobjekt zur Folge haben. Diese Option wählt der
							Bediener, wenn die Anzahl von Fahrzeugen im Parkbereich korrekt
							ist, die abgeleitete Anzahl verfügbarer Stellplätze aber trotzdem
							verkehrt ist. Dies kann der Fall sein, wenn:
							&lt;liste zeichen="punkt"&gt;
								&lt;listenPunkt&gt;Ein Lkw mehrere Parkbuchten benutzt (z.B. schräg
									steht)
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;Sich mehrere kleine Fahrzeuge (z.B. Sprinter) eine
									Parkbucht teilen
								&lt;&#47;listenPunkt&gt;
								&lt;listenPunkt&gt;Sich eine der oben beschriebenen Situationen
									auflöst.
								&lt;&#47;listenPunkt&gt;
							&lt;&#47;liste&gt;
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Defaultwert(wert = "gezaehlt")
public class AttTurArtKorrektur extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die verfügbaren Stellplätze werden gezählt.
	<p>
	
	</p>
	*/
	public static final AttTurArtKorrektur ZUSTAND_0_GEZAEHLT = new AttTurArtKorrektur("gezaehlt", 		Byte
	.valueOf("0"));

	/**
	Die belegten Stellplätze werden gezählt.
	<p>
	
	</p>
	*/
	public static final AttTurArtKorrektur ZUSTAND_1_LOGISCH_ERMITTELT = new AttTurArtKorrektur("logisch ermittelt", 		Byte
	.valueOf("1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTurArtKorrektur getZustand(final 		Byte
	 value) {
		for (AttTurArtKorrektur e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTurArtKorrektur getZustand(final String value) {
		for (AttTurArtKorrektur e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTurArtKorrektur> getZustaende() {
		List<AttTurArtKorrektur> list = new ArrayList<AttTurArtKorrektur>();
		list.add(ZUSTAND_0_GEZAEHLT);
		list.add(ZUSTAND_1_LOGISCH_ERMITTELT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TuRArtDerKorrektur.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTurArtKorrektur(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTurArtKorrektur(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
