/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert, ob die verfügbaren oder die belegten
					Stellplätze einer Anlage gezählt &#47; errechnet &#47; gezeigt wurden bzw.
					werden.
<p>
Der Bediener soll so schnell, sicher und genau die Möglichkeit
					haben, die Anzahl verfügbarer Stellplätze in das System einzugeben.
					Deshalb werden grundsätzlich zwei Möglichkeiten vorgesehen:
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;
							&lt;wichtig&gt;Belegte Stellplätze:&lt;&#47;wichtig&gt;
							Bei geringer bzw. mittlerer Stellplatzauslastung ist es
							einfacher, die im Parkbereich befindlichen (wenigen) Fahrzeuge zu
							zählen.
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;
							&lt;wichtig&gt;Freie Stellplätze:&lt;&#47;wichtig&gt;
							Bei hoher Stellplatzauslastung ist es einfacher, die (wenigen)
							freien Stellplätze zu zählen.
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Defaultwert(wert = "frei")
public class AttTurArtStellplatzAnzahl extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Die verfügbaren Stellplätze werden gezählt.
	<p>
	
	</p>
	*/
	public static final AttTurArtStellplatzAnzahl ZUSTAND_0_FREI = new AttTurArtStellplatzAnzahl("frei", 		Byte
	.valueOf("0"));

	/**
	Die belegten Stellplätze werden gezählt.
	<p>
	
	</p>
	*/
	public static final AttTurArtStellplatzAnzahl ZUSTAND_1_BELEGT = new AttTurArtStellplatzAnzahl("belegt", 		Byte
	.valueOf("1"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTurArtStellplatzAnzahl getZustand(final 		Byte
	 value) {
		for (AttTurArtStellplatzAnzahl e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTurArtStellplatzAnzahl getZustand(final String value) {
		for (AttTurArtStellplatzAnzahl e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTurArtStellplatzAnzahl> getZustaende() {
		List<AttTurArtStellplatzAnzahl> list = new ArrayList<AttTurArtStellplatzAnzahl>();
		list.add(ZUSTAND_0_FREI);
		list.add(ZUSTAND_1_BELEGT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TuRArtDerStellplatzanzahl.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTurArtStellplatzAnzahl(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTurArtStellplatzAnzahl(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
