/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert den Betriebszustand einer Anlage zur dynamischen
					Ermittlung und Anzeige freier (LKW-)Parkstände.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Defaultwert(wert = "Initialisierung")
public class AttTurBetriebsZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Betriebsbeginn oder Rückfallebene bei bestimmten
								Störungen.
	<p>
	Bei Betriebsstart ist eine manuelle Zählung der
								belegten Stellplätze erforderlich, um einen Startwert zu
								erhalten, ab dem die automatische Fortschreibung durchgeführt
								wird. Initialisierungen treten i.d.R. nach Systemausfällen &#47;
								Beseitigung von Störungen auf.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_1N_INITIALISIERUNG = new AttTurBetriebsZustand("Initialisierung", 		Byte
	.valueOf("-1"));

	/**
	normaler Betrieb, genügend freie Stellplätze vorhanden.
	<p>
	Normaler Betrieb, eine Korrektur der Stellplatzzahl
								ist optional möglich, jedoch aufgrund des hohen Zählaufwands nur
								bei Bedarf zu empfehlen.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_0_GERINGE_MITTLERE_STELLPLATZ_AUSLASTUNG = new AttTurBetriebsZustand("Geringe / mittlere Stellplatz-Auslastung", 		Byte
	.valueOf("0"));

	/**
	normaler Betrieb, aber nur noch wenige verfügbare
								Stellplätze.
	<p>
	normaler Betrieb, eine Korrektur der Stellplatzzahl
								ist optional möglich, jedoch aufgrund des hohen Zählaufwands nur
								bei Bedarf zu empfehlen.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_1_HOHE_STELLPLATZ_AUSLASTUNG = new AttTurBetriebsZustand("Hohe Stellplatz-Auslastung", 		Byte
	.valueOf("1"));

	/**
	Abgleich der Eingangsdaten gegeneinander oder der
								berechneten Werte ergab Implausibilitäten.
	<p>
	Werden im Rahmen der Plausibilitätskontrollen
								Auffälligkeiten erkannt, wird eine Meldung an das Bedienpersonal
								mit Bitte um manuelle Kontrolle und Korrektur der freien
								Stellplatzzahl abgesetzt. Je nach Art des Plausibilitätsfehlers
								wird die Anzeige automatisch abgeschaltet.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_2_PLAUSIBILITAETSFEHLER = new AttTurBetriebsZustand("Plausibilitaetsfehler", 		Byte
	.valueOf("2"));

	/**
	Ein oder mehrere Geräte der Außenanlagen defekt.
	<p>
	Liegen Störungen der Außenanlagen vor (speziell
								Erfassungssysteme) kann u.U. die Berechnung der freien
								Stellplätze nur noch auf einem der möglichen Berechnungswege oder
								sogar gar nicht mehr erfolgen. Ist keine Berechnung mehr möglich,
								wird die Anzeige abgeschaltet. In jedem Fall wird eine Meldung
								zur Information des Bedienpersonals abgegeben.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_3_STOERUNGEN = new AttTurBetriebsZustand("Stoerungen", 		Byte
	.valueOf("3"));

	/**
	Automatische Bestimmung der Anzahl verfügbarer
								Stellplätze nicht möglich oder Wert soll von Hand überschrieben
								werden.
	<p>
	Im manuellen Betrieb können Sonderschaltungen im
								Rahmen der Anzeigemöglichkeiten durchgeführt werden. Dies umfasst
								die Abschaltung der Anzeige, aber auch die Anzeige von
								Freitexten, wenn bei Störung der Erfassung eine manuelle
								Bedienung unter Nutzung der Videokameras durchgeführt werden
								soll.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_4_SONDERSCHALTUNGEN_MANUELLER_BETRIEB = new AttTurBetriebsZustand("Sonderschaltungen / Manueller Betrieb", 		Byte
	.valueOf("4"));

	/**
	Der Parkplatz ist geschlossen.
	<p>
	Dies heißt nicht, dass über die Erfassungsgeräte
								kein
								Verkehr laufen könnte und demzufolge Belegungswerte ermittelt
								werden. Deshalb ist 'gesperrt' auch kein Belegtzustand, sondern
								ein Betriebszustand.
	</p>
	*/
	public static final AttTurBetriebsZustand ZUSTAND_5_GESPERRT = new AttTurBetriebsZustand("gesperrt", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTurBetriebsZustand getZustand(final 		Byte
	 value) {
		for (AttTurBetriebsZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTurBetriebsZustand getZustand(final String value) {
		for (AttTurBetriebsZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTurBetriebsZustand> getZustaende() {
		List<AttTurBetriebsZustand> list = new ArrayList<AttTurBetriebsZustand>();
		list.add(ZUSTAND_1N_INITIALISIERUNG);
		list.add(ZUSTAND_0_GERINGE_MITTLERE_STELLPLATZ_AUSLASTUNG);
		list.add(ZUSTAND_1_HOHE_STELLPLATZ_AUSLASTUNG);
		list.add(ZUSTAND_2_PLAUSIBILITAETSFEHLER);
		list.add(ZUSTAND_3_STOERUNGEN);
		list.add(ZUSTAND_4_SONDERSCHALTUNGEN_MANUELLER_BETRIEB);
		list.add(ZUSTAND_5_GESPERRT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TuR Betriebszustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTurBetriebsZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTurBetriebsZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
