/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt, welche Zählobjekte zu verwenden sind.
<p>
Hierbei bestehen zwei Möglichkeiten:
					&lt;numListe typ="1"&gt;
						&lt;listenPunkt&gt;Indirekter Bezug über das Auslesen der parametrierten
							Liste von
							ZählMethoden an einem Objekt vom Typ typ.turAnlage
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Direkter Bezug über eine dedizierte Liste
						&lt;&#47;listenPunkt&gt;
					&lt;&#47;numListe&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdTurZaehlApplikation extends AbstractKonfigurationsDatensatz<KdTurZaehlApplikation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
				> _tuRAnlage = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				> _zaehlMethoden = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				>(0, true);
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turAnlage.
			<p>
			
			</p>
			
			@return der Wert von TuRAnlage.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
				> getTuRAnlage() {
				return _tuRAnlage;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turZaehlMethode.
			<p>
			
			</p>
			
			@return der Wert von ZaehlMethoden.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				> getZaehlMethoden() {
				return _zaehlMethoden;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTuRAnlage = datum.getReferenceArray("TuRAnlage");
						arrayTuRAnlage.setLength(getTuRAnlage().size());
						for (int i = 0; i < arrayTuRAnlage.getLength(); ++i) {
							final Object soTuRAnlage = getTuRAnlage().get(i);
							final SystemObject tmpTuRAnlage;
							if (soTuRAnlage instanceof SystemObject) {
								tmpTuRAnlage = (SystemObject)soTuRAnlage;
							} else if(soTuRAnlage instanceof SystemObjekt){
								tmpTuRAnlage = ((SystemObjekt)soTuRAnlage).getSystemObject();
							} else{
								tmpTuRAnlage = null;
							}
							arrayTuRAnlage.getReferenceValue(i).setSystemObject(tmpTuRAnlage);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZaehlMethoden = datum.getReferenceArray("ZaehlMethoden");
						arrayZaehlMethoden.setLength(getZaehlMethoden().size());
						for (int i = 0; i < arrayZaehlMethoden.getLength(); ++i) {
							final Object soZaehlMethoden = getZaehlMethoden().get(i);
							final SystemObject tmpZaehlMethoden;
							if (soZaehlMethoden instanceof SystemObject) {
								tmpZaehlMethoden = (SystemObject)soZaehlMethoden;
							} else if(soZaehlMethoden instanceof SystemObjekt){
								tmpZaehlMethoden = ((SystemObjekt)soZaehlMethoden).getSystemObject();
							} else{
								tmpZaehlMethoden = null;
							}
							arrayZaehlMethoden.getReferenceValue(i).setSystemObject(tmpZaehlMethoden);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTuRAnlage = daten.getReferenceArray("TuRAnlage");
						for (int i = 0; i < arrayTuRAnlage.getLength(); ++i) {
							final long idTuRAnlage = daten.getReferenceArray("TuRAnlage").getReferenceValue(i).getId();
							final SystemObjekt tmpTuRAnlage;
							if (idTuRAnlage == 0) {
								tmpTuRAnlage = null;
							} else {
								final SystemObject soTuRAnlage = factory.getDav().getDataModel().getObject(idTuRAnlage);
								if (soTuRAnlage == null) {
										tmpTuRAnlage = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.impl.TurAnlageUngueltig(idTuRAnlage);
								} else {
									tmpTuRAnlage = factory.getModellobjekt(soTuRAnlage);
								}
							}
								getTuRAnlage().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
								) tmpTuRAnlage);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZaehlMethoden = daten.getReferenceArray("ZaehlMethoden");
						for (int i = 0; i < arrayZaehlMethoden.getLength(); ++i) {
							final long idZaehlMethoden = daten.getReferenceArray("ZaehlMethoden").getReferenceValue(i).getId();
							final SystemObjekt tmpZaehlMethoden;
							if (idZaehlMethoden == 0) {
								tmpZaehlMethoden = null;
							} else {
								final SystemObject soZaehlMethoden = factory.getDav().getDataModel().getObject(idZaehlMethoden);
								if (soZaehlMethoden == null) {
										tmpZaehlMethoden = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.impl.TurZaehlMethodeUngueltig(idZaehlMethoden);
								} else {
									tmpZaehlMethoden = factory.getModellobjekt(soZaehlMethoden);
								}
							}
								getZaehlMethoden().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
								) tmpZaehlMethoden);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._tuRAnlage = getTuRAnlage().clone();
						klon._zaehlMethoden = getZaehlMethoden().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.turZaehlApplikation";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdTurZaehlApplikation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
