/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt eine manuelle Zählung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface TurZaehlMethodeManuell extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.turZaehlMethodeManuell"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Zusammenfassung des numerischen Zählergebnisses (Anzahl
						Stellplätze) mit zusätzlichen Metainformationen analog zum
						Verkehrsmodell (Statusflags, Güte...).
	<p>
	
	</p>
	@return der Datensatz TurZaehlErgebnis.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.onlinedaten.OdTurZaehlErgebnis getOdTurZaehlErgebnis();
	
	/**
	Online-Attributgruppe zum Publizieren der aktuell
						verletzten Regeln. Leere Liste heißt: Alles in Ordnung.
	<p>
	
	</p>
	@return der Datensatz PloVerletzteRegeln.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlplausibilisierungobjektuebergreifend.onlinedaten.OdPloVerletzteRegeln getOdPloVerletzteRegeln();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Beschreibt das Ergebnis einer manuellen Zählung.
	<p>
	&lt;absatz&gt;Das Ergebnis wird an der atg.turZaehlErgebnis (siehe
							Supertyp) wieder publiziert und steht damit ALLEN
							Zählapplikationen zur Verfügung. Einen expliziten Aspekt
							asp.zustand gibt es deshalb nicht.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							&lt;wichtig&gt;Hintergrund:&lt;&#47;wichtig&gt;
							In einer konkreten Anlage wird man in der Regel mehrere
							Zählmethoden parallel implementieren und rechnen lassen und dann
							eines der Ergebnisse auswählen (siehe auch Attribut
							Auswahlkriterium an der atg.turParameterAnlage). Alle
							Zählmethoden-Objekte können sich nun auf den asp.messWertErsetzung
							anmelden, um das neueste Zählergebnis zu erhalten.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;Nach einem Neustart des Systems kann die zugehörige
							Zählaplikation über das Archiv den letzten Zählwert wieder
							erhalten und hat damit einen Startwert, der in jedem Fall besser
							ist als eine Annahme von 50% oder dergleichen. Je nachdem, wie alt
							der Zählwert ist, kann die Güte des publizierten Ergebnisses
							entsprechend gesetzt werden.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz TurZaehlMethodeManuell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.onlinedaten.OdTurZaehlMethodeManuell getOdTurZaehlMethodeManuell();
	
	/**
	Möglichkeit zur Definition einer zur Laufzeit änderbaren Menge von Regeln.
	<p>
	
	</p>
	@return der Datensatz PloRegelReferenzListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlplausibilisierungobjektuebergreifend.parameter.PdPloRegelReferenzListe getPdPloRegelReferenzListe();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
