/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt das Ergebnis einer manuellen Zählung.
<p>
&lt;absatz&gt;Das Ergebnis wird an der atg.turZaehlErgebnis (siehe
						Supertyp) wieder publiziert und steht damit ALLEN
						Zählapplikationen zur Verfügung. Einen expliziten Aspekt
						asp.zustand gibt es deshalb nicht.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						&lt;wichtig&gt;Hintergrund:&lt;&#47;wichtig&gt;
						In einer konkreten Anlage wird man in der Regel mehrere
						Zählmethoden parallel implementieren und rechnen lassen und dann
						eines der Ergebnisse auswählen (siehe auch Attribut
						Auswahlkriterium an der atg.turParameterAnlage). Alle
						Zählmethoden-Objekte können sich nun auf den asp.messWertErsetzung
						anmelden, um das neueste Zählergebnis zu erhalten.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;Nach einem Neustart des Systems kann die zugehörige
						Zählaplikation über das Archiv den letzten Zählwert wieder
						erhalten und hat damit einen Startwert, der in jedem Fall besser
						ist als eine Annahme von 50% oder dergleichen. Je nachdem, wie alt
						der Zählwert ist, kann die Güte des publizierten Ergebnisses
						entsprechend gesetzt werden.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTurZaehlMethodeManuell extends AbstractOnlineDatensatz<OdTurZaehlMethodeManuell.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Vorgabe,
				};
			}
	
			/**
			 * Vorgabe für eine Zustandsänderung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Vorgabe = new Aspekte("Vorgabe", "asp.vorgabe");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	Zeitstempel
				 _zeitstempel
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _wert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
				 _art
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
				 _korrektur
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 _guete
				= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				()
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _uebernehmen
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Zeitstempel.
			*/
				public 	Zeitstempel
				 getZeitstempel() {
				return _zeitstempel;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _zeitstempel der neue Wert von Zeitstempel.
			*/
			public void setZeitstempel(	Zeitstempel
			 _zeitstempel) {
				this._zeitstempel = _zeitstempel;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von Wert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getWert() {
				return _wert;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _wert der neue Wert von Wert.
			*/
			public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _wert) {
				this._wert = _wert;
			}
		
			/**
			Definiert, ob die verfügbaren oder die belegten
								Stellplätze einer Anlage gezählt &#47; errechnet &#47; gezeigt wurden bzw.
								werden.
			<p>
			Der Bediener soll so schnell, sicher und genau die Möglichkeit
								haben, die Anzahl verfügbarer Stellplätze in das System einzugeben.
								Deshalb werden grundsätzlich zwei Möglichkeiten vorgesehen:
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Belegte Stellplätze:&lt;&#47;wichtig&gt;
										Bei geringer bzw. mittlerer Stellplatzauslastung ist es
										einfacher, die im Parkbereich befindlichen (wenigen) Fahrzeuge zu
										zählen.
									&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Freie Stellplätze:&lt;&#47;wichtig&gt;
										Bei hoher Stellplatzauslastung ist es einfacher, die (wenigen)
										freien Stellplätze zu zählen.
									&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
			</p>
			
			@return der Wert von Art.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
				 getArt() {
				return _art;
			}
		
			/**
			Definiert, ob die verfügbaren oder die belegten
								Stellplätze einer Anlage gezählt &#47; errechnet &#47; gezeigt wurden bzw.
								werden.
			<p>
			Der Bediener soll so schnell, sicher und genau die Möglichkeit
								haben, die Anzahl verfügbarer Stellplätze in das System einzugeben.
								Deshalb werden grundsätzlich zwei Möglichkeiten vorgesehen:
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Belegte Stellplätze:&lt;&#47;wichtig&gt;
										Bei geringer bzw. mittlerer Stellplatzauslastung ist es
										einfacher, die im Parkbereich befindlichen (wenigen) Fahrzeuge zu
										zählen.
									&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Freie Stellplätze:&lt;&#47;wichtig&gt;
										Bei hoher Stellplatzauslastung ist es einfacher, die (wenigen)
										freien Stellplätze zu zählen.
									&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
			</p>
			
			@param _art der neue Wert von Art.
			*/
			public void setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
			 _art) {
				this._art = _art;
			}
		
			/**
			Bestimmt, ob bei einer Korrektur über die Angabe freier
								Stellplätze der zugrunde liegende Zählwert oder die logische Anzahl
								freier Stellplätze angepasst werden soll bzw. wurde.
			<p>
			Der Bediener soll die Möglichkeit haben, Korrekturwerte anhand der
								konkreten Situation qualifizieren zu können.
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Gezählt:&lt;&#47;wichtig&gt;
										Der Versand des Korrekturwertes soll eine Anpassung des aktuellen
										Rechenwertes der Auslastung zur Folge haben. Diese Option wählt
										der Bediener, wenn die Anzahl von Fahrzeugen aufgrund von
										Messungenauigkeiten der zugrunde liegenden Erfassungstechnik
										falsch bestimmt wurde oder ein Neustart der Anlage erfolgte.
									&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Logisch ermittelt:&lt;&#47;wichtig&gt;
										Der Versand des Korrekturwertes soll eine Anpassung des Wertes
										'Logische Kapazität' aus dem Parametersatz atg.turParameterAnlage
										am Anlagenobjekt zur Folge haben. Diese Option wählt der
										Bediener, wenn die Anzahl von Fahrzeugen im Parkbereich korrekt
										ist, die abgeleitete Anzahl verfügbarer Stellplätze aber trotzdem
										verkehrt ist. Dies kann der Fall sein, wenn:
										&lt;liste zeichen="punkt"&gt;
											&lt;listenPunkt&gt;Ein Lkw mehrere Parkbuchten benutzt (z.B. schräg
												steht)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Sich mehrere kleine Fahrzeuge (z.B. Sprinter) eine
												Parkbucht teilen
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Sich eine der oben beschriebenen Situationen
												auflöst.
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;liste&gt;
									&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
			</p>
			
			@return der Wert von Korrektur.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
				 getKorrektur() {
				return _korrektur;
			}
		
			/**
			Bestimmt, ob bei einer Korrektur über die Angabe freier
								Stellplätze der zugrunde liegende Zählwert oder die logische Anzahl
								freier Stellplätze angepasst werden soll bzw. wurde.
			<p>
			Der Bediener soll die Möglichkeit haben, Korrekturwerte anhand der
								konkreten Situation qualifizieren zu können.
								&lt;liste zeichen="punkt"&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Gezählt:&lt;&#47;wichtig&gt;
										Der Versand des Korrekturwertes soll eine Anpassung des aktuellen
										Rechenwertes der Auslastung zur Folge haben. Diese Option wählt
										der Bediener, wenn die Anzahl von Fahrzeugen aufgrund von
										Messungenauigkeiten der zugrunde liegenden Erfassungstechnik
										falsch bestimmt wurde oder ein Neustart der Anlage erfolgte.
									&lt;&#47;listenPunkt&gt;
									&lt;listenPunkt&gt;
										&lt;wichtig&gt;Logisch ermittelt:&lt;&#47;wichtig&gt;
										Der Versand des Korrekturwertes soll eine Anpassung des Wertes
										'Logische Kapazität' aus dem Parametersatz atg.turParameterAnlage
										am Anlagenobjekt zur Folge haben. Diese Option wählt der
										Bediener, wenn die Anzahl von Fahrzeugen im Parkbereich korrekt
										ist, die abgeleitete Anzahl verfügbarer Stellplätze aber trotzdem
										verkehrt ist. Dies kann der Fall sein, wenn:
										&lt;liste zeichen="punkt"&gt;
											&lt;listenPunkt&gt;Ein Lkw mehrere Parkbuchten benutzt (z.B. schräg
												steht)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Sich mehrere kleine Fahrzeuge (z.B. Sprinter) eine
												Parkbucht teilen
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Sich eine der oben beschriebenen Situationen
												auflöst.
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;liste&gt;
									&lt;&#47;listenPunkt&gt;
								&lt;&#47;liste&gt;
			</p>
			
			@param _korrektur der neue Wert von Korrektur.
			*/
			public void setKorrektur(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
			 _korrektur) {
				this._korrektur = _korrektur;
			}
		
			/**
			Güteinformationen zum Zählwert (Güte und Verfahren,
									welches zur Güteermittlung verwendet wurde).
			<p>
			
			</p>
			
			@return der Wert von Guete.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
				 getGuete() {
				return _guete;
			}
		
			/**
			Güteinformationen zum Zählwert (Güte und Verfahren,
									welches zur Güteermittlung verwendet wurde).
			<p>
			
			</p>
			
			@param _guete der neue Wert von Guete.
			*/
			public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete) {
				this._guete = _guete;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Uebernehmen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getUebernehmen() {
				return _uebernehmen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _uebernehmen der neue Wert von Uebernehmen.
			*/
			public void setUebernehmen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _uebernehmen) {
				this._uebernehmen = _uebernehmen;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("Zeitstempel").setMillis(getZeitstempel().getTime());
					// GanzzahlAttributTyp
					if (getWert() != null) {
		                if (getWert().isZustand()) {
		                    datum.getUnscaledValue("Wert").setText(getWert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Wert").set(getWert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getArt() != null) {
		                if (getArt().isZustand()) {
		                    datum.getUnscaledValue("Art").setText(getArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Art").set(getArt().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKorrektur() != null) {
		                if (getKorrektur().isZustand()) {
		                    datum.getUnscaledValue("Korrektur").setText(getKorrektur().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Korrektur").set(getKorrektur().getValue());
		                }
					}
					// AttributListenDefinition
						getGuete().bean2Atl(datum.getItem("Güte"), factory);
					// GanzzahlAttributTyp
					if (getUebernehmen() != null) {
		                if (getUebernehmen().isZustand()) {
		                    datum.getUnscaledValue("Übernehmen").setText(getUebernehmen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Übernehmen").set(getUebernehmen().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setZeitstempel(new
							Zeitstempel
							(daten.getTimeValue("Zeitstempel").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Wert").isState()) {
								setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("Wert").getText()));
							} else {
							setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("Wert").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Art").isState()) {
								setArt(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
								.getZustand(daten.getScaledValue("Art").getText()));
							} else {
							setArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtStellplatzAnzahl
							(daten.
								getUnscaledValue
							("Art").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Korrektur").isState()) {
								setKorrektur(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
								.getZustand(daten.getScaledValue("Korrektur").getText()));
							} else {
							setKorrektur(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurArtKorrektur
							(daten.
								getUnscaledValue
							("Korrektur").
									byteValue
							()));
							}
					// AttributListenDefinition
						getGuete().atl2Bean(daten.getItem("Güte"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Übernehmen").isState()) {
								setUebernehmen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Übernehmen").getText()));
							} else {
							setUebernehmen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Übernehmen").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setZeitstempel(getZeitstempel());
							klon.setWert(getWert());
							klon.setArt(getArt());
							klon.setKorrektur(getKorrektur());
							klon._guete = getGuete().clone();
							klon.setUebernehmen(getUebernehmen());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.turZaehlMethodeManuell";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTurZaehlMethodeManuell(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
