/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für eine TuR Anlage.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTurParameterAnlage extends AbstractParameterDatensatz<PdTurParameterAnlage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _physikalischeKapazitaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _logischeKapazitaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandVollEin
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandVollAus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandHoheAuslastungEin
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandHoheAuslastungAus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandFreiAus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 _belegtZustandFreiEin
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 _zielZustandBeiPlausibilitaetsFehler
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 _zielZustandBeiStoerung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttAuswahlKriterium
				 _auswahlKriterium
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				> _zaehlMethoden = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 _gueteUnzureichendAus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 _gueteUnzureichendEin
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst werden.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer, mit dem die Werte erfasst werden.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von PhysikalischeKapazitaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getPhysikalischeKapazitaet() {
				return _physikalischeKapazitaet;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _physikalischeKapazitaet der neue Wert von PhysikalischeKapazitaet.
			*/
			public void setPhysikalischeKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _physikalischeKapazitaet) {
				this._physikalischeKapazitaet = _physikalischeKapazitaet;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von LogischeKapazitaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getLogischeKapazitaet() {
				return _logischeKapazitaet;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _logischeKapazitaet der neue Wert von LogischeKapazitaet.
			*/
			public void setLogischeKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _logischeKapazitaet) {
				this._logischeKapazitaet = _logischeKapazitaet;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandVollEin.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandVollEin() {
				return _belegtZustandVollEin;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandVollEin der neue Wert von BelegtZustandVollEin.
			*/
			public void setBelegtZustandVollEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandVollEin) {
				this._belegtZustandVollEin = _belegtZustandVollEin;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandVollAus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandVollAus() {
				return _belegtZustandVollAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandVollAus der neue Wert von BelegtZustandVollAus.
			*/
			public void setBelegtZustandVollAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandVollAus) {
				this._belegtZustandVollAus = _belegtZustandVollAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandHoheAuslastungEin.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandHoheAuslastungEin() {
				return _belegtZustandHoheAuslastungEin;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandHoheAuslastungEin der neue Wert von BelegtZustandHoheAuslastungEin.
			*/
			public void setBelegtZustandHoheAuslastungEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandHoheAuslastungEin) {
				this._belegtZustandHoheAuslastungEin = _belegtZustandHoheAuslastungEin;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandHoheAuslastungAus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandHoheAuslastungAus() {
				return _belegtZustandHoheAuslastungAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandHoheAuslastungAus der neue Wert von BelegtZustandHoheAuslastungAus.
			*/
			public void setBelegtZustandHoheAuslastungAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandHoheAuslastungAus) {
				this._belegtZustandHoheAuslastungAus = _belegtZustandHoheAuslastungAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandFreiAus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandFreiAus() {
				return _belegtZustandFreiAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandFreiAus der neue Wert von BelegtZustandFreiAus.
			*/
			public void setBelegtZustandFreiAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandFreiAus) {
				this._belegtZustandFreiAus = _belegtZustandFreiAus;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@return der Wert von BelegtZustandFreiEin.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
				 getBelegtZustandFreiEin() {
				return _belegtZustandFreiEin;
			}
		
			/**
			Definiert einen 32-Bit-Integertyp zur Darstellung der
								Anzahl von Stellplätzen.
			<p>
			Die Definition läßt bewußt negative Werte zu, da die
								Zwischenergebnisse bzw. die Rohwerte verschiedener Algorithmen auch
								negativ werden können. In Pilotprojekten und zur Verfeinerung der
								Parametrierung der Anlage müssen diese Werte auch archiviert und in
								Protokollen betrachtet werden können.
			</p>
			
			@param _belegtZustandFreiEin der neue Wert von BelegtZustandFreiEin.
			*/
			public void setBelegtZustandFreiEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
			 _belegtZustandFreiEin) {
				this._belegtZustandFreiEin = _belegtZustandFreiEin;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@return der Wert von ZielZustandBeiPlausibilitaetsFehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 getZielZustandBeiPlausibilitaetsFehler() {
				return _zielZustandBeiPlausibilitaetsFehler;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@param _zielZustandBeiPlausibilitaetsFehler der neue Wert von ZielZustandBeiPlausibilitaetsFehler.
			*/
			public void setZielZustandBeiPlausibilitaetsFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
			 _zielZustandBeiPlausibilitaetsFehler) {
				this._zielZustandBeiPlausibilitaetsFehler = _zielZustandBeiPlausibilitaetsFehler;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@return der Wert von ZielZustandBeiStoerung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
				 getZielZustandBeiStoerung() {
				return _zielZustandBeiStoerung;
			}
		
			/**
			Definiert den Betriebszustand einer Anlage zur dynamischen
								Ermittlung und Anzeige freier (LKW-)Parkstände.
			<p>
			
			</p>
			
			@param _zielZustandBeiStoerung der neue Wert von ZielZustandBeiStoerung.
			*/
			public void setZielZustandBeiStoerung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
			 _zielZustandBeiStoerung) {
				this._zielZustandBeiStoerung = _zielZustandBeiStoerung;
			}
		
			/**
			Attributtyp zur Definition, wie aus einer Menge von Werten
								gleichen Typs einer ausgewählt werden kann. Anwendbar für
								numerische Werte und für alle Werte, für die sich die bekannten
								Operatoren '&lt;=', '&gt;=', '=' usw. sinnvoll definieren lassen.
			<p>
			
			</p>
			
			@return der Wert von AuswahlKriterium.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttAuswahlKriterium
				 getAuswahlKriterium() {
				return _auswahlKriterium;
			}
		
			/**
			Attributtyp zur Definition, wie aus einer Menge von Werten
								gleichen Typs einer ausgewählt werden kann. Anwendbar für
								numerische Werte und für alle Werte, für die sich die bekannten
								Operatoren '&lt;=', '&gt;=', '=' usw. sinnvoll definieren lassen.
			<p>
			
			</p>
			
			@param _auswahlKriterium der neue Wert von AuswahlKriterium.
			*/
			public void setAuswahlKriterium(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttAuswahlKriterium
			 _auswahlKriterium) {
				this._auswahlKriterium = _auswahlKriterium;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turZaehlMethode.
			<p>
			
			</p>
			
			@return der Wert von ZaehlMethoden.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
				> getZaehlMethoden() {
				return _zaehlMethoden;
			}
		
		
			/**
			Güteindex (0=unzverlässiger Wert, 1.0000 = maximal zuverlässiger Wert".
			<p>
			
			</p>
			
			@return der Wert von GueteUnzureichendAus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 getGueteUnzureichendAus() {
				return _gueteUnzureichendAus;
			}
		
			/**
			Güteindex (0=unzverlässiger Wert, 1.0000 = maximal zuverlässiger Wert".
			<p>
			
			</p>
			
			@param _gueteUnzureichendAus der neue Wert von GueteUnzureichendAus.
			*/
			public void setGueteUnzureichendAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _gueteUnzureichendAus) {
				this._gueteUnzureichendAus = _gueteUnzureichendAus;
			}
		
			/**
			Güteindex (0=unzverlässiger Wert, 1.0000 = maximal zuverlässiger Wert".
			<p>
			
			</p>
			
			@return der Wert von GueteUnzureichendEin.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
				 getGueteUnzureichendEin() {
				return _gueteUnzureichendEin;
			}
		
			/**
			Güteindex (0=unzverlässiger Wert, 1.0000 = maximal zuverlässiger Wert".
			<p>
			
			</p>
			
			@param _gueteUnzureichendEin der neue Wert von GueteUnzureichendEin.
			*/
			public void setGueteUnzureichendEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
			 _gueteUnzureichendEin) {
				this._gueteUnzureichendEin = _gueteUnzureichendEin;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getPhysikalischeKapazitaet() != null) {
		                if (getPhysikalischeKapazitaet().isZustand()) {
		                    datum.getUnscaledValue("PhysikalischeKapazitaet").setText(getPhysikalischeKapazitaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PhysikalischeKapazitaet").set(getPhysikalischeKapazitaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLogischeKapazitaet() != null) {
		                if (getLogischeKapazitaet().isZustand()) {
		                    datum.getUnscaledValue("LogischeKapazitaet").setText(getLogischeKapazitaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LogischeKapazitaet").set(getLogischeKapazitaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandVollEin() != null) {
		                if (getBelegtZustandVollEin().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandVollEin").setText(getBelegtZustandVollEin().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandVollEin").set(getBelegtZustandVollEin().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandVollAus() != null) {
		                if (getBelegtZustandVollAus().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandVollAus").setText(getBelegtZustandVollAus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandVollAus").set(getBelegtZustandVollAus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandHoheAuslastungEin() != null) {
		                if (getBelegtZustandHoheAuslastungEin().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandHoheAuslastungEin").setText(getBelegtZustandHoheAuslastungEin().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandHoheAuslastungEin").set(getBelegtZustandHoheAuslastungEin().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandHoheAuslastungAus() != null) {
		                if (getBelegtZustandHoheAuslastungAus().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandHoheAuslastungAus").setText(getBelegtZustandHoheAuslastungAus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandHoheAuslastungAus").set(getBelegtZustandHoheAuslastungAus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandFreiAus() != null) {
		                if (getBelegtZustandFreiAus().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandFreiAus").setText(getBelegtZustandFreiAus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandFreiAus").set(getBelegtZustandFreiAus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtZustandFreiEin() != null) {
		                if (getBelegtZustandFreiEin().isZustand()) {
		                    datum.getUnscaledValue("BelegtZustandFreiEin").setText(getBelegtZustandFreiEin().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BelegtZustandFreiEin").set(getBelegtZustandFreiEin().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZielZustandBeiPlausibilitaetsFehler() != null) {
		                if (getZielZustandBeiPlausibilitaetsFehler().isZustand()) {
		                    datum.getUnscaledValue("ZielZustandBeiPlausibilitaetsFehler").setText(getZielZustandBeiPlausibilitaetsFehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZielZustandBeiPlausibilitaetsFehler").set(getZielZustandBeiPlausibilitaetsFehler().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZielZustandBeiStoerung() != null) {
		                if (getZielZustandBeiStoerung().isZustand()) {
		                    datum.getUnscaledValue("ZielZustandBeiStoerung").setText(getZielZustandBeiStoerung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZielZustandBeiStoerung").set(getZielZustandBeiStoerung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAuswahlKriterium() != null) {
		                if (getAuswahlKriterium().isZustand()) {
		                    datum.getUnscaledValue("AuswahlKriterium").setText(getAuswahlKriterium().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AuswahlKriterium").set(getAuswahlKriterium().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZaehlMethoden = datum.getReferenceArray("ZaehlMethoden");
						arrayZaehlMethoden.setLength(getZaehlMethoden().size());
						for (int i = 0; i < arrayZaehlMethoden.getLength(); ++i) {
							final Object soZaehlMethoden = getZaehlMethoden().get(i);
							final SystemObject tmpZaehlMethoden;
							if (soZaehlMethoden instanceof SystemObject) {
								tmpZaehlMethoden = (SystemObject)soZaehlMethoden;
							} else if(soZaehlMethoden instanceof SystemObjekt){
								tmpZaehlMethoden = ((SystemObjekt)soZaehlMethoden).getSystemObject();
							} else{
								tmpZaehlMethoden = null;
							}
							arrayZaehlMethoden.getReferenceValue(i).setSystemObject(tmpZaehlMethoden);
						}
					// GanzzahlAttributTyp
					if (getGueteUnzureichendAus() != null) {
		                if (getGueteUnzureichendAus().isZustand()) {
		                    datum.getUnscaledValue("GüteUnzureichendAus").setText(getGueteUnzureichendAus().toString());
		                } else {
							datum.
							getScaledValue
		                	("GüteUnzureichendAus").set(getGueteUnzureichendAus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGueteUnzureichendEin() != null) {
		                if (getGueteUnzureichendEin().isZustand()) {
		                    datum.getUnscaledValue("GüteUnzureichendEin").setText(getGueteUnzureichendEin().toString());
		                } else {
							datum.
							getScaledValue
		                	("GüteUnzureichendEin").set(getGueteUnzureichendEin().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PhysikalischeKapazitaet").isState()) {
								setPhysikalischeKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("PhysikalischeKapazitaet").getText()));
							} else {
							setPhysikalischeKapazitaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("PhysikalischeKapazitaet").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LogischeKapazitaet").isState()) {
								setLogischeKapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("LogischeKapazitaet").getText()));
							} else {
							setLogischeKapazitaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("LogischeKapazitaet").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandVollEin").isState()) {
								setBelegtZustandVollEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandVollEin").getText()));
							} else {
							setBelegtZustandVollEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandVollEin").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandVollAus").isState()) {
								setBelegtZustandVollAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandVollAus").getText()));
							} else {
							setBelegtZustandVollAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandVollAus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandHoheAuslastungEin").isState()) {
								setBelegtZustandHoheAuslastungEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandHoheAuslastungEin").getText()));
							} else {
							setBelegtZustandHoheAuslastungEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandHoheAuslastungEin").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandHoheAuslastungAus").isState()) {
								setBelegtZustandHoheAuslastungAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandHoheAuslastungAus").getText()));
							} else {
							setBelegtZustandHoheAuslastungAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandHoheAuslastungAus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandFreiAus").isState()) {
								setBelegtZustandFreiAus(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandFreiAus").getText()));
							} else {
							setBelegtZustandFreiAus(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandFreiAus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BelegtZustandFreiEin").isState()) {
								setBelegtZustandFreiEin(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
								.getZustand(daten.getScaledValue("BelegtZustandFreiEin").getText()));
							} else {
							setBelegtZustandFreiEin(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurStellplatzAnzahl
							(daten.
								getUnscaledValue
							("BelegtZustandFreiEin").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZielZustandBeiPlausibilitaetsFehler").isState()) {
								setZielZustandBeiPlausibilitaetsFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
								.getZustand(daten.getScaledValue("ZielZustandBeiPlausibilitaetsFehler").getText()));
							} else {
							setZielZustandBeiPlausibilitaetsFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
							(daten.
								getUnscaledValue
							("ZielZustandBeiPlausibilitaetsFehler").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZielZustandBeiStoerung").isState()) {
								setZielZustandBeiStoerung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
								.getZustand(daten.getScaledValue("ZielZustandBeiStoerung").getText()));
							} else {
							setZielZustandBeiStoerung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.attribute.AttTurBetriebsZustand
							(daten.
								getUnscaledValue
							("ZielZustandBeiStoerung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AuswahlKriterium").isState()) {
								setAuswahlKriterium(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttAuswahlKriterium
								.getZustand(daten.getScaledValue("AuswahlKriterium").getText()));
							} else {
							setAuswahlKriterium(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttAuswahlKriterium
							(daten.
								getUnscaledValue
							("AuswahlKriterium").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZaehlMethoden = daten.getReferenceArray("ZaehlMethoden");
						for (int i = 0; i < arrayZaehlMethoden.getLength(); ++i) {
							final long idZaehlMethoden = daten.getReferenceArray("ZaehlMethoden").getReferenceValue(i).getId();
							final SystemObjekt tmpZaehlMethoden;
							if (idZaehlMethoden == 0) {
								tmpZaehlMethoden = null;
							} else {
								final SystemObject soZaehlMethoden = factory.getDav().getDataModel().getObject(idZaehlMethoden);
								if (soZaehlMethoden == null) {
										tmpZaehlMethoden = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.impl.TurZaehlMethodeUngueltig(idZaehlMethoden);
								} else {
									tmpZaehlMethoden = factory.getModellobjekt(soZaehlMethoden);
								}
							}
								getZaehlMethoden().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurZaehlMethode
								) tmpZaehlMethoden);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("GüteUnzureichendAus").isState()) {
								setGueteUnzureichendAus(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
								.getZustand(daten.getScaledValue("GüteUnzureichendAus").getText()));
							} else {
							setGueteUnzureichendAus(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							(daten.
								getScaledValue
							("GüteUnzureichendAus").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("GüteUnzureichendEin").isState()) {
								setGueteUnzureichendEin(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
								.getZustand(daten.getScaledValue("GüteUnzureichendEin").getText()));
							} else {
							setGueteUnzureichendEin(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttGueteIndex
							(daten.
								getScaledValue
							("GüteUnzureichendEin").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setT(getT());
							klon.setPhysikalischeKapazitaet(getPhysikalischeKapazitaet());
							klon.setLogischeKapazitaet(getLogischeKapazitaet());
							klon.setBelegtZustandVollEin(getBelegtZustandVollEin());
							klon.setBelegtZustandVollAus(getBelegtZustandVollAus());
							klon.setBelegtZustandHoheAuslastungEin(getBelegtZustandHoheAuslastungEin());
							klon.setBelegtZustandHoheAuslastungAus(getBelegtZustandHoheAuslastungAus());
							klon.setBelegtZustandFreiAus(getBelegtZustandFreiAus());
							klon.setBelegtZustandFreiEin(getBelegtZustandFreiEin());
							klon.setZielZustandBeiPlausibilitaetsFehler(getZielZustandBeiPlausibilitaetsFehler());
							klon.setZielZustandBeiStoerung(getZielZustandBeiStoerung());
							klon.setAuswahlKriterium(getAuswahlKriterium());
						klon._zaehlMethoden = getZaehlMethoden().clone();
							klon.setGueteUnzureichendAus(getGueteUnzureichendAus());
							klon.setGueteUnzureichendEin(getGueteUnzureichendEin());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.turParameterAnlage";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTurParameterAnlage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
