/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz, der das zu schaltende Programm in
					Abhängigkeit von verfügbarer Restkapazität und TuR Betriebszustand
					bestimmt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTurAbleitungSchaltprogramm extends AbstractParameterDatensatz<PdTurAbleitungSchaltprogramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
				 _tuRAnlage
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 _aspekt
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> _automatikProgramme = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				>(2, false);
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _fehlerProgramm
				;
				private String
				 _anzeigeTextBeiFrei
				= new String
				()
				;
				private String
				 _anzeigeTextBeiVoll
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
				> _anzeigeSpezifikationen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turAnlage.
			<p>
			
			</p>
			
			@return der Wert von TuRAnlage.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
				 getTuRAnlage() {
				return _tuRAnlage;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps:
								typ.turAnlage.
			<p>
			
			</p>
			
			@param _tuRAnlage der neue Wert von TuRAnlage.
			*/
			public void setTuRAnlage(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
			 _tuRAnlage) {
				this._tuRAnlage = _tuRAnlage;
			}
		
			/**
			Quellaspekt für die Daten am TuR-Anlagenobjekt.
			<p>
			Definiert den Aspekt der 'atg.turErmittelteAnzahlStellplätze' am
									Typ 'typ.turAnlage', an dem der anzuzeigende Wert der verfügbaren
									Stellplätze sowie der TuR Betriebszustand abgegriffen werden soll.
									Möglich sind:
									&lt;numListe typ="1"&gt;
										&lt;listenPunkt&gt;
											&lt;wichtig&gt;asp.messWertErsetzung:&lt;&#47;wichtig&gt;
											Der Standard.
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;
											&lt;wichtig&gt;asp.analyse:&lt;&#47;wichtig&gt;
											Die Rohdaten, nur für Testzwecke
										&lt;&#47;listenPunkt&gt;
									&lt;&#47;numListe&gt;
			</p>
			
			@return der Wert von Aspekt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 getAspekt() {
				return _aspekt;
			}
		
			/**
			Quellaspekt für die Daten am TuR-Anlagenobjekt.
			<p>
			Definiert den Aspekt der 'atg.turErmittelteAnzahlStellplätze' am
									Typ 'typ.turAnlage', an dem der anzuzeigende Wert der verfügbaren
									Stellplätze sowie der TuR Betriebszustand abgegriffen werden soll.
									Möglich sind:
									&lt;numListe typ="1"&gt;
										&lt;listenPunkt&gt;
											&lt;wichtig&gt;asp.messWertErsetzung:&lt;&#47;wichtig&gt;
											Der Standard.
										&lt;&#47;listenPunkt&gt;
										&lt;listenPunkt&gt;
											&lt;wichtig&gt;asp.analyse:&lt;&#47;wichtig&gt;
											Die Rohdaten, nur für Testzwecke
										&lt;&#47;listenPunkt&gt;
									&lt;&#47;numListe&gt;
			</p>
			
			@param _aspekt der neue Wert von Aspekt.
			*/
			public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt) {
				this._aspekt = _aspekt;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von AutomatikProgramme.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> getAutomatikProgramme() {
				return _automatikProgramme;
			}
		
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von FehlerProgramm.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getFehlerProgramm() {
				return _fehlerProgramm;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@param _fehlerProgramm der neue Wert von FehlerProgramm.
			*/
			public void setFehlerProgramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _fehlerProgramm) {
				this._fehlerProgramm = _fehlerProgramm;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeTextBeiFrei.
			*/
				public String
				 getAnzeigeTextBeiFrei() {
				return _anzeigeTextBeiFrei;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _anzeigeTextBeiFrei der neue Wert von AnzeigeTextBeiFrei.
			*/
			public void setAnzeigeTextBeiFrei(String
			 _anzeigeTextBeiFrei) {
				if (_anzeigeTextBeiFrei.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._anzeigeTextBeiFrei = _anzeigeTextBeiFrei;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeTextBeiVoll.
			*/
				public String
				 getAnzeigeTextBeiVoll() {
				return _anzeigeTextBeiVoll;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _anzeigeTextBeiVoll der neue Wert von AnzeigeTextBeiVoll.
			*/
			public void setAnzeigeTextBeiVoll(String
			 _anzeigeTextBeiVoll) {
				if (_anzeigeTextBeiVoll.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._anzeigeTextBeiVoll = _anzeigeTextBeiVoll;
			}
		
			/**
			Jede Anlage sollte mindestens eine Anzeige haben, nämlich
									die unmittelbar vor der Einfahrt (i.d.R. 350 m davor laut BASt).
									Weitere Anzeigen können weiter stromaufwärts liegen.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeSpezifikationen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
				> getAnzeigeSpezifikationen() {
				return _anzeigeSpezifikationen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Object soTuRAnlage = getTuRAnlage();
						final SystemObject tmpTuRAnlage;
							if (soTuRAnlage instanceof SystemObject) {
								tmpTuRAnlage = (SystemObject)soTuRAnlage;
							} else if(soTuRAnlage instanceof SystemObjekt){
								tmpTuRAnlage = ((SystemObjekt)soTuRAnlage).getSystemObject();
							} else{
								tmpTuRAnlage = null;
							}
						datum.getReferenceValue("TuRAnlage").setSystemObject(tmpTuRAnlage);
					// ObjektReferenzAttributTyp
						final Object soAspekt = getAspekt();
						final SystemObject tmpAspekt;
							if (soAspekt instanceof SystemObject) {
								tmpAspekt = (SystemObject)soAspekt;
							} else if(soAspekt instanceof SystemObjekt){
								tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
							} else{
								tmpAspekt = null;
							}
						datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAutomatikProgramme = datum.getReferenceArray("AutomatikProgramme");
						arrayAutomatikProgramme.setLength(getAutomatikProgramme().size());
						for (int i = 0; i < arrayAutomatikProgramme.getLength(); ++i) {
							final Object soAutomatikProgramme = getAutomatikProgramme().get(i);
							final SystemObject tmpAutomatikProgramme;
							if (soAutomatikProgramme instanceof SystemObject) {
								tmpAutomatikProgramme = (SystemObject)soAutomatikProgramme;
							} else if(soAutomatikProgramme instanceof SystemObjekt){
								tmpAutomatikProgramme = ((SystemObjekt)soAutomatikProgramme).getSystemObject();
							} else{
								tmpAutomatikProgramme = null;
							}
							arrayAutomatikProgramme.getReferenceValue(i).setSystemObject(tmpAutomatikProgramme);
						}
					// ObjektReferenzAttributTyp
						final Object soFehlerProgramm = getFehlerProgramm();
						final SystemObject tmpFehlerProgramm;
							if (soFehlerProgramm instanceof SystemObject) {
								tmpFehlerProgramm = (SystemObject)soFehlerProgramm;
							} else if(soFehlerProgramm instanceof SystemObjekt){
								tmpFehlerProgramm = ((SystemObjekt)soFehlerProgramm).getSystemObject();
							} else{
								tmpFehlerProgramm = null;
							}
						datum.getReferenceValue("FehlerProgramm").setSystemObject(tmpFehlerProgramm);
					// ZeichenkettenAttributTyp
					if (getAnzeigeTextBeiFrei() != null) {
						datum.getTextValue("AnzeigeTextBeiFrei").setText(getAnzeigeTextBeiFrei());
					}
					// ZeichenkettenAttributTyp
					if (getAnzeigeTextBeiVoll() != null) {
						datum.getTextValue("AnzeigeTextBeiVoll").setText(getAnzeigeTextBeiVoll());
					}
					// AttributListenDefinition
						final Data.Array arrayAnzeigeSpezifikationen = datum.getArray("AnzeigeSpezifikationen");
						arrayAnzeigeSpezifikationen.setLength(getAnzeigeSpezifikationen().size());
						for (int i = 0; i < arrayAnzeigeSpezifikationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
							 atl = getAnzeigeSpezifikationen().get(i);
							atl.bean2Atl(arrayAnzeigeSpezifikationen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final long idTuRAnlage = daten.getReferenceValue("TuRAnlage").getId();
						final SystemObjekt tmpTuRAnlage;
						if (idTuRAnlage == 0) {
							tmpTuRAnlage = null;
						} else {
							final SystemObject soTuRAnlage = factory.getDav().getDataModel().getObject(idTuRAnlage);
							if (soTuRAnlage == null) {
									tmpTuRAnlage = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.impl.TurAnlageUngueltig(idTuRAnlage);
							} else {
								tmpTuRAnlage = factory.getModellobjekt(soTuRAnlage);
							}
						}
						setTuRAnlage((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrltur.objekte.TurAnlage
						) tmpTuRAnlage);
					// ObjektReferenzAttributTyp
						final long idAspekt = daten.getReferenceValue("Aspekt").getId();
						final SystemObjekt tmpAspekt;
						if (idAspekt == 0) {
							tmpAspekt = null;
						} else {
							final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
							if (soAspekt == null) {
									tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
							} else {
								tmpAspekt = factory.getModellobjekt(soAspekt);
							}
						}
						setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
						) tmpAspekt);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAutomatikProgramme = daten.getReferenceArray("AutomatikProgramme");
						for (int i = 0; i < arrayAutomatikProgramme.getLength(); ++i) {
							final long idAutomatikProgramme = daten.getReferenceArray("AutomatikProgramme").getReferenceValue(i).getId();
							final SystemObjekt tmpAutomatikProgramme;
							if (idAutomatikProgramme == 0) {
								tmpAutomatikProgramme = null;
							} else {
								final SystemObject soAutomatikProgramme = factory.getDav().getDataModel().getObject(idAutomatikProgramme);
								if (soAutomatikProgramme == null) {
										tmpAutomatikProgramme = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idAutomatikProgramme);
								} else {
									tmpAutomatikProgramme = factory.getModellobjekt(soAutomatikProgramme);
								}
							}
								getAutomatikProgramme().set(i,(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
								) tmpAutomatikProgramme);
						}
					// ObjektReferenzAttributTyp
						final long idFehlerProgramm = daten.getReferenceValue("FehlerProgramm").getId();
						final SystemObjekt tmpFehlerProgramm;
						if (idFehlerProgramm == 0) {
							tmpFehlerProgramm = null;
						} else {
							final SystemObject soFehlerProgramm = factory.getDav().getDataModel().getObject(idFehlerProgramm);
							if (soFehlerProgramm == null) {
									tmpFehlerProgramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idFehlerProgramm);
							} else {
								tmpFehlerProgramm = factory.getModellobjekt(soFehlerProgramm);
							}
						}
						setFehlerProgramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpFehlerProgramm);
					// ZeichenkettenAttributTyp
						setAnzeigeTextBeiFrei(daten.getTextValue("AnzeigeTextBeiFrei").getText());
					// ZeichenkettenAttributTyp
						setAnzeigeTextBeiVoll(daten.getTextValue("AnzeigeTextBeiVoll").getText());
					// AttributListenDefinition
						final Data.Array arrayAnzeigeSpezifikationen = daten.getArray("AnzeigeSpezifikationen");
						for (int i = 0; i < arrayAnzeigeSpezifikationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlturschaltung.attribute.AtlTurAnzeigeSpezifikation
							 ();
							atl.atl2Bean(arrayAnzeigeSpezifikationen.getItem(i), factory);
							getAnzeigeSpezifikationen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setTuRAnlage(getTuRAnlage());
							klon.setAspekt(getAspekt());
						klon._automatikProgramme = getAutomatikProgramme().clone();
							klon.setFehlerProgramm(getFehlerProgramm());
							klon.setAnzeigeTextBeiFrei(getAnzeigeTextBeiFrei());
							klon.setAnzeigeTextBeiVoll(getAnzeigeTextBeiVoll());
						klon._anzeigeSpezifikationen = getAnzeigeSpezifikationen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.turAbleitungSchaltprogramm";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTurAbleitungSchaltprogramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
