/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition für die Attribute der Anzeige eines
					Programms oder einer Programmgruppe.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcProgrammgruppeDisplayFarbenUndSchriften implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			 _typ
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlBcDisplayFarbenUndSchriften
			 _displayAttribute
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlBcDisplayFarbenUndSchriften
			()
			;
	
		/**
		Typ des Schaltprogramms.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
			 getTyp() {
			return _typ;
		}
	
		/**
		Typ des Schaltprogramms.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Definition für die Attribute der Anzeige eines
							Objektes.
		<p>
		
		</p>
		
		@return der Wert von DisplayAttribute.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlBcDisplayFarbenUndSchriften
			 getDisplayAttribute() {
			return _displayAttribute;
		}
	
		/**
		Definition für die Attribute der Anzeige eines
							Objektes.
		<p>
		
		</p>
		
		@param _displayAttribute der neue Wert von DisplayAttribute.
		*/
		public void setDisplayAttribute(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlBcDisplayFarbenUndSchriften
		 _displayAttribute) {
			this._displayAttribute = _displayAttribute;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTyp = getTyp();
					final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
					datum.getReferenceValue("Typ").setSystemObject(tmpTyp);
				// AttributListenDefinition
					getDisplayAttribute().bean2Atl(datum.getItem("DisplayAttribute"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTyp = daten.getReferenceValue("Typ").getId();
					final SystemObjekt tmpTyp;
					if (idTyp == 0) {
						tmpTyp = null;
					} else {
						final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
						if (soTyp == null) {
								tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idTyp);
						} else {
							tmpTyp = factory.getModellobjekt(soTyp);
						}
					}
					setTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
					) tmpTyp);
				// AttributListenDefinition
					getDisplayAttribute().atl2Bean(daten.getItem("DisplayAttribute"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcProgrammgruppeDisplayFarbenUndSchriften clone() {
		AtlBcProgrammgruppeDisplayFarbenUndSchriften klon = new AtlBcProgrammgruppeDisplayFarbenUndSchriften();
		
						klon.setTyp(getTyp());
						klon._displayAttribute = getDisplayAttribute().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
