/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste von Schrittgruppen einer VBA.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVbaSchritt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private String
			 _bezeichnung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
			> _unterSchrittgruppen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
			>(0, true);
	
		/**
		Name des Schrittes (freier Text).
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name des Schrittes (freier Text).
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		(freier Text).
		<p>
		
		</p>
		
		@return der Wert von Bezeichnung.
		*/
			public String
			 getBezeichnung() {
			return _bezeichnung;
		}
	
		/**
		(freier Text).
		<p>
		
		</p>
		
		@param _bezeichnung der neue Wert von Bezeichnung.
		*/
		public void setBezeichnung(String
		 _bezeichnung) {
			if (_bezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bezeichnung = _bezeichnung;
		}
	
		/**
		Die einzelnen Unter-Schrittgruppen.
		<p>
		
		</p>
		
		@return der Wert von UnterSchrittgruppen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
			> getUnterSchrittgruppen() {
			return _unterSchrittgruppen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getBezeichnung() != null) {
					datum.getTextValue("Bezeichnung").setText(getBezeichnung());
				}
				// AttributListenDefinition
					final Data.Array arrayUnterSchrittgruppen = datum.getArray("UnterSchrittgruppen");
					arrayUnterSchrittgruppen.setLength(getUnterSchrittgruppen().size());
					for (int i = 0; i < arrayUnterSchrittgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
						 atl = getUnterSchrittgruppen().get(i);
						atl.bean2Atl(arrayUnterSchrittgruppen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setBezeichnung(daten.getTextValue("Bezeichnung").getText());
				// AttributListenDefinition
					final Data.Array arrayUnterSchrittgruppen = daten.getArray("UnterSchrittgruppen");
					for (int i = 0; i < arrayUnterSchrittgruppen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvba.attribute.AtlVbaSchrittGruppe
						 ();
						atl.atl2Bean(arrayUnterSchrittgruppen.getItem(i), factory);
						getUnterSchrittgruppen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaSchritt clone() {
		AtlVbaSchritt klon = new AtlVbaSchritt();
		
						klon.setName(getName());
						klon.setBezeichnung(getBezeichnung());
					klon._unterSchrittgruppen = getUnterSchrittgruppen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
