/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste von Fahrstreifenreferenzen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlFahrStreifenReferenzListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
			 _fahrStreifen
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.fahrStreifen.
		<p>
		
		</p>
		
		@return der Wert von FahrStreifen.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
			 getFahrStreifen() {
			return _fahrStreifen;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps:
							typ.fahrStreifen.
		<p>
		
		</p>
		
		@param _fahrStreifen der neue Wert von FahrStreifen.
		*/
		public void setFahrStreifen(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
		 _fahrStreifen) {
			this._fahrStreifen = _fahrStreifen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soFahrStreifen = getFahrStreifen();
					final SystemObject tmpFahrStreifen;
						if (soFahrStreifen instanceof SystemObject) {
							tmpFahrStreifen = (SystemObject)soFahrStreifen;
						} else if(soFahrStreifen instanceof SystemObjekt){
							tmpFahrStreifen = ((SystemObjekt)soFahrStreifen).getSystemObject();
						} else{
							tmpFahrStreifen = null;
						}
					datum.getReferenceValue("FahrStreifen").setSystemObject(tmpFahrStreifen);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idFahrStreifen = daten.getReferenceValue("FahrStreifen").getId();
					final SystemObjekt tmpFahrStreifen;
					if (idFahrStreifen == 0) {
						tmpFahrStreifen = null;
					} else {
						final SystemObject soFahrStreifen = factory.getDav().getDataModel().getObject(idFahrStreifen);
						if (soFahrStreifen == null) {
								tmpFahrStreifen = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.FahrStreifenUngueltig(idFahrStreifen);
						} else {
							tmpFahrStreifen = factory.getModellobjekt(soFahrStreifen);
						}
					}
					setFahrStreifen((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen
					) tmpFahrStreifen);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFahrStreifenReferenzListe clone() {
		AtlFahrStreifenReferenzListe klon = new AtlFahrStreifenReferenzListe();
		
						klon.setFahrStreifen(getFahrStreifen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
