/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die eine Maske zu einer Kamera beschreibt, also ein Bild gleicher Auflösung, welches überlagert wird, um bestimmte Bereiche hervorzuheben oder auszublenden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlKameraMaske implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "Neue eindeutige, generierte Id")
			private String
			 _id
			= new String
			()
			;
			@Defaultwert(wert = "Neue Maske")
			private String
			 _bezeichnung
			= new String
			()
			;
			@Defaultwert(wert = "http://kameraserver/masken/default.png")
			private String
			 _url
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> _imageBlob = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			>(0, true);
	
		/**
		Eindeutige Id zur Identifizierung dieses Eintrags innerhalb der Liste, also eine Pseudo-Pid.
		<p>
		
		</p>
		
		@return der Wert von Id.
		*/
			public String
			 getId() {
			return _id;
		}
	
		/**
		Eindeutige Id zur Identifizierung dieses Eintrags innerhalb der Liste, also eine Pseudo-Pid.
		<p>
		
		</p>
		
		@param _id der neue Wert von Id.
		*/
		public void setId(String
		 _id) {
			if (_id.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._id = _id;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Bezeichnung.
		*/
			public String
			 getBezeichnung() {
			return _bezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _bezeichnung der neue Wert von Bezeichnung.
		*/
		public void setBezeichnung(String
		 _bezeichnung) {
			if (_bezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bezeichnung = _bezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Url.
		*/
			public String
			 getUrl() {
			return _url;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _url der neue Wert von Url.
		*/
		public void setUrl(String
		 _url) {
			if (_url.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._url = _url;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -128 bis 127.
		<p>
		
		</p>
		
		@return der Wert von ImageBlob.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> getImageBlob() {
			return _imageBlob;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getId() != null) {
					datum.getTextValue("Id").setText(getId());
				}
				// ZeichenkettenAttributTyp
				if (getBezeichnung() != null) {
					datum.getTextValue("Bezeichnung").setText(getBezeichnung());
				}
				// ZeichenkettenAttributTyp
				if (getUrl() != null) {
					datum.getTextValue("Url").setText(getUrl());
				}
				// GanzzahlAttributTyp
				if (getImageBlob() != null) {
					final Data.NumberArray arrayImageBlob = datum.
						getUnscaledArray
						("ImageBlob");
					arrayImageBlob.setLength(getImageBlob().size());
					for (int i = 0; i < arrayImageBlob.getLength(); ++i) {
						arrayImageBlob.getValue(i).set(getImageBlob().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setId(daten.getTextValue("Id").getText());
				// ZeichenkettenAttributTyp
					setBezeichnung(daten.getTextValue("Bezeichnung").getText());
				// ZeichenkettenAttributTyp
					setUrl(daten.getTextValue("Url").getText());
				// GanzzahlAttributTyp
					final Data.NumberArray arrayImageBlob = daten.
						getUnscaledArray
					("ImageBlob");
	
					for (int i = 0; i < arrayImageBlob.getLength(); ++i) {
	                    getImageBlob().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
	                    (arrayImageBlob.
	                    		byteValue
	                    (i)));
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlKameraMaske clone() {
		AtlKameraMaske klon = new AtlKameraMaske();
		
						klon.setId(getId());
						klon.setBezeichnung(getBezeichnung());
						klon.setUrl(getUrl());
					klon._imageBlob = getImageBlob().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
