/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eine Liste von Eventreferenzen der VipT Module.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVbaEventVipt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VbaEventVipt
			 _vbaEventViptReferenz
			;
	
		/**
		Referenz auf ein Objekt vom Typ "typ.vbaEvent.vipt".
		<p>
		
		</p>
		
		@return der Wert von VbaEventViptReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VbaEventVipt
			 getVbaEventViptReferenz() {
			return _vbaEventViptReferenz;
		}
	
		/**
		Referenz auf ein Objekt vom Typ "typ.vbaEvent.vipt".
		<p>
		
		</p>
		
		@param _vbaEventViptReferenz der neue Wert von VbaEventViptReferenz.
		*/
		public void setVbaEventViptReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VbaEventVipt
		 _vbaEventViptReferenz) {
			this._vbaEventViptReferenz = _vbaEventViptReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soVbaEventViptReferenz = getVbaEventViptReferenz();
					final SystemObject tmpVbaEventViptReferenz;
						if (soVbaEventViptReferenz instanceof SystemObject) {
							tmpVbaEventViptReferenz = (SystemObject)soVbaEventViptReferenz;
						} else if(soVbaEventViptReferenz instanceof SystemObjekt){
							tmpVbaEventViptReferenz = ((SystemObjekt)soVbaEventViptReferenz).getSystemObject();
						} else{
							tmpVbaEventViptReferenz = null;
						}
					datum.getReferenceValue("VbaEventViptReferenz").setSystemObject(tmpVbaEventViptReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idVbaEventViptReferenz = daten.getReferenceValue("VbaEventViptReferenz").getId();
					final SystemObjekt tmpVbaEventViptReferenz;
					if (idVbaEventViptReferenz == 0) {
						tmpVbaEventViptReferenz = null;
					} else {
						final SystemObject soVbaEventViptReferenz = factory.getDav().getDataModel().getObject(idVbaEventViptReferenz);
						if (soVbaEventViptReferenz == null) {
								tmpVbaEventViptReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.VbaEventViptUngueltig(idVbaEventViptReferenz);
						} else {
							tmpVbaEventViptReferenz = factory.getModellobjekt(soVbaEventViptReferenz);
						}
					}
					setVbaEventViptReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VbaEventVipt
					) tmpVbaEventViptReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventVipt clone() {
		AtlVbaEventVipt klon = new AtlVbaEventVipt();
		
						klon.setVbaEventViptReferenz(getVbaEventViptReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
