/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Liste auf Referenzen von VideoViews.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVideoViews implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
			 _videoViewReferenz
			;
	
		/**
		Referenz auf einen Video View.
		<p>
		
		</p>
		
		@return der Wert von VideoViewReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
			 getVideoViewReferenz() {
			return _videoViewReferenz;
		}
	
		/**
		Referenz auf einen Video View.
		<p>
		
		</p>
		
		@param _videoViewReferenz der neue Wert von VideoViewReferenz.
		*/
		public void setVideoViewReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
		 _videoViewReferenz) {
			this._videoViewReferenz = _videoViewReferenz;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soVideoViewReferenz = getVideoViewReferenz();
					final SystemObject tmpVideoViewReferenz;
						if (soVideoViewReferenz instanceof SystemObject) {
							tmpVideoViewReferenz = (SystemObject)soVideoViewReferenz;
						} else if(soVideoViewReferenz instanceof SystemObjekt){
							tmpVideoViewReferenz = ((SystemObjekt)soVideoViewReferenz).getSystemObject();
						} else{
							tmpVideoViewReferenz = null;
						}
					datum.getReferenceValue("VideoViewReferenz").setSystemObject(tmpVideoViewReferenz);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idVideoViewReferenz = daten.getReferenceValue("VideoViewReferenz").getId();
					final SystemObjekt tmpVideoViewReferenz;
					if (idVideoViewReferenz == 0) {
						tmpVideoViewReferenz = null;
					} else {
						final SystemObject soVideoViewReferenz = factory.getDav().getDataModel().getObject(idVideoViewReferenz);
						if (soVideoViewReferenz == null) {
								tmpVideoViewReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.VideoViewUngueltig(idVideoViewReferenz);
						} else {
							tmpVideoViewReferenz = factory.getModellobjekt(soVideoViewReferenz);
						}
					}
					setVideoViewReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
					) tmpVideoViewReferenz);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVideoViews clone() {
		AtlVideoViews klon = new AtlVideoViews();
		
						klon.setVideoViewReferenz(getVideoViewReferenz());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
