/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt, in welchem Zustand sich die Kamera befindet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AttKameraZustand extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Der Zustand ist nicht bekannt.
	<p>
	
	</p>
	*/
	public static final AttKameraZustand ZUSTAND_1N_UNBEKANNT = new AttKameraZustand("unbekannt", 		Short
	.valueOf("-1"));

	/**
	Die Kamera arbeitet korrekt.
	<p>
	
	</p>
	*/
	public static final AttKameraZustand ZUSTAND_0_OK = new AttKameraZustand("OK", 		Short
	.valueOf("0"));

	/**
	Die Kamera ist gestört.
	<p>
	
	</p>
	*/
	public static final AttKameraZustand ZUSTAND_1_GESTOERT = new AttKameraZustand("Gestört", 		Short
	.valueOf("1"));

	/**
	Die Kamera konnte nicht gefunden werden.
	<p>
	
	</p>
	*/
	public static final AttKameraZustand ZUSTAND_404_KAMERA_NICHT_GEFUNDEN = new AttKameraZustand("Kamera nicht gefunden", 		Short
	.valueOf("404"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKameraZustand getZustand(final 		Short
	 value) {
		for (AttKameraZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKameraZustand getZustand(final String value) {
		for (AttKameraZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKameraZustand> getZustaende() {
		List<AttKameraZustand> list = new ArrayList<AttKameraZustand>();
		list.add(ZUSTAND_1N_UNBEKANNT);
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1_GESTOERT);
		list.add(ZUSTAND_404_KAMERA_NICHT_GEFUNDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KameraZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKameraZustand(final 		Short
	 value) {
		super(value);
	}
	
	private AttKameraZustand(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
