/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eventtypen in Anlehnung an die Traficon Spezifikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttVbaEventViptTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_1_STAU_ENTDECKT = new AttVbaEventViptTyp("Stau entdeckt", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_2_FAHRZEUG_AUF_EINER_NICHT_FREIGEGEBENER_FAHRBAHN = new AttVbaEventViptTyp("Fahrzeug auf einer nicht freigegebener Fahrbahn", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_3_DETEKTOR_KOMMUNIKATIONSFEHLER = new AttVbaEventViptTyp("Detektor-Kommunikationsfehler", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_4_STEHENGEBLIEBENES_FAHRZEUG = new AttVbaEventViptTyp("stehengebliebenes Fahrzeug", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_5_GESCHWINDIKEITSSCHWANKUNG = new AttVbaEventViptTyp("Geschwindikeitsschwankung", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_6_GEISTERFAHRER = new AttVbaEventViptTyp("Geisterfahrer", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_7_RAUCH_ENTDECKT = new AttVbaEventViptTyp("Rauch entdeckt", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_8_GESTOERTES_VIDEOSIGNAL = new AttVbaEventViptTyp("gestörtes Videosignal", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_9_EREIGNIS_AM_DIGITALEN_EINGANG = new AttVbaEventViptTyp("Ereignis am digitalen Eingang", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_10_VON_EINEM_NUTZER_AUSGELOESTES_ALARMEREIGNIS = new AttVbaEventViptTyp("von einem Nutzer ausgelöstes Alarmereignis", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_11_DIE_KONFIGURATION_DES_VIP_T_MODULS_HAT_SICH_GEAENDERT = new AttVbaEventViptTyp("die Konfiguration des Vip-T Moduls hat sich geändert", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_12_AKTIVITAET_IN_EINER_VIP_T_DETEKTORZONE = new AttVbaEventViptTyp("Aktivität in einer Vip-T Detektorzone", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_13_DIE_AUSGABE_DES_VIP_T_HAT_SICH_GEAENDERT = new AttVbaEventViptTyp("die Ausgabe des Vip-T hat sich geändert", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_14_EINE_PHASE_HAT_SICH_GEAENDERT = new AttVbaEventViptTyp("eine Phase hat sich geändert", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_15_NICHT_IMPLEMENTIERT = new AttVbaEventViptTyp("nicht implementiert", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_16_DAS_VIP_T_MODUL_WURDE_REBOOTET = new AttVbaEventViptTyp("das Vip-T Modul wurde rebootet", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_17_DIE_VIP_T_SOFTWARE_WURDE_AKTUALISIERT = new AttVbaEventViptTyp("die Vip-T Software wurde aktualisiert", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_18_GEAENDERTER_RECALL_STATE = new AttVbaEventViptTyp("geänderter Recall state", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_19_SOFTWARE_UPGRADE_FEHLGESCHLAGEN = new AttVbaEventViptTyp("Software upgrade fehlgeschlagen", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_20_KEINE_REDUNDANTE_STROMVERSORGUNG = new AttVbaEventViptTyp("keine redundante Stromversorgung", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_21_PTZ_CAMERA_OUT_OF_HOME_POSITION = new AttVbaEventViptTyp("PTZ Camera out of home position", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_22_FUSSGAENGER_ENTDECKT = new AttVbaEventViptTyp("Fussgänger entdeckt", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_23_BEWEGUNG_DER_KAMERA_ENTDECKT = new AttVbaEventViptTyp("Bewegung der Kamera entdeckt", 		Byte
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_24_FALLEN_OBJECT_DETECTEDD = new AttVbaEventViptTyp("Fallen object detectedd", 		Byte
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_25_LANGSAMES_FAHRZEUG_ENTDECKT = new AttVbaEventViptTyp("langsames Fahrzeug entdeckt", 		Byte
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_26_FAHRZEUG_MIT_UEBERHOEHTER_GESCHWINDIGKEIT_ENTDECKT = new AttVbaEventViptTyp("Fahrzeug mit überhöhter Geschwindigkeit entdeckt", 		Byte
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_27_VERBINDUNG_ZUM_E_COM_VERLOREN = new AttVbaEventViptTyp("Verbindung zum E-Com verloren", 		Byte
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_28_REDUNDANTER_KOMMUNIKATIONSFEHLER = new AttVbaEventViptTyp("redundanter Kommunikationsfehler", 		Byte
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_29_GEAENDERTE_INHIBITION = new AttVbaEventViptTyp("geänderte Inhibition", 		Byte
	.valueOf("29"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_30_VERBOTENES_EREIGNIS = new AttVbaEventViptTyp("verbotenes Ereignis", 		Byte
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttVbaEventViptTyp ZUSTAND_37_FAHRZEUG_AUF_NICHT_FREIGEGEBENER_FAHRBAHN = new AttVbaEventViptTyp("Fahrzeug auf nicht freigegebener Fahrbahn", 		Byte
	.valueOf("37"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttVbaEventViptTyp getZustand(final 		Byte
	 value) {
		for (AttVbaEventViptTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttVbaEventViptTyp getZustand(final String value) {
		for (AttVbaEventViptTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttVbaEventViptTyp> getZustaende() {
		List<AttVbaEventViptTyp> list = new ArrayList<AttVbaEventViptTyp>();
		list.add(ZUSTAND_1_STAU_ENTDECKT);
		list.add(ZUSTAND_2_FAHRZEUG_AUF_EINER_NICHT_FREIGEGEBENER_FAHRBAHN);
		list.add(ZUSTAND_3_DETEKTOR_KOMMUNIKATIONSFEHLER);
		list.add(ZUSTAND_4_STEHENGEBLIEBENES_FAHRZEUG);
		list.add(ZUSTAND_5_GESCHWINDIKEITSSCHWANKUNG);
		list.add(ZUSTAND_6_GEISTERFAHRER);
		list.add(ZUSTAND_7_RAUCH_ENTDECKT);
		list.add(ZUSTAND_8_GESTOERTES_VIDEOSIGNAL);
		list.add(ZUSTAND_9_EREIGNIS_AM_DIGITALEN_EINGANG);
		list.add(ZUSTAND_10_VON_EINEM_NUTZER_AUSGELOESTES_ALARMEREIGNIS);
		list.add(ZUSTAND_11_DIE_KONFIGURATION_DES_VIP_T_MODULS_HAT_SICH_GEAENDERT);
		list.add(ZUSTAND_12_AKTIVITAET_IN_EINER_VIP_T_DETEKTORZONE);
		list.add(ZUSTAND_13_DIE_AUSGABE_DES_VIP_T_HAT_SICH_GEAENDERT);
		list.add(ZUSTAND_14_EINE_PHASE_HAT_SICH_GEAENDERT);
		list.add(ZUSTAND_15_NICHT_IMPLEMENTIERT);
		list.add(ZUSTAND_16_DAS_VIP_T_MODUL_WURDE_REBOOTET);
		list.add(ZUSTAND_17_DIE_VIP_T_SOFTWARE_WURDE_AKTUALISIERT);
		list.add(ZUSTAND_18_GEAENDERTER_RECALL_STATE);
		list.add(ZUSTAND_19_SOFTWARE_UPGRADE_FEHLGESCHLAGEN);
		list.add(ZUSTAND_20_KEINE_REDUNDANTE_STROMVERSORGUNG);
		list.add(ZUSTAND_21_PTZ_CAMERA_OUT_OF_HOME_POSITION);
		list.add(ZUSTAND_22_FUSSGAENGER_ENTDECKT);
		list.add(ZUSTAND_23_BEWEGUNG_DER_KAMERA_ENTDECKT);
		list.add(ZUSTAND_24_FALLEN_OBJECT_DETECTEDD);
		list.add(ZUSTAND_25_LANGSAMES_FAHRZEUG_ENTDECKT);
		list.add(ZUSTAND_26_FAHRZEUG_MIT_UEBERHOEHTER_GESCHWINDIGKEIT_ENTDECKT);
		list.add(ZUSTAND_27_VERBINDUNG_ZUM_E_COM_VERLOREN);
		list.add(ZUSTAND_28_REDUNDANTER_KOMMUNIKATIONSFEHLER);
		list.add(ZUSTAND_29_GEAENDERTE_INHIBITION);
		list.add(ZUSTAND_30_VERBOTENES_EREIGNIS);
		list.add(ZUSTAND_37_FAHRZEUG_AUF_NICHT_FREIGEGEBENER_FAHRBAHN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttVbaEventViptTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttVbaEventViptTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
