/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften einer Detektor Zone.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDetektorZoneEigenschaften extends AbstractKonfigurationsDatensatz<KdDetektorZoneEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
				> _fahrstreifenreferenzliste = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
				 _zoneID
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
				> _vbaEventVipt = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
				>(0, true);
		
			/**
			Liste von Fahrstreifenreferenzen.
			<p>
			
			</p>
			
			@return der Wert von Fahrstreifenreferenzliste.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
				> getFahrstreifenreferenzliste() {
				return _fahrstreifenreferenzliste;
			}
		
		
			/**
			Positive ganze Zahl mit 16 Bits, also im Bereich 0 bis
								65535.
			<p>
			
			</p>
			
			@return der Wert von ZoneID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
				 getZoneID() {
				return _zoneID;
			}
		
			/**
			Positive ganze Zahl mit 16 Bits, also im Bereich 0 bis
								65535.
			<p>
			
			</p>
			
			@param _zoneID der neue Wert von ZoneID.
			*/
			public void setZoneID(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
			 _zoneID) {
				this._zoneID = _zoneID;
			}
		
			/**
			Eine Liste von Eventreferenzen der VipT Module.
			<p>
			
			</p>
			
			@return der Wert von VbaEventVipt.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
				> getVbaEventVipt() {
				return _vbaEventVipt;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayFahrstreifenreferenzliste = datum.getArray("Fahrstreifenreferenzliste");
						arrayFahrstreifenreferenzliste.setLength(getFahrstreifenreferenzliste().size());
						for (int i = 0; i < arrayFahrstreifenreferenzliste.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
							 atl = getFahrstreifenreferenzliste().get(i);
							atl.bean2Atl(arrayFahrstreifenreferenzliste.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getZoneID() != null) {
		                if (getZoneID().isZustand()) {
		                    datum.getUnscaledValue("ZoneID").setText(getZoneID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZoneID").set(getZoneID().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayVbaEventVipt = datum.getArray("VbaEventVipt");
						arrayVbaEventVipt.setLength(getVbaEventVipt().size());
						for (int i = 0; i < arrayVbaEventVipt.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
							 atl = getVbaEventVipt().get(i);
							atl.bean2Atl(arrayVbaEventVipt.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayFahrstreifenreferenzliste = daten.getArray("Fahrstreifenreferenzliste");
						for (int i = 0; i < arrayFahrstreifenreferenzliste.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlFahrStreifenReferenzListe
							 ();
							atl.atl2Bean(arrayFahrstreifenreferenzliste.getItem(i), factory);
							getFahrstreifenreferenzliste().add(atl);
						}
					// GanzzahlAttributTyp
							setZoneID(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttZahlPositiv16Bit
							(daten.
								getUnscaledValue
							("ZoneID").
									intValue
							()));
					// AttributListenDefinition
						final Data.Array arrayVbaEventVipt = daten.getArray("VbaEventVipt");
						for (int i = 0; i < arrayVbaEventVipt.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.attribute.AtlVbaEventVipt
							 ();
							atl.atl2Bean(arrayVbaEventVipt.getItem(i), factory);
							getVbaEventVipt().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._fahrstreifenreferenzliste = getFahrstreifenreferenzliste().clone();
							klon.setZoneID(getZoneID());
						klon._vbaEventVipt = getVbaEventVipt().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.detektorZoneEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDetektorZoneEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
