/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung der statischen Eigenschaften eines DTVLink Targets ( Bedienstation).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDtvlinktarget extends AbstractKonfigurationsDatensatz<KdDtvlinktarget.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _description
				= new String
				()
				;
				private String
				 _type
				= new String
				()
				;
				private String
				 _iPAddress
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _port
				;
				private String
				 _mode
				= new String
				()
				;
				private String
				 _bindAddress
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _tTL
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Description.
			*/
				public String
				 getDescription() {
				return _description;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _description der neue Wert von Description.
			*/
			public void setDescription(String
			 _description) {
				if (_description.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._description = _description;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Type.
			*/
				public String
				 getType() {
				return _type;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _type der neue Wert von Type.
			*/
			public void setType(String
			 _type) {
				if (_type.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._type = _type;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von IPAddress.
			*/
				public String
				 getIPAddress() {
				return _iPAddress;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _iPAddress der neue Wert von IPAddress.
			*/
			public void setIPAddress(String
			 _iPAddress) {
				if (_iPAddress.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._iPAddress = _iPAddress;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von Port.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getPort() {
				return _port;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _port der neue Wert von Port.
			*/
			public void setPort(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _port) {
				this._port = _port;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Mode.
			*/
				public String
				 getMode() {
				return _mode;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _mode der neue Wert von Mode.
			*/
			public void setMode(String
			 _mode) {
				if (_mode.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._mode = _mode;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BindAddress.
			*/
				public String
				 getBindAddress() {
				return _bindAddress;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bindAddress der neue Wert von BindAddress.
			*/
			public void setBindAddress(String
			 _bindAddress) {
				if (_bindAddress.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bindAddress = _bindAddress;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@return der Wert von TTL.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getTTL() {
				return _tTL;
			}
		
			/**
			Positive ganze Zahl.
			<p>
			
			</p>
			
			@param _tTL der neue Wert von TTL.
			*/
			public void setTTL(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _tTL) {
				this._tTL = _tTL;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getDescription() != null) {
						datum.getTextValue("Description").setText(getDescription());
					}
					// ZeichenkettenAttributTyp
					if (getType() != null) {
						datum.getTextValue("Type").setText(getType());
					}
					// ZeichenkettenAttributTyp
					if (getIPAddress() != null) {
						datum.getTextValue("IPAddress").setText(getIPAddress());
					}
					// GanzzahlAttributTyp
					if (getPort() != null) {
		                if (getPort().isZustand()) {
		                    datum.getUnscaledValue("Port").setText(getPort().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Port").set(getPort().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getMode() != null) {
						datum.getTextValue("Mode").setText(getMode());
					}
					// ZeichenkettenAttributTyp
					if (getBindAddress() != null) {
						datum.getTextValue("BindAddress").setText(getBindAddress());
					}
					// GanzzahlAttributTyp
					if (getTTL() != null) {
		                if (getTTL().isZustand()) {
		                    datum.getUnscaledValue("TTL").setText(getTTL().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TTL").set(getTTL().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setDescription(daten.getTextValue("Description").getText());
					// ZeichenkettenAttributTyp
						setType(daten.getTextValue("Type").getText());
					// ZeichenkettenAttributTyp
						setIPAddress(daten.getTextValue("IPAddress").getText());
					// GanzzahlAttributTyp
							setPort(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("Port").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setMode(daten.getTextValue("Mode").getText());
					// ZeichenkettenAttributTyp
						setBindAddress(daten.getTextValue("BindAddress").getText());
					// GanzzahlAttributTyp
							setTTL(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("TTL").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDescription(getDescription());
							klon.setType(getType());
							klon.setIPAddress(getIPAddress());
							klon.setPort(getPort());
							klon.setMode(getMode());
							klon.setBindAddress(getBindAddress());
							klon.setTTL(getTTL());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dtvlinktarget";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDtvlinktarget(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
