/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Encodermodul der Firma Traficon. Wird zur detektion von Ereignissen im Strassenverkehr verwendet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface ViptModul extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.Kamera
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.viptModul"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe für die aktuellen Werte einer Kamera, sofern nicht als Ist-Parameter erfragbar.
	<p>
	
	</p>
	@return der Datensatz KameraAktuelleWerte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.onlinedaten.OdKameraAktuelleWerte getOdKameraAktuelleWerte();
	
	/**
	Attributgruppe für die Betriebsparameter der einer Video-Kamera.
	<p>
	
	</p>
	@return der Datensatz KameraBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.parameter.PdKameraBetriebsParameter getPdKameraBetriebsParameter();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Attributgruppe, um Konfigurationsobjekten
						im Nachhinein
						zusätzliche Online-Attribute geben zu können.
	<p>
	
	</p>
	@return der Datensatz FlexiblesObjektOnline.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.onlinedaten.OdFlexiblesObjektOnline getOdFlexiblesObjektOnline();
	
	/**
	Attributgruppe, um Konfigurationsobjekten
						im Nachhinein
						zusätzliche Eigenschaften geben zu können.
	<p>
	
	</p>
	@return der Datensatz FlexiblesObjektParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.parameter.PdFlexiblesObjektParameter getPdFlexiblesObjektParameter();
	
	/**
	kurzinfo.
	<p>
	
	</p>
	@return der Datensatz PlanarPunkt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.konfigurationsdaten.KdPlanarPunkt getKdPlanarPunkt();
	
	/**
	Beschreibung des Eigenschaften eines VIP-T Moduls (in Anlehnung an die Beschreibung eines Encoders im T-Port Server).
	<p>
	
	</p>
	@return der Datensatz ViptEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten.KdViptEigenschaften getKdViptEigenschaften();
	
	/**
	Attributgruppe fuer die Deklarierung redundanter Verbindungen einer Videokamera des Datenmodells zu einer Videoquelle.
	<p>
	
	</p>
	@return der Datensatz RedundanteVerbindung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.parameter.PdRedundanteVerbindung getPdRedundanteVerbindung();
	
	/**
	Attributgruppe fuer die Deklarierung einer beliebigen Anzahl von Kameramasken.
	<p>
	
	</p>
	@return der Datensatz KameraMasken.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.parameter.PdKameraMasken getPdKameraMasken();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Beschreibung der Detector Zonen eines VIP-T Moduls.
	<p>
	
	</p>
	@return der Datensatz ViptDetektorZonen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.konfigurationsdaten.KdViptDetektorZonen getKdViptDetektorZonen();
	
	/**
	Attributgruppe für die allgemeinen Eigenschaften einer Video-Kamera.
	<p>
	
	</p>
	@return der Datensatz Kamera.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.parameter.PdKamera getPdKamera();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
