/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlwetterberichte.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt unter welchen Bedingungen ein Wetterbericht
					oder eine Wetterwarnung, wie, weiterkommuniziert werden soll.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 16
 */
public class AtlWetterberichtsVerteilung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<String
			> _berichtsTyp = new Feld<String
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			> _gebiet = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			>(0, true);
			private Feld<String
			> _empfaenger = new Feld<String
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttArtBenachrichtigung
			> _artBenachrichtigung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttArtBenachrichtigung
			>(0, true);
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von BerichtsTyp.
		*/
			public Feld<String
			> getBerichtsTyp() {
			return _berichtsTyp;
		}
	
	
		/**
		Referenz auf ein Gebiet.
		<p>
		
		</p>
		
		@return der Wert von Gebiet.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
			> getGebiet() {
			return _gebiet;
		}
	
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Empfaenger.
		*/
			public Feld<String
			> getEmpfaenger() {
			return _empfaenger;
		}
	
	
		/**
		Arten der Benachrichtigung für SWIS Meldungen.
		<p>
		
		</p>
		
		@return der Wert von ArtBenachrichtigung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttArtBenachrichtigung
			> getArtBenachrichtigung() {
			return _artBenachrichtigung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBerichtsTyp() != null) {
					final Data.TextArray arrayBerichtsTyp = datum.getTextArray("berichtsTyp");
					arrayBerichtsTyp.setLength(getBerichtsTyp().size());
					for (int i = 0; i < arrayBerichtsTyp.getLength(); ++i) {
						arrayBerichtsTyp.getTextValue(i).setText(getBerichtsTyp().get(i));
					}
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayGebiet = datum.getReferenceArray("gebiet");
					arrayGebiet.setLength(getGebiet().size());
					for (int i = 0; i < arrayGebiet.getLength(); ++i) {
						final Object soGebiet = getGebiet().get(i);
						final SystemObject tmpGebiet;
						if (soGebiet instanceof SystemObject) {
							tmpGebiet = (SystemObject)soGebiet;
						} else if(soGebiet instanceof SystemObjekt){
							tmpGebiet = ((SystemObjekt)soGebiet).getSystemObject();
						} else{
							tmpGebiet = null;
						}
						arrayGebiet.getReferenceValue(i).setSystemObject(tmpGebiet);
					}
				// ZeichenkettenAttributTyp
				if (getEmpfaenger() != null) {
					final Data.TextArray arrayEmpfaenger = datum.getTextArray("empfaenger");
					arrayEmpfaenger.setLength(getEmpfaenger().size());
					for (int i = 0; i < arrayEmpfaenger.getLength(); ++i) {
						arrayEmpfaenger.getTextValue(i).setText(getEmpfaenger().get(i));
					}
				}
				// GanzzahlAttributTyp
				if (getArtBenachrichtigung() != null) {
					final Data.NumberArray arrayArtBenachrichtigung = datum.
						getUnscaledArray
						("artBenachrichtigung");
					arrayArtBenachrichtigung.setLength(getArtBenachrichtigung().size());
					for (int i = 0; i < arrayArtBenachrichtigung.getLength(); ++i) {
						arrayArtBenachrichtigung.getValue(i).set(getArtBenachrichtigung().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayBerichtsTyp = daten.getTextArray("berichtsTyp");
					for (int i = 0; i < arrayBerichtsTyp.getLength(); ++i) {
						getBerichtsTyp().add(arrayBerichtsTyp.getText(i));
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayGebiet = daten.getReferenceArray("gebiet");
					for (int i = 0; i < arrayGebiet.getLength(); ++i) {
						final long idGebiet = daten.getReferenceArray("gebiet").getReferenceValue(i).getId();
						final SystemObjekt tmpGebiet;
						if (idGebiet == 0) {
							tmpGebiet = null;
						} else {
							final SystemObject soGebiet = factory.getDav().getDataModel().getObject(idGebiet);
							if (soGebiet == null) {
									tmpGebiet = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.impl.SwisGebietUngueltig(idGebiet);
							} else {
								tmpGebiet = factory.getModellobjekt(soGebiet);
							}
						}
							getGebiet().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.objekte.SwisGebiet
							) tmpGebiet);
					}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayEmpfaenger = daten.getTextArray("empfaenger");
					for (int i = 0; i < arrayEmpfaenger.getLength(); ++i) {
						getEmpfaenger().add(arrayEmpfaenger.getText(i));
					}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayArtBenachrichtigung = daten.
						getUnscaledArray
					("artBenachrichtigung");
	
					for (int i = 0; i < arrayArtBenachrichtigung.getLength(); ++i) {
	                    if (arrayArtBenachrichtigung.getValue(i).isState()) {
	                        getArtBenachrichtigung().add(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttArtBenachrichtigung
	                        .getZustand(arrayArtBenachrichtigung.getValue(i).getState().getName()));
	                    } else {
	                    getArtBenachrichtigung().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlswis.attribute.AttArtBenachrichtigung
	                    (arrayArtBenachrichtigung.
	                    		byteValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlWetterberichtsVerteilung clone() {
		AtlWetterberichtsVerteilung klon = new AtlWetterberichtsVerteilung();
		
					klon._berichtsTyp = getBerichtsTyp().clone();
					klon._gebiet = getGebiet().clone();
					klon._empfaenger = getEmpfaenger().clone();
					klon._artBenachrichtigung = getArtBenachrichtigung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
