/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Benutzereinstellungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlBenutzerEinstellungen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<String
			> _voreinstellungen = new Feld<String
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _benutzer
			;
	
		/**
		Voreinstellungen.
		<p>
		Nimmt den Inhalt der XML-Struktur auf, welche die Voreinstellungen für einen Benutzer beschreibt.
		</p>
		
		@return der Wert von Voreinstellungen.
		*/
			public Feld<String
			> getVoreinstellungen() {
			return _voreinstellungen;
		}
	
	
		/**
		Referenz auf den Benutzer, der die Applikation angemeldet hat.
		<p>
		
		</p>
		
		@return der Wert von Benutzer.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 getBenutzer() {
			return _benutzer;
		}
	
		/**
		Referenz auf den Benutzer, der die Applikation angemeldet hat.
		<p>
		
		</p>
		
		@param _benutzer der neue Wert von Benutzer.
		*/
		public void setBenutzer(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
		 _benutzer) {
			this._benutzer = _benutzer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVoreinstellungen() != null) {
					final Data.TextArray arrayVoreinstellungen = datum.getTextArray("Voreinstellungen");
					arrayVoreinstellungen.setLength(getVoreinstellungen().size());
					for (int i = 0; i < arrayVoreinstellungen.getLength(); ++i) {
						arrayVoreinstellungen.getTextValue(i).setText(getVoreinstellungen().get(i));
					}
				}
				// ObjektReferenzAttributTyp
					final Object soBenutzer = getBenutzer();
					final SystemObject tmpBenutzer;
						if (soBenutzer instanceof SystemObject) {
							tmpBenutzer = (SystemObject)soBenutzer;
						} else if(soBenutzer instanceof SystemObjekt){
							tmpBenutzer = ((SystemObjekt)soBenutzer).getSystemObject();
						} else{
							tmpBenutzer = null;
						}
					datum.getReferenceValue("benutzer").setSystemObject(tmpBenutzer);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayVoreinstellungen = daten.getTextArray("Voreinstellungen");
					for (int i = 0; i < arrayVoreinstellungen.getLength(); ++i) {
						getVoreinstellungen().add(arrayVoreinstellungen.getText(i));
					}
				// ObjektReferenzAttributTyp
					final long idBenutzer = daten.getReferenceValue("benutzer").getId();
					final SystemObjekt tmpBenutzer;
					if (idBenutzer == 0) {
						tmpBenutzer = null;
					} else {
						final SystemObject soBenutzer = factory.getDav().getDataModel().getObject(idBenutzer);
						if (soBenutzer == null) {
								tmpBenutzer = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idBenutzer);
						} else {
							tmpBenutzer = factory.getModellobjekt(soBenutzer);
						}
					}
					setBenutzer((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
					) tmpBenutzer);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBenutzerEinstellungen clone() {
		AtlBenutzerEinstellungen klon = new AtlBenutzerEinstellungen();
		
					klon._voreinstellungen = getVoreinstellungen().clone();
						klon.setBenutzer(getBenutzer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
