/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Globale Benutzereinstellungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class AtlBenutzerEinstellungenGlobal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<String
			> _voreinstellungen = new Feld<String
			>(0, true);
	
		/**
		Globale Voreinstellungen.
		<p>
		Nimmt den Inhalt der XML-Struktur auf, welche die Voreinstellungen für alle Benutzer beschreibt.
		</p>
		
		@return der Wert von Voreinstellungen.
		*/
			public Feld<String
			> getVoreinstellungen() {
			return _voreinstellungen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVoreinstellungen() != null) {
					final Data.TextArray arrayVoreinstellungen = datum.getTextArray("Voreinstellungen");
					arrayVoreinstellungen.setLength(getVoreinstellungen().size());
					for (int i = 0; i < arrayVoreinstellungen.getLength(); ++i) {
						arrayVoreinstellungen.getTextValue(i).setText(getVoreinstellungen().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayVoreinstellungen = daten.getTextArray("Voreinstellungen");
					for (int i = 0; i < arrayVoreinstellungen.getLength(); ++i) {
						getVoreinstellungen().add(arrayVoreinstellungen.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBenutzerEinstellungenGlobal clone() {
		AtlBenutzerEinstellungenGlobal klon = new AtlBenutzerEinstellungenGlobal();
		
					klon._voreinstellungen = getVoreinstellungen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
