/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung eins Filters zur Datenauswahl.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlFilter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttFilterKriterium
			 _kriterium
			;
			private Feld<String
			> _wert = new Feld<String
			>(0, true);
	
		/**
		Filterkriterium zur Einschränkung der Objektmenge.
		<p>
		Über das Filterkriterium lassen sich die zulässigen Objekte einschränken. Die Einschränkung ist derzeit möglich über Konfigurationsbereich, Mengen, Objekttypen, Attributgruppen, Aspekte und Objekte. Die Kriterien werden mit UND verknüpft.
		</p>
		
		@return der Wert von Kriterium.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttFilterKriterium
			 getKriterium() {
			return _kriterium;
		}
	
		/**
		Filterkriterium zur Einschränkung der Objektmenge.
		<p>
		Über das Filterkriterium lassen sich die zulässigen Objekte einschränken. Die Einschränkung ist derzeit möglich über Konfigurationsbereich, Mengen, Objekttypen, Attributgruppen, Aspekte und Objekte. Die Kriterien werden mit UND verknüpft.
		</p>
		
		@param _kriterium der neue Wert von Kriterium.
		*/
		public void setKriterium(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttFilterKriterium
		 _kriterium) {
			this._kriterium = _kriterium;
		}
	
		/**
		Wert (Objekt) des Filterkriterium zur Einschränkung der Objektmenge. Die Werte werden mit ODER verknüpft.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public Feld<String
			> getWert() {
			return _wert;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getKriterium() != null) {
	                if (getKriterium().isZustand()) {
	                    datum.getUnscaledValue("Kriterium").setText(getKriterium().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kriterium").set(getKriterium().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getWert() != null) {
					final Data.TextArray arrayWert = datum.getTextArray("Wert");
					arrayWert.setLength(getWert().size());
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						arrayWert.getTextValue(i).setText(getWert().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kriterium").isState()) {
							setKriterium(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttFilterKriterium
							.getZustand(daten.getScaledValue("Kriterium").getText()));
						} else {
						setKriterium(new de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute.AttFilterKriterium
						(daten.
							getUnscaledValue
						("Kriterium").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayWert = daten.getTextArray("Wert");
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						getWert().add(arrayWert.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlFilter clone() {
		AtlFilter klon = new AtlFilter();
		
						klon.setKriterium(getKriterium());
					klon._wert = getWert().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
