/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Rahmenwerk-Einstellung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlRahmenwerkEinstellung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _typ
			= new String
			()
			;
			private String
			 _key
			= new String
			()
			;
			private Feld<String
			> _wert = new Feld<String
			>(0, true);
	
		/**
		Einstellungs-Typ.
		<p>
		Typ der Einstellung als String.
		                        Erwartet wird hier der Klassenname der Instanz, die die Deserialsierung der Einstellung liefert. 
		                        Voraussetzung ist eine entsprechend registrierte Factory im Rahmenwerk.
		                        Der Standardwert, der angenommen wird, wenn das Attribut leer ist, ist 'java.lang.String'.
		</p>
		
		@return der Wert von Typ.
		*/
			public String
			 getTyp() {
			return _typ;
		}
	
		/**
		Einstellungs-Typ.
		<p>
		Typ der Einstellung als String.
		                        Erwartet wird hier der Klassenname der Instanz, die die Deserialsierung der Einstellung liefert. 
		                        Voraussetzung ist eine entsprechend registrierte Factory im Rahmenwerk.
		                        Der Standardwert, der angenommen wird, wenn das Attribut leer ist, ist 'java.lang.String'.
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(String
		 _typ) {
			if (_typ.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._typ = _typ;
		}
	
		/**
		Einstellungs-Key.
		<p>
		Der Schlüssel über den auf den entsprechenden Einstellungswert zugegriffen werden kann.
		</p>
		
		@return der Wert von Key.
		*/
			public String
			 getKey() {
			return _key;
		}
	
		/**
		Einstellungs-Key.
		<p>
		Der Schlüssel über den auf den entsprechenden Einstellungswert zugegriffen werden kann.
		</p>
		
		@param _key der neue Wert von Key.
		*/
		public void setKey(String
		 _key) {
			if (_key.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._key = _key;
		}
	
		/**
		Einstellungswert.
		<p>
		Nimmt den Inhalt der Einstellung auf. Der Wert ist als Liste angelegt, um die potentielle 
		                        Begrenzung der Länge des Textattributs zu umgehen.
		</p>
		
		@return der Wert von Wert.
		*/
			public Feld<String
			> getWert() {
			return _wert;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTyp() != null) {
					datum.getTextValue("Typ").setText(getTyp());
				}
				// ZeichenkettenAttributTyp
				if (getKey() != null) {
					datum.getTextValue("Key").setText(getKey());
				}
				// ZeichenkettenAttributTyp
				if (getWert() != null) {
					final Data.TextArray arrayWert = datum.getTextArray("Wert");
					arrayWert.setLength(getWert().size());
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						arrayWert.getTextValue(i).setText(getWert().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTyp(daten.getTextValue("Typ").getText());
				// ZeichenkettenAttributTyp
					setKey(daten.getTextValue("Key").getText());
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayWert = daten.getTextArray("Wert");
					for (int i = 0; i < arrayWert.getLength(); ++i) {
						getWert().add(arrayWert.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRahmenwerkEinstellung clone() {
		AtlRahmenwerkEinstellung klon = new AtlRahmenwerkEinstellung();
		
						klon.setTyp(getTyp());
						klon.setKey(getKey());
					klon._wert = getWert().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
