/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Filterkriterium zur Einschränkung der Objektmenge.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttFilterKriterium extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Einschränkung über Konfigurationsbereiche. Die zugehörigen FilterWerte sind die Pid oder Id von Konfigurationsbereichen.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_0_KONFIGURATIONSBEREICH = new AttFilterKriterium("Konfigurationsbereich", 		Short
	.valueOf("0"));

	/**
	Einschränkung über Objekttypen. Die zugehörigen FilterWerte sind die Pid oder Id von Objekttypen.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_2_OBJEKTTYP = new AttFilterKriterium("Objekttyp", 		Short
	.valueOf("2"));

	/**
	Einschränkung über Attributgruppen. Die zugehörigen FilterWerte sind die Pid oder Id von Attributgruppentypen.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_3_ATTRIBUTGRUPPE = new AttFilterKriterium("Attributgruppe", 		Short
	.valueOf("3"));

	/**
	Einschränkung über Aspekten Die zugehörigen FilterWerte sind die Pid oder Id von Aspekttypen.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_4_ASPEKT = new AttFilterKriterium("Aspekt", 		Short
	.valueOf("4"));

	/**
	Einschränkung über konkrete Objekte. Die zugehörigen FilterWerte sind die Pid oder Id von Objekten. Optional können hinter Pid bzw. Id mit Doppelpunkt getrennt Mengennamen angegeben werden, wodurch über die in der spezifizierten Menge enthaltenen Objekte eingeschränkt wird.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_5_OBJEKT = new AttFilterKriterium("Objekt", 		Short
	.valueOf("5"));

	/**
	Einschränkung über spezielle Filter-Plugins. Der erste zugehörigen FilterWert ist der Klassenname des zu verwendenden Plugins. Weitere Werte sind abhängig vom jeweiligen Filter-Plugin.
	<p>
	
	</p>
	*/
	public static final AttFilterKriterium ZUSTAND_32767_ERWEITERT = new AttFilterKriterium("Erweitert", 		Short
	.valueOf("32767"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttFilterKriterium getZustand(final 		Short
	 value) {
		for (AttFilterKriterium e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttFilterKriterium getZustand(final String value) {
		for (AttFilterKriterium e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttFilterKriterium> getZustaende() {
		List<AttFilterKriterium> list = new ArrayList<AttFilterKriterium>();
		list.add(ZUSTAND_0_KONFIGURATIONSBEREICH);
		list.add(ZUSTAND_2_OBJEKTTYP);
		list.add(ZUSTAND_3_ATTRIBUTGRUPPE);
		list.add(ZUSTAND_4_ASPEKT);
		list.add(ZUSTAND_5_OBJEKT);
		list.add(ZUSTAND_32767_ERWEITERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut FilterKriterium.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttFilterKriterium(final 		Short
	 value) {
		super(value);
	}
	
	private AttFilterKriterium(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
