/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zu Ereignissen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlEreignisInformation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _zeitpunkt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
			 _ereignisReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _zeitlichGueltig
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verkehrlichGueltig
			;
	
		/**
		Zeitpunkt des Zustands bzw. der Änderung des Zustands.
		<p>
		
		</p>
		
		@return der Wert von Zeitpunkt.
		*/
			public 	Zeitstempel
			 getZeitpunkt() {
			return _zeitpunkt;
		}
	
		/**
		Zeitpunkt des Zustands bzw. der Änderung des Zustands.
		<p>
		
		</p>
		
		@param _zeitpunkt der neue Wert von Zeitpunkt.
		*/
		public void setZeitpunkt(	Zeitstempel
		 _zeitpunkt) {
			this._zeitpunkt = _zeitpunkt;
		}
	
		/**
		Referenz auf das Ereignis.
		<p>
		
		</p>
		
		@return der Wert von EreignisReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
			 getEreignisReferenz() {
			return _ereignisReferenz;
		}
	
		/**
		Referenz auf das Ereignis.
		<p>
		
		</p>
		
		@param _ereignisReferenz der neue Wert von EreignisReferenz.
		*/
		public void setEreignisReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
		 _ereignisReferenz) {
			this._ereignisReferenz = _ereignisReferenz;
		}
	
		/**
		Gibt an, ob das Ereignis zeitlich gültig ist oder nicht.
		<p>
		
		</p>
		
		@return der Wert von ZeitlichGueltig.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getZeitlichGueltig() {
			return _zeitlichGueltig;
		}
	
		/**
		Gibt an, ob das Ereignis zeitlich gültig ist oder nicht.
		<p>
		
		</p>
		
		@param _zeitlichGueltig der neue Wert von ZeitlichGueltig.
		*/
		public void setZeitlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _zeitlichGueltig) {
			this._zeitlichGueltig = _zeitlichGueltig;
		}
	
		/**
		Gibt an, ob das Ereignis verkehrlich gültig ist oder nicht.
		<p>
		
		</p>
		
		@return der Wert von VerkehrlichGueltig.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getVerkehrlichGueltig() {
			return _verkehrlichGueltig;
		}
	
		/**
		Gibt an, ob das Ereignis verkehrlich gültig ist oder nicht.
		<p>
		
		</p>
		
		@param _verkehrlichGueltig der neue Wert von VerkehrlichGueltig.
		*/
		public void setVerkehrlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _verkehrlichGueltig) {
			this._verkehrlichGueltig = _verkehrlichGueltig;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
				// ObjektReferenzAttributTyp
					final Object soEreignisReferenz = getEreignisReferenz();
					final SystemObject tmpEreignisReferenz;
						if (soEreignisReferenz instanceof SystemObject) {
							tmpEreignisReferenz = (SystemObject)soEreignisReferenz;
						} else if(soEreignisReferenz instanceof SystemObjekt){
							tmpEreignisReferenz = ((SystemObjekt)soEreignisReferenz).getSystemObject();
						} else{
							tmpEreignisReferenz = null;
						}
					datum.getReferenceValue("EreignisReferenz").setSystemObject(tmpEreignisReferenz);
				// GanzzahlAttributTyp
				if (getZeitlichGueltig() != null) {
	                if (getZeitlichGueltig().isZustand()) {
	                    datum.getUnscaledValue("zeitlichGültig").setText(getZeitlichGueltig().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("zeitlichGültig").set(getZeitlichGueltig().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVerkehrlichGueltig() != null) {
	                if (getVerkehrlichGueltig().isZustand()) {
	                    datum.getUnscaledValue("verkehrlichGültig").setText(getVerkehrlichGueltig().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("verkehrlichGültig").set(getVerkehrlichGueltig().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeitpunkt(new
						Zeitstempel
						(daten.getTimeValue("Zeitpunkt").getMillis()));
				// ObjektReferenzAttributTyp
					final long idEreignisReferenz = daten.getReferenceValue("EreignisReferenz").getId();
					final SystemObjekt tmpEreignisReferenz;
					if (idEreignisReferenz == 0) {
						tmpEreignisReferenz = null;
					} else {
						final SystemObject soEreignisReferenz = factory.getDav().getDataModel().getObject(idEreignisReferenz);
						if (soEreignisReferenz == null) {
								tmpEreignisReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisUngueltig(idEreignisReferenz);
						} else {
							tmpEreignisReferenz = factory.getModellobjekt(soEreignisReferenz);
						}
					}
					setEreignisReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis
					) tmpEreignisReferenz);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("zeitlichGültig").isState()) {
							setZeitlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("zeitlichGültig").getText()));
						} else {
						setZeitlichGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("zeitlichGültig").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("verkehrlichGültig").isState()) {
							setVerkehrlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("verkehrlichGültig").getText()));
						} else {
						setVerkehrlichGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("verkehrlichGültig").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlEreignisInformation clone() {
		AtlEreignisInformation klon = new AtlEreignisInformation();
		
						klon.setZeitpunkt(getZeitpunkt());
						klon.setEreignisReferenz(getEreignisReferenz());
						klon.setZeitlichGueltig(getZeitlichGueltig());
						klon.setVerkehrlichGueltig(getVerkehrlichGueltig());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
