/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustandsinformationen zu Ereignissen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class OdEreignis extends AbstractOnlineDatensatz<OdEreignis.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _zeitlichGueltig
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _verkehrlichGueltig
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _attributAenderung
				;
				private 	Zeitstempel
				 _zeitpunkt
				;
		
			/**
			Gibt an, ob das Ereignis zeitlich gültig ist oder nicht.
			<p>
			
			</p>
			
			@return der Wert von ZeitlichGueltig.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getZeitlichGueltig() {
				return _zeitlichGueltig;
			}
		
			/**
			Gibt an, ob das Ereignis zeitlich gültig ist oder nicht.
			<p>
			
			</p>
			
			@param _zeitlichGueltig der neue Wert von ZeitlichGueltig.
			*/
			public void setZeitlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _zeitlichGueltig) {
				this._zeitlichGueltig = _zeitlichGueltig;
			}
		
			/**
			Gibt an, ob das Ereignis verkehrlich gültig ist oder nicht.
			<p>
			
			</p>
			
			@return der Wert von VerkehrlichGueltig.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVerkehrlichGueltig() {
				return _verkehrlichGueltig;
			}
		
			/**
			Gibt an, ob das Ereignis verkehrlich gültig ist oder nicht.
			<p>
			
			</p>
			
			@param _verkehrlichGueltig der neue Wert von VerkehrlichGueltig.
			*/
			public void setVerkehrlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verkehrlichGueltig) {
				this._verkehrlichGueltig = _verkehrlichGueltig;
			}
		
			/**
			Gibt an, ob das es eine Attributänderung beim Ereignis gab.
			<p>
			
			</p>
			
			@return der Wert von AttributAenderung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAttributAenderung() {
				return _attributAenderung;
			}
		
			/**
			Gibt an, ob das es eine Attributänderung beim Ereignis gab.
			<p>
			
			</p>
			
			@param _attributAenderung der neue Wert von AttributAenderung.
			*/
			public void setAttributAenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _attributAenderung) {
				this._attributAenderung = _attributAenderung;
			}
		
			/**
			Voraussichtlicher Zeitpunkt, an dem der nächste Zustandswechsel stattfindet.
			<p>
			
			</p>
			
			@return der Wert von Zeitpunkt.
			*/
				public 	Zeitstempel
				 getZeitpunkt() {
				return _zeitpunkt;
			}
		
			/**
			Voraussichtlicher Zeitpunkt, an dem der nächste Zustandswechsel stattfindet.
			<p>
			
			</p>
			
			@param _zeitpunkt der neue Wert von Zeitpunkt.
			*/
			public void setZeitpunkt(	Zeitstempel
			 _zeitpunkt) {
				this._zeitpunkt = _zeitpunkt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getZeitlichGueltig() != null) {
		                if (getZeitlichGueltig().isZustand()) {
		                    datum.getUnscaledValue("zeitlichGültig").setText(getZeitlichGueltig().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("zeitlichGültig").set(getZeitlichGueltig().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVerkehrlichGueltig() != null) {
		                if (getVerkehrlichGueltig().isZustand()) {
		                    datum.getUnscaledValue("verkehrlichGültig").setText(getVerkehrlichGueltig().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("verkehrlichGültig").set(getVerkehrlichGueltig().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAttributAenderung() != null) {
		                if (getAttributAenderung().isZustand()) {
		                    datum.getUnscaledValue("AttributÄnderung").setText(getAttributAenderung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AttributÄnderung").set(getAttributAenderung().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Zeitpunkt").setMillis(getZeitpunkt().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("zeitlichGültig").isState()) {
								setZeitlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("zeitlichGültig").getText()));
							} else {
							setZeitlichGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("zeitlichGültig").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("verkehrlichGültig").isState()) {
								setVerkehrlichGueltig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("verkehrlichGültig").getText()));
							} else {
							setVerkehrlichGueltig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("verkehrlichGültig").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AttributÄnderung").isState()) {
								setAttributAenderung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("AttributÄnderung").getText()));
							} else {
							setAttributAenderung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("AttributÄnderung").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setZeitpunkt(new
							Zeitstempel
							(daten.getTimeValue("Zeitpunkt").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZeitlichGueltig(getZeitlichGueltig());
							klon.setVerkehrlichGueltig(getVerkehrlichGueltig());
							klon.setAttributAenderung(getAttributAenderung());
							klon.setZeitpunkt(getZeitpunkt());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ereignis";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdEreignis(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
