/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ereignisabhängige Parameter für das automatische Lernen von Ganglinien (je Ereignistyp).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class PdGanglinienModellAutomatischesLernenEreignis extends AbstractParameterDatensatz<PdGanglinienModellAutomatischesLernenEreignis.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> _algAusschlussliste = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
				 _algGanglinienTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _algVergleichsSchrittweite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
				 _algMaxAbstand
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> _algBezugsereignistypen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
				 _algMaxMatchingFehler
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _algMatchingSchrittweite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
				 _algMatchingIntervallVor
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
				 _algMatchingIntervallNach
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttWichtungsFaktor
				 _algMaxWichtungsfaktor
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
				 _algDarstellungsverfahren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanzzahl1Bis
				 _algMaxGanglinien
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Liste von Ereignistypen, die nicht gleichzeitig mit einem für die Verschmelzung ausgewählten Ereignis anstehen dürfen.
			<p>
			
			</p>
			
			@return der Wert von AlgAusschlussliste.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> getAlgAusschlussliste() {
				return _algAusschlussliste;
			}
		
		
			/**
			Art der zu generierenden Ganglinien.
			<p>
			
			</p>
			
			@return der Wert von AlgGanglinienTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
				 getAlgGanglinienTyp() {
				return _algGanglinienTyp;
			}
		
			/**
			Art der zu generierenden Ganglinien.
			<p>
			
			</p>
			
			@param _algGanglinienTyp der neue Wert von AlgGanglinienTyp.
			*/
			public void setAlgGanglinienTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
			 _algGanglinienTyp) {
				this._algGanglinienTyp = _algGanglinienTyp;
			}
		
			/**
			Schrittweite für die Abstandsbestimmung von Ganglinien mit dem komplexen Basismaß.
			<p>
			
			</p>
			
			@return der Wert von AlgVergleichsSchrittweite.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getAlgVergleichsSchrittweite() {
				return _algVergleichsSchrittweite;
			}
		
			/**
			Schrittweite für die Abstandsbestimmung von Ganglinien mit dem komplexen Basismaß.
			<p>
			
			</p>
			
			@param _algVergleichsSchrittweite der neue Wert von AlgVergleichsSchrittweite.
			*/
			public void setAlgVergleichsSchrittweite(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _algVergleichsSchrittweite) {
				this._algVergleichsSchrittweite = _algVergleichsSchrittweite;
			}
		
			/**
			Maximaler Abstand von gemessenen Ganglinien zur Verschmelzung mit bereits generierten
									absoluten historischen Ganglinien.
			<p>
			
			</p>
			
			@return der Wert von AlgMaxAbstand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
				 getAlgMaxAbstand() {
				return _algMaxAbstand;
			}
		
			/**
			Maximaler Abstand von gemessenen Ganglinien zur Verschmelzung mit bereits generierten
									absoluten historischen Ganglinien.
			<p>
			
			</p>
			
			@param _algMaxAbstand der neue Wert von AlgMaxAbstand.
			*/
			public void setAlgMaxAbstand(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
			 _algMaxAbstand) {
				this._algMaxAbstand = _algMaxAbstand;
			}
		
			/**
			Liste mit Ereignistypen auf die sich relative Ganglinien beziehen können.
			<p>
			
			</p>
			
			@return der Wert von AlgBezugsereignistypen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
				> getAlgBezugsereignistypen() {
				return _algBezugsereignistypen;
			}
		
		
			/**
			Maximaler Abstand für das Pattern-Matching beim Erzeugen von relativen historischen Ganglinien.
			<p>
			
			</p>
			
			@return der Wert von AlgMaxMatchingFehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
				 getAlgMaxMatchingFehler() {
				return _algMaxMatchingFehler;
			}
		
			/**
			Maximaler Abstand für das Pattern-Matching beim Erzeugen von relativen historischen Ganglinien.
			<p>
			
			</p>
			
			@param _algMaxMatchingFehler der neue Wert von AlgMaxMatchingFehler.
			*/
			public void setAlgMaxMatchingFehler(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
			 _algMaxMatchingFehler) {
				this._algMaxMatchingFehler = _algMaxMatchingFehler;
			}
		
			/**
			Schrittweite für das Pattern-Matching beim Erzeugen von relativen historischen Ganglinien.
			<p>
			
			</p>
			
			@return der Wert von AlgMatchingSchrittweite.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getAlgMatchingSchrittweite() {
				return _algMatchingSchrittweite;
			}
		
			/**
			Schrittweite für das Pattern-Matching beim Erzeugen von relativen historischen Ganglinien.
			<p>
			
			</p>
			
			@param _algMatchingSchrittweite der neue Wert von AlgMatchingSchrittweite.
			*/
			public void setAlgMatchingSchrittweite(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _algMatchingSchrittweite) {
				this._algMatchingSchrittweite = _algMatchingSchrittweite;
			}
		
			/**
			Zeitspanne vor der verkehrlichen Gültigkeit eines Ereignisses in dem bei der Erzeugung von
									relativen Ganglinien das Pattern-Matching Verfahren angewandt wird.
			<p>
			
			</p>
			
			@return der Wert von AlgMatchingIntervallVor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
				 getAlgMatchingIntervallVor() {
				return _algMatchingIntervallVor;
			}
		
			/**
			Zeitspanne vor der verkehrlichen Gültigkeit eines Ereignisses in dem bei der Erzeugung von
									relativen Ganglinien das Pattern-Matching Verfahren angewandt wird.
			<p>
			
			</p>
			
			@param _algMatchingIntervallVor der neue Wert von AlgMatchingIntervallVor.
			*/
			public void setAlgMatchingIntervallVor(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
			 _algMatchingIntervallVor) {
				this._algMatchingIntervallVor = _algMatchingIntervallVor;
			}
		
			/**
			Zeitspanne nach der verkehrlichen Gültigkeit eines Ereignisses in dem bei der
									Erzeugung von relativen Ganglinien das Pattern-Matching Verfahren angewandt wird.
			<p>
			
			</p>
			
			@return der Wert von AlgMatchingIntervallNach.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
				 getAlgMatchingIntervallNach() {
				return _algMatchingIntervallNach;
			}
		
			/**
			Zeitspanne nach der verkehrlichen Gültigkeit eines Ereignisses in dem bei der
									Erzeugung von relativen Ganglinien das Pattern-Matching Verfahren angewandt wird.
			<p>
			
			</p>
			
			@param _algMatchingIntervallNach der neue Wert von AlgMatchingIntervallNach.
			*/
			public void setAlgMatchingIntervallNach(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
			 _algMatchingIntervallNach) {
				this._algMatchingIntervallNach = _algMatchingIntervallNach;
			}
		
			/**
			Maximalwert für die Wichtung historischer Ganglinien bei der Verschmelzung.
			<p>
			
			</p>
			
			@return der Wert von AlgMaxWichtungsfaktor.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttWichtungsFaktor
				 getAlgMaxWichtungsfaktor() {
				return _algMaxWichtungsfaktor;
			}
		
			/**
			Maximalwert für die Wichtung historischer Ganglinien bei der Verschmelzung.
			<p>
			
			</p>
			
			@param _algMaxWichtungsfaktor der neue Wert von AlgMaxWichtungsfaktor.
			*/
			public void setAlgMaxWichtungsfaktor(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttWichtungsFaktor
			 _algMaxWichtungsfaktor) {
				this._algMaxWichtungsfaktor = _algMaxWichtungsfaktor;
			}
		
			/**
			Verfahren, dass zur Interpolation bzw. Approximation bei der Darstellung von erzeugten
									Ganglinien benutzt werden soll.
			<p>
			
			</p>
			
			@return der Wert von AlgDarstellungsverfahren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
				 getAlgDarstellungsverfahren() {
				return _algDarstellungsverfahren;
			}
		
			/**
			Verfahren, dass zur Interpolation bzw. Approximation bei der Darstellung von erzeugten
									Ganglinien benutzt werden soll.
			<p>
			
			</p>
			
			@param _algDarstellungsverfahren der neue Wert von AlgDarstellungsverfahren.
			*/
			public void setAlgDarstellungsverfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
			 _algDarstellungsverfahren) {
				this._algDarstellungsverfahren = _algDarstellungsverfahren;
			}
		
			/**
			Maximale Anzahl gespeicherter historischer Ganglinien.
			<p>
			
			</p>
			
			@return der Wert von AlgMaxGanglinien.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanzzahl1Bis
				 getAlgMaxGanglinien() {
				return _algMaxGanglinien;
			}
		
			/**
			Maximale Anzahl gespeicherter historischer Ganglinien.
			<p>
			
			</p>
			
			@param _algMaxGanglinien der neue Wert von AlgMaxGanglinien.
			*/
			public void setAlgMaxGanglinien(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanzzahl1Bis
			 _algMaxGanglinien) {
				this._algMaxGanglinien = _algMaxGanglinien;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAlgAusschlussliste = datum.getReferenceArray("AlgAusschlussliste");
						arrayAlgAusschlussliste.setLength(getAlgAusschlussliste().size());
						for (int i = 0; i < arrayAlgAusschlussliste.getLength(); ++i) {
							final Object soAlgAusschlussliste = getAlgAusschlussliste().get(i);
							final SystemObject tmpAlgAusschlussliste;
							if (soAlgAusschlussliste instanceof SystemObject) {
								tmpAlgAusschlussliste = (SystemObject)soAlgAusschlussliste;
							} else if(soAlgAusschlussliste instanceof SystemObjekt){
								tmpAlgAusschlussliste = ((SystemObjekt)soAlgAusschlussliste).getSystemObject();
							} else{
								tmpAlgAusschlussliste = null;
							}
							arrayAlgAusschlussliste.getReferenceValue(i).setSystemObject(tmpAlgAusschlussliste);
						}
					// GanzzahlAttributTyp
					if (getAlgGanglinienTyp() != null) {
		                if (getAlgGanglinienTyp().isZustand()) {
		                    datum.getUnscaledValue("AlgGanglinienTyp").setText(getAlgGanglinienTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgGanglinienTyp").set(getAlgGanglinienTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgVergleichsSchrittweite() != null) {
		                if (getAlgVergleichsSchrittweite().isZustand()) {
		                    datum.getUnscaledValue("AlgVergleichsSchrittweite").setText(getAlgVergleichsSchrittweite().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgVergleichsSchrittweite").set(getAlgVergleichsSchrittweite().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMaxAbstand() != null) {
		                if (getAlgMaxAbstand().isZustand()) {
		                    datum.getUnscaledValue("AlgMaxAbstand").setText(getAlgMaxAbstand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMaxAbstand").set(getAlgMaxAbstand().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAlgBezugsereignistypen = datum.getReferenceArray("AlgBezugsereignistypen");
						arrayAlgBezugsereignistypen.setLength(getAlgBezugsereignistypen().size());
						for (int i = 0; i < arrayAlgBezugsereignistypen.getLength(); ++i) {
							final Object soAlgBezugsereignistypen = getAlgBezugsereignistypen().get(i);
							final SystemObject tmpAlgBezugsereignistypen;
							if (soAlgBezugsereignistypen instanceof SystemObject) {
								tmpAlgBezugsereignistypen = (SystemObject)soAlgBezugsereignistypen;
							} else if(soAlgBezugsereignistypen instanceof SystemObjekt){
								tmpAlgBezugsereignistypen = ((SystemObjekt)soAlgBezugsereignistypen).getSystemObject();
							} else{
								tmpAlgBezugsereignistypen = null;
							}
							arrayAlgBezugsereignistypen.getReferenceValue(i).setSystemObject(tmpAlgBezugsereignistypen);
						}
					// GanzzahlAttributTyp
					if (getAlgMaxMatchingFehler() != null) {
		                if (getAlgMaxMatchingFehler().isZustand()) {
		                    datum.getUnscaledValue("AlgMaxMatchingFehler").setText(getAlgMaxMatchingFehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMaxMatchingFehler").set(getAlgMaxMatchingFehler().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMatchingSchrittweite() != null) {
		                if (getAlgMatchingSchrittweite().isZustand()) {
		                    datum.getUnscaledValue("AlgMatchingSchrittweite").setText(getAlgMatchingSchrittweite().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMatchingSchrittweite").set(getAlgMatchingSchrittweite().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMatchingIntervallVor() != null) {
		                if (getAlgMatchingIntervallVor().isZustand()) {
		                    datum.getUnscaledValue("AlgMatchingIntervallVor").setText(getAlgMatchingIntervallVor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMatchingIntervallVor").set(getAlgMatchingIntervallVor().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMatchingIntervallNach() != null) {
		                if (getAlgMatchingIntervallNach().isZustand()) {
		                    datum.getUnscaledValue("AlgMatchingIntervallNach").setText(getAlgMatchingIntervallNach().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMatchingIntervallNach").set(getAlgMatchingIntervallNach().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMaxWichtungsfaktor() != null) {
		                if (getAlgMaxWichtungsfaktor().isZustand()) {
		                    datum.getUnscaledValue("AlgMaxWichtungsfaktor").setText(getAlgMaxWichtungsfaktor().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMaxWichtungsfaktor").set(getAlgMaxWichtungsfaktor().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgDarstellungsverfahren() != null) {
		                if (getAlgDarstellungsverfahren().isZustand()) {
		                    datum.getUnscaledValue("AlgDarstellungsverfahren").setText(getAlgDarstellungsverfahren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgDarstellungsverfahren").set(getAlgDarstellungsverfahren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlgMaxGanglinien() != null) {
		                if (getAlgMaxGanglinien().isZustand()) {
		                    datum.getUnscaledValue("AlgMaxGanglinien").setText(getAlgMaxGanglinien().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlgMaxGanglinien").set(getAlgMaxGanglinien().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAlgAusschlussliste = daten.getReferenceArray("AlgAusschlussliste");
						for (int i = 0; i < arrayAlgAusschlussliste.getLength(); ++i) {
							final long idAlgAusschlussliste = daten.getReferenceArray("AlgAusschlussliste").getReferenceValue(i).getId();
							final SystemObjekt tmpAlgAusschlussliste;
							if (idAlgAusschlussliste == 0) {
								tmpAlgAusschlussliste = null;
							} else {
								final SystemObject soAlgAusschlussliste = factory.getDav().getDataModel().getObject(idAlgAusschlussliste);
								if (soAlgAusschlussliste == null) {
										tmpAlgAusschlussliste = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idAlgAusschlussliste);
								} else {
									tmpAlgAusschlussliste = factory.getModellobjekt(soAlgAusschlussliste);
								}
							}
								getAlgAusschlussliste().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
								) tmpAlgAusschlussliste);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AlgGanglinienTyp").isState()) {
								setAlgGanglinienTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
								.getZustand(daten.getScaledValue("AlgGanglinienTyp").getText()));
							} else {
							setAlgGanglinienTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienTyp
							(daten.
								getUnscaledValue
							("AlgGanglinienTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAlgVergleichsSchrittweite(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("AlgVergleichsSchrittweite").
									longValue
							()));
					// GanzzahlAttributTyp
							setAlgMaxAbstand(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
							(daten.
								getUnscaledValue
							("AlgMaxAbstand").
									byteValue
							()));
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAlgBezugsereignistypen = daten.getReferenceArray("AlgBezugsereignistypen");
						for (int i = 0; i < arrayAlgBezugsereignistypen.getLength(); ++i) {
							final long idAlgBezugsereignistypen = daten.getReferenceArray("AlgBezugsereignistypen").getReferenceValue(i).getId();
							final SystemObjekt tmpAlgBezugsereignistypen;
							if (idAlgBezugsereignistypen == 0) {
								tmpAlgBezugsereignistypen = null;
							} else {
								final SystemObject soAlgBezugsereignistypen = factory.getDav().getDataModel().getObject(idAlgBezugsereignistypen);
								if (soAlgBezugsereignistypen == null) {
										tmpAlgBezugsereignistypen = new de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.impl.EreignisTypUngueltig(idAlgBezugsereignistypen);
								} else {
									tmpAlgBezugsereignistypen = factory.getModellobjekt(soAlgBezugsereignistypen);
								}
							}
								getAlgBezugsereignistypen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp
								) tmpAlgBezugsereignistypen);
						}
					// GanzzahlAttributTyp
							setAlgMaxMatchingFehler(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAbstandsMass
							(daten.
								getUnscaledValue
							("AlgMaxMatchingFehler").
									byteValue
							()));
					// GanzzahlAttributTyp
							setAlgMatchingSchrittweite(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("AlgMatchingSchrittweite").
									longValue
							()));
					// GanzzahlAttributTyp
							setAlgMatchingIntervallVor(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
							(daten.
								getUnscaledValue
							("AlgMatchingIntervallVor").
									longValue
							()));
					// GanzzahlAttributTyp
							setAlgMatchingIntervallNach(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden0Bis
							(daten.
								getUnscaledValue
							("AlgMatchingIntervallNach").
									longValue
							()));
					// GanzzahlAttributTyp
							setAlgMaxWichtungsfaktor(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttWichtungsFaktor
							(daten.
								getUnscaledValue
							("AlgMaxWichtungsfaktor").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AlgDarstellungsverfahren").isState()) {
								setAlgDarstellungsverfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
								.getZustand(daten.getScaledValue("AlgDarstellungsverfahren").getText()));
							} else {
							setAlgDarstellungsverfahren(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienVerfahren
							(daten.
								getUnscaledValue
							("AlgDarstellungsverfahren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAlgMaxGanglinien(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanzzahl1Bis
							(daten.
								getUnscaledValue
							("AlgMaxGanglinien").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._algAusschlussliste = getAlgAusschlussliste().clone();
							klon.setAlgGanglinienTyp(getAlgGanglinienTyp());
							klon.setAlgVergleichsSchrittweite(getAlgVergleichsSchrittweite());
							klon.setAlgMaxAbstand(getAlgMaxAbstand());
						klon._algBezugsereignistypen = getAlgBezugsereignistypen().clone();
							klon.setAlgMaxMatchingFehler(getAlgMaxMatchingFehler());
							klon.setAlgMatchingSchrittweite(getAlgMatchingSchrittweite());
							klon.setAlgMatchingIntervallVor(getAlgMatchingIntervallVor());
							klon.setAlgMatchingIntervallNach(getAlgMatchingIntervallNach());
							klon.setAlgMaxWichtungsfaktor(getAlgMaxWichtungsfaktor());
							klon.setAlgDarstellungsverfahren(getAlgDarstellungsverfahren());
							klon.setAlgMaxGanglinien(getAlgMaxGanglinien());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ganglinienModellAutomatischesLernenEreignis";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdGanglinienModellAutomatischesLernenEreignis(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
