/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition einer Stützstelle.
<p>
&lt;absatz&gt;
						Die Stützstellen sind für die Verkehrsstärken und Geschwindigkeiten zusammengefasst.
					&lt;&#47;absatz&gt;
					&lt;absatz&gt;
						Die Stützstellenwerte zur Verkehrsstärke und zur Geschwindigkeit können die Zustände "nicht ermittelbar", "fehlerhaft" und "nicht ermittelbar&#47;fehlerhaft" aufweisen. Die undefinierte Stützstelle liegt IRGENDWO im undefinierten Bereich. Der undefinierte Bereich wird dabei von zwei definierten Stützstellen begrenzt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlStuetzstelle implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	RelativerZeitstempel
			 _zeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 _qLkw
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 _qKfz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 _vPkw
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 _vLkw
			;
	
		/**
		Relative Zeitdauer.
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	RelativerZeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Relative Zeitdauer.
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	RelativerZeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
		/**
		Lkw pro Stunde [Lkw&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@return der Wert von QLkw.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 getQLkw() {
			return _qLkw;
		}
	
		/**
		Lkw pro Stunde [Lkw&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@param _qLkw der neue Wert von QLkw.
		*/
		public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
		 _qLkw) {
			this._qLkw = _qLkw;
		}
	
		/**
		Kfz pro Stunde [Kfz&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@return der Wert von QKfz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 getQKfz() {
			return _qKfz;
		}
	
		/**
		Kfz pro Stunde [Kfz&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@param _qKfz der neue Wert von QKfz.
		*/
		public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
		 _qKfz) {
			this._qKfz = _qKfz;
		}
	
		/**
		Geschwindigkeit Pkw [km&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@return der Wert von VPkw.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 getVPkw() {
			return _vPkw;
		}
	
		/**
		Geschwindigkeit Pkw [km&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@param _vPkw der neue Wert von VPkw.
		*/
		public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
		 _vPkw) {
			this._vPkw = _vPkw;
		}
	
		/**
		Geschwindigkeit Lkw [km&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@return der Wert von VLkw.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
			 getVLkw() {
			return _vLkw;
		}
	
		/**
		Geschwindigkeit Lkw [km&#47;h] oder relative Angabe [%].
		<p>
		
		</p>
		
		@param _vLkw der neue Wert von VLkw.
		*/
		public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
		 _vLkw) {
			this._vLkw = _vLkw;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
				// GanzzahlAttributTyp
				if (getQLkw() != null) {
	                if (getQLkw().isZustand()) {
	                    datum.getUnscaledValue("QLkw").setText(getQLkw().toString());
	                } else {
						datum.
						getScaledValue
	                	("QLkw").set(getQLkw().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQKfz() != null) {
	                if (getQKfz().isZustand()) {
	                    datum.getUnscaledValue("QKfz").setText(getQKfz().toString());
	                } else {
						datum.
						getScaledValue
	                	("QKfz").set(getQKfz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVPkw() != null) {
	                if (getVPkw().isZustand()) {
	                    datum.getUnscaledValue("VPkw").setText(getVPkw().toString());
	                } else {
						datum.
						getScaledValue
	                	("VPkw").set(getVPkw().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVLkw() != null) {
	                if (getVLkw().isZustand()) {
	                    datum.getUnscaledValue("VLkw").setText(getVLkw().toString());
	                } else {
						datum.
						getScaledValue
	                	("VLkw").set(getVLkw().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setZeit(new
						RelativerZeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
				// GanzzahlAttributTyp
						setQLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
						(daten.
							getScaledValue
						("QLkw").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setQKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
						(daten.
							getScaledValue
						("QKfz").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setVPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
						(daten.
							getScaledValue
						("VPkw").
							doubleValue
						()));
				// GanzzahlAttributTyp
						setVLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttStuetzStellenWert
						(daten.
							getScaledValue
						("VLkw").
							doubleValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlStuetzstelle clone() {
		AtlStuetzstelle klon = new AtlStuetzstelle();
		
						klon.setZeit(getZeit());
						klon.setQLkw(getQLkw());
						klon.setQKfz(getQKfz());
						klon.setVPkw(getVPkw());
						klon.setVLkw(getVLkw());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
