/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur Ganglinienprognose je Prognoseobjekt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class PdGanglinienModellPrognose extends AbstractParameterDatensatz<PdGanglinienModellPrognose.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienAuswahlMethode
				 _gLAuswahlMethode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _gLPatternMatchingHorizont
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _gLMatchingIntervall
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 _gLPatterMatchingOffset
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _gLMaximalerMatchingFehler
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Gibt an, welche Methode am Prognoseobjekt i zur Auswahl von Ganglinien eingesetzt werden soll,
									wenn das Pattern-Matching nicht benutzt werden kann.
			<p>
			
			</p>
			
			@return der Wert von GLAuswahlMethode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienAuswahlMethode
				 getGLAuswahlMethode() {
				return _gLAuswahlMethode;
			}
		
			/**
			Gibt an, welche Methode am Prognoseobjekt i zur Auswahl von Ganglinien eingesetzt werden soll,
									wenn das Pattern-Matching nicht benutzt werden kann.
			<p>
			
			</p>
			
			@param _gLAuswahlMethode der neue Wert von GLAuswahlMethode.
			*/
			public void setGLAuswahlMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienAuswahlMethode
			 _gLAuswahlMethode) {
				this._gLAuswahlMethode = _gLAuswahlMethode;
			}
		
			/**
			Zeitspanne ab dem aktuellen Zeitpunkt in dem das Pattern-Matching Verfahrens zur Ganglinienauswahl
									am Prognoseobjekt i eingesetzt wird.
			<p>
			
			</p>
			
			@return der Wert von GLPatternMatchingHorizont.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getGLPatternMatchingHorizont() {
				return _gLPatternMatchingHorizont;
			}
		
			/**
			Zeitspanne ab dem aktuellen Zeitpunkt in dem das Pattern-Matching Verfahrens zur Ganglinienauswahl
									am Prognoseobjekt i eingesetzt wird.
			<p>
			
			</p>
			
			@param _gLPatternMatchingHorizont der neue Wert von GLPatternMatchingHorizont.
			*/
			public void setGLPatternMatchingHorizont(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _gLPatternMatchingHorizont) {
				this._gLPatternMatchingHorizont = _gLPatternMatchingHorizont;
			}
		
			/**
			Beschreibt den Zeitbereich vor dem aktuellen Zeitpunkt auf dem die Abstandsberechnung im
									Pattern-Matching Verfahren am Prognoseobjekt i ausgeführt wird.
			<p>
			
			</p>
			
			@return der Wert von GLMatchingIntervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getGLMatchingIntervall() {
				return _gLMatchingIntervall;
			}
		
			/**
			Beschreibt den Zeitbereich vor dem aktuellen Zeitpunkt auf dem die Abstandsberechnung im
									Pattern-Matching Verfahren am Prognoseobjekt i ausgeführt wird.
			<p>
			
			</p>
			
			@param _gLMatchingIntervall der neue Wert von GLMatchingIntervall.
			*/
			public void setGLMatchingIntervall(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _gLMatchingIntervall) {
				this._gLMatchingIntervall = _gLMatchingIntervall;
			}
		
			/**
			Ereignisse werden zusätzlich mit der angegebenen zeitlichen Verschiebung (nach vorne und hinten)
									im Pattern-Matching Verfahren am Prognoseobjekt i berücksichtigt.
			<p>
			
			</p>
			
			@return der Wert von GLPatterMatchingOffset.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
				 getGLPatterMatchingOffset() {
				return _gLPatterMatchingOffset;
			}
		
			/**
			Ereignisse werden zusätzlich mit der angegebenen zeitlichen Verschiebung (nach vorne und hinten)
									im Pattern-Matching Verfahren am Prognoseobjekt i berücksichtigt.
			<p>
			
			</p>
			
			@param _gLPatterMatchingOffset der neue Wert von GLPatterMatchingOffset.
			*/
			public void setGLPatterMatchingOffset(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
			 _gLPatterMatchingOffset) {
				this._gLPatterMatchingOffset = _gLPatterMatchingOffset;
			}
		
			/**
			Maximal zulässiger Fehler einer kombinierten Ganglinie im Vergleich zur aktuellen
									Analyseganglinie im Pattern-Matching Verfahren für Prognoseobjekt i.
			<p>
			
			</p>
			
			@return der Wert von GLMaximalerMatchingFehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getGLMaximalerMatchingFehler() {
				return _gLMaximalerMatchingFehler;
			}
		
			/**
			Maximal zulässiger Fehler einer kombinierten Ganglinie im Vergleich zur aktuellen
									Analyseganglinie im Pattern-Matching Verfahren für Prognoseobjekt i.
			<p>
			
			</p>
			
			@param _gLMaximalerMatchingFehler der neue Wert von GLMaximalerMatchingFehler.
			*/
			public void setGLMaximalerMatchingFehler(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _gLMaximalerMatchingFehler) {
				this._gLMaximalerMatchingFehler = _gLMaximalerMatchingFehler;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getGLAuswahlMethode() != null) {
		                if (getGLAuswahlMethode().isZustand()) {
		                    datum.getUnscaledValue("GLAuswahlMethode").setText(getGLAuswahlMethode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GLAuswahlMethode").set(getGLAuswahlMethode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGLPatternMatchingHorizont() != null) {
		                if (getGLPatternMatchingHorizont().isZustand()) {
		                    datum.getUnscaledValue("GLPatternMatchingHorizont").setText(getGLPatternMatchingHorizont().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GLPatternMatchingHorizont").set(getGLPatternMatchingHorizont().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGLMatchingIntervall() != null) {
		                if (getGLMatchingIntervall().isZustand()) {
		                    datum.getUnscaledValue("GLMatchingIntervall").setText(getGLMatchingIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GLMatchingIntervall").set(getGLMatchingIntervall().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGLPatterMatchingOffset() != null) {
		                if (getGLPatterMatchingOffset().isZustand()) {
		                    datum.getUnscaledValue("GLPatterMatchingOffset").setText(getGLPatterMatchingOffset().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GLPatterMatchingOffset").set(getGLPatterMatchingOffset().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGLMaximalerMatchingFehler() != null) {
		                if (getGLMaximalerMatchingFehler().isZustand()) {
		                    datum.getUnscaledValue("GLMaximalerMatchingFehler").setText(getGLMaximalerMatchingFehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("GLMaximalerMatchingFehler").set(getGLMaximalerMatchingFehler().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("GLAuswahlMethode").isState()) {
								setGLAuswahlMethode(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienAuswahlMethode
								.getZustand(daten.getScaledValue("GLAuswahlMethode").getText()));
							} else {
							setGLAuswahlMethode(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttGanglinienAuswahlMethode
							(daten.
								getUnscaledValue
							("GLAuswahlMethode").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setGLPatternMatchingHorizont(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("GLPatternMatchingHorizont").
									longValue
							()));
					// GanzzahlAttributTyp
							setGLMatchingIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("GLMatchingIntervall").
									longValue
							()));
					// GanzzahlAttributTyp
							setGLPatterMatchingOffset(new de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.attribute.AttAnzahlSekunden1Bis
							(daten.
								getUnscaledValue
							("GLPatterMatchingOffset").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("GLMaximalerMatchingFehler").isState()) {
								setGLMaximalerMatchingFehler(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("GLMaximalerMatchingFehler").getText()));
							} else {
							setGLMaximalerMatchingFehler(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("GLMaximalerMatchingFehler").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setGLAuswahlMethode(getGLAuswahlMethode());
							klon.setGLPatternMatchingHorizont(getGLPatternMatchingHorizont());
							klon.setGLMatchingIntervall(getGLMatchingIntervall());
							klon.setGLPatterMatchingOffset(getGLPatterMatchingOffset());
							klon.setGLMaximalerMatchingFehler(getGLMaximalerMatchingFehler());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ganglinienModellPrognose";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdGanglinienModellPrognose(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
