/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Koordinaten einer Fläche in Grad entsprechend WGS84.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdKomplexKoordinaten extends AbstractKonfigurationsDatensatz<KdKomplexKoordinaten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
				> _punktReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
				> _linienReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
				> _flaechenReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
				> _komplexReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
				>(0, true);
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.punkt.
			<p>
			
			</p>
			
			@return der Wert von PunktReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
				> getPunktReferenz() {
				return _punktReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.linie.
			<p>
			
			</p>
			
			@return der Wert von LinienReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
				> getLinienReferenz() {
				return _linienReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.fläche.
			<p>
			
			</p>
			
			@return der Wert von FlaechenReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
				> getFlaechenReferenz() {
				return _flaechenReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.komplex.
			<p>
			
			</p>
			
			@return der Wert von KomplexReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
				> getKomplexReferenz() {
				return _komplexReferenz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayPunktReferenz = datum.getReferenceArray("PunktReferenz");
						arrayPunktReferenz.setLength(getPunktReferenz().size());
						for (int i = 0; i < arrayPunktReferenz.getLength(); ++i) {
							final Object soPunktReferenz = getPunktReferenz().get(i);
							final SystemObject tmpPunktReferenz;
							if (soPunktReferenz instanceof SystemObject) {
								tmpPunktReferenz = (SystemObject)soPunktReferenz;
							} else if(soPunktReferenz instanceof SystemObjekt){
								tmpPunktReferenz = ((SystemObjekt)soPunktReferenz).getSystemObject();
							} else{
								tmpPunktReferenz = null;
							}
							arrayPunktReferenz.getReferenceValue(i).setSystemObject(tmpPunktReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayLinienReferenz = datum.getReferenceArray("LinienReferenz");
						arrayLinienReferenz.setLength(getLinienReferenz().size());
						for (int i = 0; i < arrayLinienReferenz.getLength(); ++i) {
							final Object soLinienReferenz = getLinienReferenz().get(i);
							final SystemObject tmpLinienReferenz;
							if (soLinienReferenz instanceof SystemObject) {
								tmpLinienReferenz = (SystemObject)soLinienReferenz;
							} else if(soLinienReferenz instanceof SystemObjekt){
								tmpLinienReferenz = ((SystemObjekt)soLinienReferenz).getSystemObject();
							} else{
								tmpLinienReferenz = null;
							}
							arrayLinienReferenz.getReferenceValue(i).setSystemObject(tmpLinienReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFlaechenReferenz = datum.getReferenceArray("FlächenReferenz");
						arrayFlaechenReferenz.setLength(getFlaechenReferenz().size());
						for (int i = 0; i < arrayFlaechenReferenz.getLength(); ++i) {
							final Object soFlaechenReferenz = getFlaechenReferenz().get(i);
							final SystemObject tmpFlaechenReferenz;
							if (soFlaechenReferenz instanceof SystemObject) {
								tmpFlaechenReferenz = (SystemObject)soFlaechenReferenz;
							} else if(soFlaechenReferenz instanceof SystemObjekt){
								tmpFlaechenReferenz = ((SystemObjekt)soFlaechenReferenz).getSystemObject();
							} else{
								tmpFlaechenReferenz = null;
							}
							arrayFlaechenReferenz.getReferenceValue(i).setSystemObject(tmpFlaechenReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayKomplexReferenz = datum.getReferenceArray("KomplexReferenz");
						arrayKomplexReferenz.setLength(getKomplexReferenz().size());
						for (int i = 0; i < arrayKomplexReferenz.getLength(); ++i) {
							final Object soKomplexReferenz = getKomplexReferenz().get(i);
							final SystemObject tmpKomplexReferenz;
							if (soKomplexReferenz instanceof SystemObject) {
								tmpKomplexReferenz = (SystemObject)soKomplexReferenz;
							} else if(soKomplexReferenz instanceof SystemObjekt){
								tmpKomplexReferenz = ((SystemObjekt)soKomplexReferenz).getSystemObject();
							} else{
								tmpKomplexReferenz = null;
							}
							arrayKomplexReferenz.getReferenceValue(i).setSystemObject(tmpKomplexReferenz);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayPunktReferenz = daten.getReferenceArray("PunktReferenz");
						for (int i = 0; i < arrayPunktReferenz.getLength(); ++i) {
							final long idPunktReferenz = daten.getReferenceArray("PunktReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpPunktReferenz;
							if (idPunktReferenz == 0) {
								tmpPunktReferenz = null;
							} else {
								final SystemObject soPunktReferenz = factory.getDav().getDataModel().getObject(idPunktReferenz);
								if (soPunktReferenz == null) {
										tmpPunktReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.PunktUngueltig(idPunktReferenz);
								} else {
									tmpPunktReferenz = factory.getModellobjekt(soPunktReferenz);
								}
							}
								getPunktReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt
								) tmpPunktReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayLinienReferenz = daten.getReferenceArray("LinienReferenz");
						for (int i = 0; i < arrayLinienReferenz.getLength(); ++i) {
							final long idLinienReferenz = daten.getReferenceArray("LinienReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpLinienReferenz;
							if (idLinienReferenz == 0) {
								tmpLinienReferenz = null;
							} else {
								final SystemObject soLinienReferenz = factory.getDav().getDataModel().getObject(idLinienReferenz);
								if (soLinienReferenz == null) {
										tmpLinienReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.LinieUngueltig(idLinienReferenz);
								} else {
									tmpLinienReferenz = factory.getModellobjekt(soLinienReferenz);
								}
							}
								getLinienReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Linie
								) tmpLinienReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFlaechenReferenz = daten.getReferenceArray("FlächenReferenz");
						for (int i = 0; i < arrayFlaechenReferenz.getLength(); ++i) {
							final long idFlaechenReferenz = daten.getReferenceArray("FlächenReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpFlaechenReferenz;
							if (idFlaechenReferenz == 0) {
								tmpFlaechenReferenz = null;
							} else {
								final SystemObject soFlaechenReferenz = factory.getDav().getDataModel().getObject(idFlaechenReferenz);
								if (soFlaechenReferenz == null) {
										tmpFlaechenReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.FlaecheUngueltig(idFlaechenReferenz);
								} else {
									tmpFlaechenReferenz = factory.getModellobjekt(soFlaechenReferenz);
								}
							}
								getFlaechenReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Flaeche
								) tmpFlaechenReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayKomplexReferenz = daten.getReferenceArray("KomplexReferenz");
						for (int i = 0; i < arrayKomplexReferenz.getLength(); ++i) {
							final long idKomplexReferenz = daten.getReferenceArray("KomplexReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpKomplexReferenz;
							if (idKomplexReferenz == 0) {
								tmpKomplexReferenz = null;
							} else {
								final SystemObject soKomplexReferenz = factory.getDav().getDataModel().getObject(idKomplexReferenz);
								if (soKomplexReferenz == null) {
										tmpKomplexReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.impl.KomplexUngueltig(idKomplexReferenz);
								} else {
									tmpKomplexReferenz = factory.getModellobjekt(soKomplexReferenz);
								}
							}
								getKomplexReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Komplex
								) tmpKomplexReferenz);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._punktReferenz = getPunktReferenz().clone();
						klon._linienReferenz = getLinienReferenz().clone();
						klon._flaechenReferenz = getFlaechenReferenz().clone();
						klon._komplexReferenz = getKomplexReferenz().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.komplexKoordinaten";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdKomplexKoordinaten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
