/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines abstrakten Einbauorts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdEinbauOrtTyp extends AbstractKonfigurationsDatensatz<KdEinbauOrtTyp.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _bezeichnung
				= new String
				()
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> _zulaessigeEinbauOrtTypen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				>(0, true);
				private Feld<String
				> _dokumentation = new Feld<String
				>(0, true);
				private Feld<String
				> _bilder = new Feld<String
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxBreite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxHoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxTiefe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
				 _masse
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				> _hersteller = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				>(0, true);
		
			/**
			Bezeichnung des EinbauOrtTyps, z.B. Herstellerbezeichnung.
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Bezeichnung des EinbauOrtTyps, z.B. Herstellerbezeichnung.
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Auflistung aller Einbauorttypen, in der dieser Einbauorttyp eingebaut werden kann, ermöglicht verfizierung der Konfiguration sowie eine Unterstützung bei zukünftigen Benutzeroberflächen. Der Einbauorttyp "Lager" sollte immer enthalten sein (sofern es sich nicht um ein Lager oder ein Lagerplatz handelt).
			<p>
			
			</p>
			
			@return der Wert von ZulaessigeEinbauOrtTypen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> getZulaessigeEinbauOrtTypen() {
				return _zulaessigeEinbauOrtTypen;
			}
		
		
			/**
			Dokumentation zum abstrakten Einbauorttyp, z.B. Handbücher...
			<p>
			
			</p>
			
			@return der Wert von Dokumentation.
			*/
				public Feld<String
				> getDokumentation() {
				return _dokumentation;
			}
		
		
			/**
			Bilder zum abstrakten Einbauorttyp.
			<p>
			
			</p>
			
			@return der Wert von Bilder.
			*/
				public Feld<String
				> getBilder() {
				return _bilder;
			}
		
		
			/**
			Maximale Breite des Einbauorttypstyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@return der Wert von MaxBreite.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxBreite() {
				return _maxBreite;
			}
		
			/**
			Maximale Breite des Einbauorttypstyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@param _maxBreite der neue Wert von MaxBreite.
			*/
			public void setMaxBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxBreite) {
				this._maxBreite = _maxBreite;
			}
		
			/**
			Maximale Höhe des Einbauorttyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@return der Wert von MaxHoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxHoehe() {
				return _maxHoehe;
			}
		
			/**
			Maximale Höhe des Einbauorttyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@param _maxHoehe der neue Wert von MaxHoehe.
			*/
			public void setMaxHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxHoehe) {
				this._maxHoehe = _maxHoehe;
			}
		
			/**
			Maximale Tiefe des Einbauorttyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@return der Wert von MaxTiefe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxTiefe() {
				return _maxTiefe;
			}
		
			/**
			Maximale Tiefe des Einbauorttyps, 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@param _maxTiefe der neue Wert von MaxTiefe.
			*/
			public void setMaxTiefe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxTiefe) {
				this._maxTiefe = _maxTiefe;
			}
		
			/**
			Masse des Einbauorttyps ohne Einbauten; , 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@return der Wert von Masse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
				 getMasse() {
				return _masse;
			}
		
			/**
			Masse des Einbauorttyps ohne Einbauten; , 0 wenn keine sinnvole Angabe möglich.
			<p>
			
			</p>
			
			@param _masse der neue Wert von Masse.
			*/
			public void setMasse(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
			 _masse) {
				this._masse = _masse;
			}
		
			/**
			Referenz auf den oder die Hersteller, welche diese Art von Einbauort liefern, kann leer sein, wenn diese Angabe keinen Sinn macht, z.B: bei einem Lagerplatz.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				> getHersteller() {
				return _hersteller;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZulaessigeEinbauOrtTypen = datum.getReferenceArray("ZulaessigeEinbauOrtTypen");
						arrayZulaessigeEinbauOrtTypen.setLength(getZulaessigeEinbauOrtTypen().size());
						for (int i = 0; i < arrayZulaessigeEinbauOrtTypen.getLength(); ++i) {
							final Object soZulaessigeEinbauOrtTypen = getZulaessigeEinbauOrtTypen().get(i);
							final SystemObject tmpZulaessigeEinbauOrtTypen;
							if (soZulaessigeEinbauOrtTypen instanceof SystemObject) {
								tmpZulaessigeEinbauOrtTypen = (SystemObject)soZulaessigeEinbauOrtTypen;
							} else if(soZulaessigeEinbauOrtTypen instanceof SystemObjekt){
								tmpZulaessigeEinbauOrtTypen = ((SystemObjekt)soZulaessigeEinbauOrtTypen).getSystemObject();
							} else{
								tmpZulaessigeEinbauOrtTypen = null;
							}
							arrayZulaessigeEinbauOrtTypen.getReferenceValue(i).setSystemObject(tmpZulaessigeEinbauOrtTypen);
						}
					// ZeichenkettenAttributTyp
					if (getDokumentation() != null) {
						final Data.TextArray arrayDokumentation = datum.getTextArray("Dokumentation");
						arrayDokumentation.setLength(getDokumentation().size());
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							arrayDokumentation.getTextValue(i).setText(getDokumentation().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBilder() != null) {
						final Data.TextArray arrayBilder = datum.getTextArray("Bilder");
						arrayBilder.setLength(getBilder().size());
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							arrayBilder.getTextValue(i).setText(getBilder().get(i));
						}
					}
					// GanzzahlAttributTyp
					if (getMaxBreite() != null) {
		                if (getMaxBreite().isZustand()) {
		                    datum.getUnscaledValue("MaxBreite").setText(getMaxBreite().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxBreite").set(getMaxBreite().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxHoehe() != null) {
		                if (getMaxHoehe().isZustand()) {
		                    datum.getUnscaledValue("MaxHoehe").setText(getMaxHoehe().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxHoehe").set(getMaxHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxTiefe() != null) {
		                if (getMaxTiefe().isZustand()) {
		                    datum.getUnscaledValue("MaxTiefe").setText(getMaxTiefe().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxTiefe").set(getMaxTiefe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMasse() != null) {
		                if (getMasse().isZustand()) {
		                    datum.getUnscaledValue("Masse").setText(getMasse().toString());
		                } else {
							datum.
							getScaledValue
		                	("Masse").set(getMasse().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHersteller = datum.getReferenceArray("Hersteller");
						arrayHersteller.setLength(getHersteller().size());
						for (int i = 0; i < arrayHersteller.getLength(); ++i) {
							final Object soHersteller = getHersteller().get(i);
							final SystemObject tmpHersteller;
							if (soHersteller instanceof SystemObject) {
								tmpHersteller = (SystemObject)soHersteller;
							} else if(soHersteller instanceof SystemObjekt){
								tmpHersteller = ((SystemObjekt)soHersteller).getSystemObject();
							} else{
								tmpHersteller = null;
							}
							arrayHersteller.getReferenceValue(i).setSystemObject(tmpHersteller);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZulaessigeEinbauOrtTypen = daten.getReferenceArray("ZulaessigeEinbauOrtTypen");
						for (int i = 0; i < arrayZulaessigeEinbauOrtTypen.getLength(); ++i) {
							final long idZulaessigeEinbauOrtTypen = daten.getReferenceArray("ZulaessigeEinbauOrtTypen").getReferenceValue(i).getId();
							final SystemObjekt tmpZulaessigeEinbauOrtTypen;
							if (idZulaessigeEinbauOrtTypen == 0) {
								tmpZulaessigeEinbauOrtTypen = null;
							} else {
								final SystemObject soZulaessigeEinbauOrtTypen = factory.getDav().getDataModel().getObject(idZulaessigeEinbauOrtTypen);
								if (soZulaessigeEinbauOrtTypen == null) {
										tmpZulaessigeEinbauOrtTypen = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtTypUngueltig(idZulaessigeEinbauOrtTypen);
								} else {
									tmpZulaessigeEinbauOrtTypen = factory.getModellobjekt(soZulaessigeEinbauOrtTypen);
								}
							}
								getZulaessigeEinbauOrtTypen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
								) tmpZulaessigeEinbauOrtTypen);
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDokumentation = daten.getTextArray("Dokumentation");
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							getDokumentation().add(arrayDokumentation.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBilder = daten.getTextArray("Bilder");
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							getBilder().add(arrayBilder.getText(i));
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxBreite").isState()) {
								setMaxBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxBreite").getText()));
							} else {
							setMaxBreite(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxBreite").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxHoehe").isState()) {
								setMaxHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxHoehe").getText()));
							} else {
							setMaxHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxHoehe").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxTiefe").isState()) {
								setMaxTiefe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxTiefe").getText()));
							} else {
							setMaxTiefe(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxTiefe").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Masse").isState()) {
								setMasse(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
								.getZustand(daten.getScaledValue("Masse").getText()));
							} else {
							setMasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
							(daten.
								getScaledValue
							("Masse").
								doubleValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHersteller = daten.getReferenceArray("Hersteller");
						for (int i = 0; i < arrayHersteller.getLength(); ++i) {
							final long idHersteller = daten.getReferenceArray("Hersteller").getReferenceValue(i).getId();
							final SystemObjekt tmpHersteller;
							if (idHersteller == 0) {
								tmpHersteller = null;
							} else {
								final SystemObject soHersteller = factory.getDav().getDataModel().getObject(idHersteller);
								if (soHersteller == null) {
										tmpHersteller = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HerstellerUngueltig(idHersteller);
								} else {
									tmpHersteller = factory.getModellobjekt(soHersteller);
								}
							}
								getHersteller().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
								) tmpHersteller);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBezeichnung(getBezeichnung());
						klon._zulaessigeEinbauOrtTypen = getZulaessigeEinbauOrtTypen().clone();
						klon._dokumentation = getDokumentation().clone();
						klon._bilder = getBilder().clone();
							klon.setMaxBreite(getMaxBreite());
							klon.setMaxHoehe(getMaxHoehe());
							klon.setMaxTiefe(getMaxTiefe());
							klon.setMasse(getMasse());
						klon._hersteller = getHersteller().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.einbauOrtTyp";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdEinbauOrtTyp(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
