/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Daten eines abstrakten Gerätetyps.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdGeraeteTyp extends AbstractKonfigurationsDatensatz<KdGeraeteTyp.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				 _hersteller
				;
				private String
				 _herstellerbezeichnung
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 _minimalTemperatur
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 _maximalTemperatur
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 _maximalLagerTemperatur
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 _minimalLagerTemperatur
				;
				private Feld<String
				> _dokumentation = new Feld<String
				>(0, true);
				private Feld<String
				> _bilder = new Feld<String
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxBreite
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxHoehe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maxTiefe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
				 _masseOhneKomponenten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
				 _leistungTypisch
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
				 _leistungMaximal
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
				 _dichtigkeit
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> _zulaessigeEinbauOrtTypen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				>(1, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> _hatEinbauOrtTypen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
				 _nennspannungMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
				 _nennspannungMin
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannungsart
				 _spannungsart
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetBeschleunigung
				 _maximalbeschleunigung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 _maximalhoehe
				;
		
			/**
			Referenz auf den Herstellers dieses Gerätetyps.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Referenz auf den Herstellers dieses Gerätetyps.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Bezeichnung dieses Gerätetyps beim Hersteller.
			<p>
			
			</p>
			
			@return der Wert von Herstellerbezeichnung.
			*/
				public String
				 getHerstellerbezeichnung() {
				return _herstellerbezeichnung;
			}
		
			/**
			Bezeichnung dieses Gerätetyps beim Hersteller.
			<p>
			
			</p>
			
			@param _herstellerbezeichnung der neue Wert von Herstellerbezeichnung.
			*/
			public void setHerstellerbezeichnung(String
			 _herstellerbezeichnung) {
				if (_herstellerbezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._herstellerbezeichnung = _herstellerbezeichnung;
			}
		
			/**
			Minimale Temperatur, bei der dieses Gerät betrieben werden darf.
			<p>
			
			</p>
			
			@return der Wert von MinimalTemperatur.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 getMinimalTemperatur() {
				return _minimalTemperatur;
			}
		
			/**
			Minimale Temperatur, bei der dieses Gerät betrieben werden darf.
			<p>
			
			</p>
			
			@param _minimalTemperatur der neue Wert von MinimalTemperatur.
			*/
			public void setMinimalTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
			 _minimalTemperatur) {
				this._minimalTemperatur = _minimalTemperatur;
			}
		
			/**
			Maximale Temperatur, bei der dieses Gerät betrieben werden darf.
			<p>
			
			</p>
			
			@return der Wert von MaximalTemperatur.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 getMaximalTemperatur() {
				return _maximalTemperatur;
			}
		
			/**
			Maximale Temperatur, bei der dieses Gerät betrieben werden darf.
			<p>
			
			</p>
			
			@param _maximalTemperatur der neue Wert von MaximalTemperatur.
			*/
			public void setMaximalTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
			 _maximalTemperatur) {
				this._maximalTemperatur = _maximalTemperatur;
			}
		
			/**
			Maximale Temperatur, bei der dieses Gerät gelagert werden darf.
			<p>
			
			</p>
			
			@return der Wert von MaximalLagerTemperatur.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 getMaximalLagerTemperatur() {
				return _maximalLagerTemperatur;
			}
		
			/**
			Maximale Temperatur, bei der dieses Gerät gelagert werden darf.
			<p>
			
			</p>
			
			@param _maximalLagerTemperatur der neue Wert von MaximalLagerTemperatur.
			*/
			public void setMaximalLagerTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
			 _maximalLagerTemperatur) {
				this._maximalLagerTemperatur = _maximalLagerTemperatur;
			}
		
			/**
			Minimale Temperatur, bei der dieses Gerät gelagert werden darf.
			<p>
			
			</p>
			
			@return der Wert von MinimalLagerTemperatur.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
				 getMinimalLagerTemperatur() {
				return _minimalLagerTemperatur;
			}
		
			/**
			Minimale Temperatur, bei der dieses Gerät gelagert werden darf.
			<p>
			
			</p>
			
			@param _minimalLagerTemperatur der neue Wert von MinimalLagerTemperatur.
			*/
			public void setMinimalLagerTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
			 _minimalLagerTemperatur) {
				this._minimalLagerTemperatur = _minimalLagerTemperatur;
			}
		
			/**
			Dokumentation zum abstrakten Gerätetyp, z.B. Handbücher...
			<p>
			
			</p>
			
			@return der Wert von Dokumentation.
			*/
				public Feld<String
				> getDokumentation() {
				return _dokumentation;
			}
		
		
			/**
			Bilder zum abstrakten Gerätetyp.
			<p>
			
			</p>
			
			@return der Wert von Bilder.
			*/
				public Feld<String
				> getBilder() {
				return _bilder;
			}
		
		
			/**
			Maximale Breite des Gerätetyps.
			<p>
			
			</p>
			
			@return der Wert von MaxBreite.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxBreite() {
				return _maxBreite;
			}
		
			/**
			Maximale Breite des Gerätetyps.
			<p>
			
			</p>
			
			@param _maxBreite der neue Wert von MaxBreite.
			*/
			public void setMaxBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxBreite) {
				this._maxBreite = _maxBreite;
			}
		
			/**
			Maximale Höhe des Gerätetyps.
			<p>
			
			</p>
			
			@return der Wert von MaxHoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxHoehe() {
				return _maxHoehe;
			}
		
			/**
			Maximale Höhe des Gerätetyps.
			<p>
			
			</p>
			
			@param _maxHoehe der neue Wert von MaxHoehe.
			*/
			public void setMaxHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxHoehe) {
				this._maxHoehe = _maxHoehe;
			}
		
			/**
			Maximale Tiefe des Gerätetyps.
			<p>
			
			</p>
			
			@return der Wert von MaxTiefe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaxTiefe() {
				return _maxTiefe;
			}
		
			/**
			Maximale Tiefe des Gerätetyps.
			<p>
			
			</p>
			
			@param _maxTiefe der neue Wert von MaxTiefe.
			*/
			public void setMaxTiefe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maxTiefe) {
				this._maxTiefe = _maxTiefe;
			}
		
			/**
			Masse des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@return der Wert von MasseOhneKomponenten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
				 getMasseOhneKomponenten() {
				return _masseOhneKomponenten;
			}
		
			/**
			Masse des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@param _masseOhneKomponenten der neue Wert von MasseOhneKomponenten.
			*/
			public void setMasseOhneKomponenten(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
			 _masseOhneKomponenten) {
				this._masseOhneKomponenten = _masseOhneKomponenten;
			}
		
			/**
			Typische Leistungsaufnahme des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@return der Wert von LeistungTypisch.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
				 getLeistungTypisch() {
				return _leistungTypisch;
			}
		
			/**
			Typische Leistungsaufnahme des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@param _leistungTypisch der neue Wert von LeistungTypisch.
			*/
			public void setLeistungTypisch(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
			 _leistungTypisch) {
				this._leistungTypisch = _leistungTypisch;
			}
		
			/**
			Maximale Leistungsaufnahme des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@return der Wert von LeistungMaximal.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
				 getLeistungMaximal() {
				return _leistungMaximal;
			}
		
			/**
			Maximale Leistungsaufnahme des Gerätetyps ohne eventuell dazugehörende Komponenten.
			<p>
			
			</p>
			
			@param _leistungMaximal der neue Wert von LeistungMaximal.
			*/
			public void setLeistungMaximal(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
			 _leistungMaximal) {
				this._leistungMaximal = _leistungMaximal;
			}
		
			/**
			Dichtigkeit des Gerätetyps.
			<p>
			
			</p>
			
			@return der Wert von Dichtigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
				 getDichtigkeit() {
				return _dichtigkeit;
			}
		
			/**
			Dichtigkeit des Gerätetyps.
			<p>
			
			</p>
			
			@param _dichtigkeit der neue Wert von Dichtigkeit.
			*/
			public void setDichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
			 _dichtigkeit) {
				this._dichtigkeit = _dichtigkeit;
			}
		
			/**
			Auflistung aller Einbauorttypen, in der dieser Gerätetyp eingebaut werden kann, ermöglicht verfizierung der konfiguration sowie eine Unterstützung bei zukünftigen Benutzeroberflächen. Der Einbauorttyp "Lager" sollte immer enthalten sein.
			<p>
			
			</p>
			
			@return der Wert von ZulaessigeEinbauOrtTypen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> getZulaessigeEinbauOrtTypen() {
				return _zulaessigeEinbauOrtTypen;
			}
		
		
			/**
			Auflistung aller Einbauorttypen, welches dieser Gerätetyp bereitstellt. Werden mehrere gleiche bereitgestellt, so sind mehrfach die gleichen Referenzen einzutragen.
			<p>
			
			</p>
			
			@return der Wert von HatEinbauOrtTypen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
				> getHatEinbauOrtTypen() {
				return _hatEinbauOrtTypen;
			}
		
		
			/**
			Maximalspannung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@return der Wert von NennspannungMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
				 getNennspannungMax() {
				return _nennspannungMax;
			}
		
			/**
			Maximalspannung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@param _nennspannungMax der neue Wert von NennspannungMax.
			*/
			public void setNennspannungMax(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
			 _nennspannungMax) {
				this._nennspannungMax = _nennspannungMax;
			}
		
			/**
			Minimalspannung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@return der Wert von NennspannungMin.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
				 getNennspannungMin() {
				return _nennspannungMin;
			}
		
			/**
			Minimalspannung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@param _nennspannungMin der neue Wert von NennspannungMin.
			*/
			public void setNennspannungMin(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
			 _nennspannungMin) {
				this._nennspannungMin = _nennspannungMin;
			}
		
			/**
			Spannungsart für diesen Gerätetyp (Gleichstrom, Wechselstrom ...).
			<p>
			
			</p>
			
			@return der Wert von Spannungsart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannungsart
				 getSpannungsart() {
				return _spannungsart;
			}
		
			/**
			Spannungsart für diesen Gerätetyp (Gleichstrom, Wechselstrom ...).
			<p>
			
			</p>
			
			@param _spannungsart der neue Wert von Spannungsart.
			*/
			public void setSpannungsart(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannungsart
			 _spannungsart) {
				this._spannungsart = _spannungsart;
			}
		
			/**
			Maximalbeschleunigung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@return der Wert von Maximalbeschleunigung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetBeschleunigung
				 getMaximalbeschleunigung() {
				return _maximalbeschleunigung;
			}
		
			/**
			Maximalbeschleunigung für diesen Gerätetyp.
			<p>
			
			</p>
			
			@param _maximalbeschleunigung der neue Wert von Maximalbeschleunigung.
			*/
			public void setMaximalbeschleunigung(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetBeschleunigung
			 _maximalbeschleunigung) {
				this._maximalbeschleunigung = _maximalbeschleunigung;
			}
		
			/**
			Maximalhöhe über NN, in der dieser Gerätetyp betrieben werden darf.
			<p>
			
			</p>
			
			@return der Wert von Maximalhoehe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
				 getMaximalhoehe() {
				return _maximalhoehe;
			}
		
			/**
			Maximalhöhe über NN, in der dieser Gerätetyp betrieben werden darf.
			<p>
			
			</p>
			
			@param _maximalhoehe der neue Wert von Maximalhoehe.
			*/
			public void setMaximalhoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
			 _maximalhoehe) {
				this._maximalhoehe = _maximalhoehe;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soHersteller = getHersteller();
						final SystemObject tmpHersteller;
							if (soHersteller instanceof SystemObject) {
								tmpHersteller = (SystemObject)soHersteller;
							} else if(soHersteller instanceof SystemObjekt){
								tmpHersteller = ((SystemObjekt)soHersteller).getSystemObject();
							} else{
								tmpHersteller = null;
							}
						datum.getReferenceValue("Hersteller").setSystemObject(tmpHersteller);
					// ZeichenkettenAttributTyp
					if (getHerstellerbezeichnung() != null) {
						datum.getTextValue("Herstellerbezeichnung").setText(getHerstellerbezeichnung());
					}
					// GanzzahlAttributTyp
					if (getMinimalTemperatur() != null) {
		                if (getMinimalTemperatur().isZustand()) {
		                    datum.getUnscaledValue("MinimalTemperatur").setText(getMinimalTemperatur().toString());
		                } else {
							datum.
							getScaledValue
		                	("MinimalTemperatur").set(getMinimalTemperatur().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximalTemperatur() != null) {
		                if (getMaximalTemperatur().isZustand()) {
		                    datum.getUnscaledValue("MaximalTemperatur").setText(getMaximalTemperatur().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaximalTemperatur").set(getMaximalTemperatur().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximalLagerTemperatur() != null) {
		                if (getMaximalLagerTemperatur().isZustand()) {
		                    datum.getUnscaledValue("MaximalLagerTemperatur").setText(getMaximalLagerTemperatur().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaximalLagerTemperatur").set(getMaximalLagerTemperatur().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMinimalLagerTemperatur() != null) {
		                if (getMinimalLagerTemperatur().isZustand()) {
		                    datum.getUnscaledValue("MinimalLagerTemperatur").setText(getMinimalLagerTemperatur().toString());
		                } else {
							datum.
							getScaledValue
		                	("MinimalLagerTemperatur").set(getMinimalLagerTemperatur().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getDokumentation() != null) {
						final Data.TextArray arrayDokumentation = datum.getTextArray("Dokumentation");
						arrayDokumentation.setLength(getDokumentation().size());
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							arrayDokumentation.getTextValue(i).setText(getDokumentation().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBilder() != null) {
						final Data.TextArray arrayBilder = datum.getTextArray("Bilder");
						arrayBilder.setLength(getBilder().size());
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							arrayBilder.getTextValue(i).setText(getBilder().get(i));
						}
					}
					// GanzzahlAttributTyp
					if (getMaxBreite() != null) {
		                if (getMaxBreite().isZustand()) {
		                    datum.getUnscaledValue("MaxBreite").setText(getMaxBreite().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxBreite").set(getMaxBreite().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxHoehe() != null) {
		                if (getMaxHoehe().isZustand()) {
		                    datum.getUnscaledValue("MaxHoehe").setText(getMaxHoehe().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxHoehe").set(getMaxHoehe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxTiefe() != null) {
		                if (getMaxTiefe().isZustand()) {
		                    datum.getUnscaledValue("MaxTiefe").setText(getMaxTiefe().toString());
		                } else {
							datum.
							getScaledValue
		                	("MaxTiefe").set(getMaxTiefe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMasseOhneKomponenten() != null) {
		                if (getMasseOhneKomponenten().isZustand()) {
		                    datum.getUnscaledValue("MasseOhneKomponenten").setText(getMasseOhneKomponenten().toString());
		                } else {
							datum.
							getScaledValue
		                	("MasseOhneKomponenten").set(getMasseOhneKomponenten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLeistungTypisch() != null) {
		                if (getLeistungTypisch().isZustand()) {
		                    datum.getUnscaledValue("LeistungTypisch").setText(getLeistungTypisch().toString());
		                } else {
							datum.
							getScaledValue
		                	("LeistungTypisch").set(getLeistungTypisch().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLeistungMaximal() != null) {
		                if (getLeistungMaximal().isZustand()) {
		                    datum.getUnscaledValue("LeistungMaximal").setText(getLeistungMaximal().toString());
		                } else {
							datum.
							getScaledValue
		                	("LeistungMaximal").set(getLeistungMaximal().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDichtigkeit() != null) {
		                if (getDichtigkeit().isZustand()) {
		                    datum.getUnscaledValue("Dichtigkeit").setText(getDichtigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Dichtigkeit").set(getDichtigkeit().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZulaessigeEinbauOrtTypen = datum.getReferenceArray("ZulaessigeEinbauOrtTypen");
						arrayZulaessigeEinbauOrtTypen.setLength(getZulaessigeEinbauOrtTypen().size());
						for (int i = 0; i < arrayZulaessigeEinbauOrtTypen.getLength(); ++i) {
							final Object soZulaessigeEinbauOrtTypen = getZulaessigeEinbauOrtTypen().get(i);
							final SystemObject tmpZulaessigeEinbauOrtTypen;
							if (soZulaessigeEinbauOrtTypen instanceof SystemObject) {
								tmpZulaessigeEinbauOrtTypen = (SystemObject)soZulaessigeEinbauOrtTypen;
							} else if(soZulaessigeEinbauOrtTypen instanceof SystemObjekt){
								tmpZulaessigeEinbauOrtTypen = ((SystemObjekt)soZulaessigeEinbauOrtTypen).getSystemObject();
							} else{
								tmpZulaessigeEinbauOrtTypen = null;
							}
							arrayZulaessigeEinbauOrtTypen.getReferenceValue(i).setSystemObject(tmpZulaessigeEinbauOrtTypen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHatEinbauOrtTypen = datum.getReferenceArray("HatEinbauOrtTypen");
						arrayHatEinbauOrtTypen.setLength(getHatEinbauOrtTypen().size());
						for (int i = 0; i < arrayHatEinbauOrtTypen.getLength(); ++i) {
							final Object soHatEinbauOrtTypen = getHatEinbauOrtTypen().get(i);
							final SystemObject tmpHatEinbauOrtTypen;
							if (soHatEinbauOrtTypen instanceof SystemObject) {
								tmpHatEinbauOrtTypen = (SystemObject)soHatEinbauOrtTypen;
							} else if(soHatEinbauOrtTypen instanceof SystemObjekt){
								tmpHatEinbauOrtTypen = ((SystemObjekt)soHatEinbauOrtTypen).getSystemObject();
							} else{
								tmpHatEinbauOrtTypen = null;
							}
							arrayHatEinbauOrtTypen.getReferenceValue(i).setSystemObject(tmpHatEinbauOrtTypen);
						}
					// GanzzahlAttributTyp
					if (getNennspannungMax() != null) {
		                if (getNennspannungMax().isZustand()) {
		                    datum.getUnscaledValue("NennspannungMax").setText(getNennspannungMax().toString());
		                } else {
							datum.
							getScaledValue
		                	("NennspannungMax").set(getNennspannungMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNennspannungMin() != null) {
		                if (getNennspannungMin().isZustand()) {
		                    datum.getUnscaledValue("NennspannungMin").setText(getNennspannungMin().toString());
		                } else {
							datum.
							getScaledValue
		                	("NennspannungMin").set(getNennspannungMin().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSpannungsart() != null) {
		                if (getSpannungsart().isZustand()) {
		                    datum.getUnscaledValue("Spannungsart").setText(getSpannungsart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Spannungsart").set(getSpannungsart().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximalbeschleunigung() != null) {
		                if (getMaximalbeschleunigung().isZustand()) {
		                    datum.getUnscaledValue("Maximalbeschleunigung").setText(getMaximalbeschleunigung().toString());
		                } else {
							datum.
							getScaledValue
		                	("Maximalbeschleunigung").set(getMaximalbeschleunigung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximalhoehe() != null) {
		                if (getMaximalhoehe().isZustand()) {
		                    datum.getUnscaledValue("Maximalhoehe").setText(getMaximalhoehe().toString());
		                } else {
							datum.
							getScaledValue
		                	("Maximalhoehe").set(getMaximalhoehe().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idHersteller = daten.getReferenceValue("Hersteller").getId();
						final SystemObjekt tmpHersteller;
						if (idHersteller == 0) {
							tmpHersteller = null;
						} else {
							final SystemObject soHersteller = factory.getDav().getDataModel().getObject(idHersteller);
							if (soHersteller == null) {
									tmpHersteller = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HerstellerUngueltig(idHersteller);
							} else {
								tmpHersteller = factory.getModellobjekt(soHersteller);
							}
						}
						setHersteller((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Hersteller
						) tmpHersteller);
					// ZeichenkettenAttributTyp
						setHerstellerbezeichnung(daten.getTextValue("Herstellerbezeichnung").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MinimalTemperatur").isState()) {
								setMinimalTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
								.getZustand(daten.getScaledValue("MinimalTemperatur").getText()));
							} else {
							setMinimalTemperatur(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
							(daten.
								getScaledValue
							("MinimalTemperatur").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaximalTemperatur").isState()) {
								setMaximalTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
								.getZustand(daten.getScaledValue("MaximalTemperatur").getText()));
							} else {
							setMaximalTemperatur(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
							(daten.
								getScaledValue
							("MaximalTemperatur").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaximalLagerTemperatur").isState()) {
								setMaximalLagerTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
								.getZustand(daten.getScaledValue("MaximalLagerTemperatur").getText()));
							} else {
							setMaximalLagerTemperatur(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
							(daten.
								getScaledValue
							("MaximalLagerTemperatur").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MinimalLagerTemperatur").isState()) {
								setMinimalLagerTemperatur(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
								.getZustand(daten.getScaledValue("MinimalLagerTemperatur").getText()));
							} else {
							setMinimalLagerTemperatur(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetTemperatur
							(daten.
								getScaledValue
							("MinimalLagerTemperatur").
								doubleValue
							()));
							}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDokumentation = daten.getTextArray("Dokumentation");
						for (int i = 0; i < arrayDokumentation.getLength(); ++i) {
							getDokumentation().add(arrayDokumentation.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBilder = daten.getTextArray("Bilder");
						for (int i = 0; i < arrayBilder.getLength(); ++i) {
							getBilder().add(arrayBilder.getText(i));
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxBreite").isState()) {
								setMaxBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxBreite").getText()));
							} else {
							setMaxBreite(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxBreite").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxHoehe").isState()) {
								setMaxHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxHoehe").getText()));
							} else {
							setMaxHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxHoehe").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxTiefe").isState()) {
								setMaxTiefe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("MaxTiefe").getText()));
							} else {
							setMaxTiefe(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("MaxTiefe").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MasseOhneKomponenten").isState()) {
								setMasseOhneKomponenten(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
								.getZustand(daten.getScaledValue("MasseOhneKomponenten").getText()));
							} else {
							setMasseOhneKomponenten(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetMasse
							(daten.
								getScaledValue
							("MasseOhneKomponenten").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LeistungTypisch").isState()) {
								setLeistungTypisch(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
								.getZustand(daten.getScaledValue("LeistungTypisch").getText()));
							} else {
							setLeistungTypisch(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
							(daten.
								getScaledValue
							("LeistungTypisch").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LeistungMaximal").isState()) {
								setLeistungMaximal(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
								.getZustand(daten.getScaledValue("LeistungMaximal").getText()));
							} else {
							setLeistungMaximal(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLeistung
							(daten.
								getScaledValue
							("LeistungMaximal").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Dichtigkeit").isState()) {
								setDichtigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
								.getZustand(daten.getScaledValue("Dichtigkeit").getText()));
							} else {
							setDichtigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetGehaeuseDichtigkeit
							(daten.
								getUnscaledValue
							("Dichtigkeit").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZulaessigeEinbauOrtTypen = daten.getReferenceArray("ZulaessigeEinbauOrtTypen");
						for (int i = 0; i < arrayZulaessigeEinbauOrtTypen.getLength(); ++i) {
							final long idZulaessigeEinbauOrtTypen = daten.getReferenceArray("ZulaessigeEinbauOrtTypen").getReferenceValue(i).getId();
							final SystemObjekt tmpZulaessigeEinbauOrtTypen;
							if (idZulaessigeEinbauOrtTypen == 0) {
								tmpZulaessigeEinbauOrtTypen = null;
							} else {
								final SystemObject soZulaessigeEinbauOrtTypen = factory.getDav().getDataModel().getObject(idZulaessigeEinbauOrtTypen);
								if (soZulaessigeEinbauOrtTypen == null) {
										tmpZulaessigeEinbauOrtTypen = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtTypUngueltig(idZulaessigeEinbauOrtTypen);
								} else {
									tmpZulaessigeEinbauOrtTypen = factory.getModellobjekt(soZulaessigeEinbauOrtTypen);
								}
							}
								getZulaessigeEinbauOrtTypen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
								) tmpZulaessigeEinbauOrtTypen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayHatEinbauOrtTypen = daten.getReferenceArray("HatEinbauOrtTypen");
						for (int i = 0; i < arrayHatEinbauOrtTypen.getLength(); ++i) {
							final long idHatEinbauOrtTypen = daten.getReferenceArray("HatEinbauOrtTypen").getReferenceValue(i).getId();
							final SystemObjekt tmpHatEinbauOrtTypen;
							if (idHatEinbauOrtTypen == 0) {
								tmpHatEinbauOrtTypen = null;
							} else {
								final SystemObject soHatEinbauOrtTypen = factory.getDav().getDataModel().getObject(idHatEinbauOrtTypen);
								if (soHatEinbauOrtTypen == null) {
										tmpHatEinbauOrtTypen = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.EinbauOrtTypUngueltig(idHatEinbauOrtTypen);
								} else {
									tmpHatEinbauOrtTypen = factory.getModellobjekt(soHatEinbauOrtTypen);
								}
							}
								getHatEinbauOrtTypen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.EinbauOrtTyp
								) tmpHatEinbauOrtTypen);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NennspannungMax").isState()) {
								setNennspannungMax(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
								.getZustand(daten.getScaledValue("NennspannungMax").getText()));
							} else {
							setNennspannungMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
							(daten.
								getScaledValue
							("NennspannungMax").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("NennspannungMin").isState()) {
								setNennspannungMin(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
								.getZustand(daten.getScaledValue("NennspannungMin").getText()));
							} else {
							setNennspannungMin(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannung
							(daten.
								getScaledValue
							("NennspannungMin").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Spannungsart").isState()) {
								setSpannungsart(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannungsart
								.getZustand(daten.getScaledValue("Spannungsart").getText()));
							} else {
							setSpannungsart(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetSpannungsart
							(daten.
								getUnscaledValue
							("Spannungsart").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Maximalbeschleunigung").isState()) {
								setMaximalbeschleunigung(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetBeschleunigung
								.getZustand(daten.getScaledValue("Maximalbeschleunigung").getText()));
							} else {
							setMaximalbeschleunigung(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetBeschleunigung
							(daten.
								getScaledValue
							("Maximalbeschleunigung").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Maximalhoehe").isState()) {
								setMaximalhoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
								.getZustand(daten.getScaledValue("Maximalhoehe").getText()));
							} else {
							setMaximalhoehe(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.attribute.AttGeraetLaengeMeter
							(daten.
								getScaledValue
							("Maximalhoehe").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHersteller(getHersteller());
							klon.setHerstellerbezeichnung(getHerstellerbezeichnung());
							klon.setMinimalTemperatur(getMinimalTemperatur());
							klon.setMaximalTemperatur(getMaximalTemperatur());
							klon.setMaximalLagerTemperatur(getMaximalLagerTemperatur());
							klon.setMinimalLagerTemperatur(getMinimalLagerTemperatur());
						klon._dokumentation = getDokumentation().clone();
						klon._bilder = getBilder().clone();
							klon.setMaxBreite(getMaxBreite());
							klon.setMaxHoehe(getMaxHoehe());
							klon.setMaxTiefe(getMaxTiefe());
							klon.setMasseOhneKomponenten(getMasseOhneKomponenten());
							klon.setLeistungTypisch(getLeistungTypisch());
							klon.setLeistungMaximal(getLeistungMaximal());
							klon.setDichtigkeit(getDichtigkeit());
						klon._zulaessigeEinbauOrtTypen = getZulaessigeEinbauOrtTypen().clone();
						klon._hatEinbauOrtTypen = getHatEinbauOrtTypen().clone();
							klon.setNennspannungMax(getNennspannungMax());
							klon.setNennspannungMin(getNennspannungMin());
							klon.setSpannungsart(getSpannungsart());
							klon.setMaximalbeschleunigung(getMaximalbeschleunigung());
							klon.setMaximalhoehe(getMaximalhoehe());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.geraeteTyp";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdGeraeteTyp(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
