/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class KdKonkretesEtwas extends AbstractKonfigurationsDatensatz<KdKonkretesEtwas.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Lieferant
				> _lieferant = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Lieferant
				>(1, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Instandhalter
				> _instandhalter = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Instandhalter
				>(0, true);
				private Feld<String
				> _seriennummer = new Feld<String
				>(0, true);
				private Feld<String
				> _referenznummer = new Feld<String
				>(0, true);
				private 	Zeitstempel
				 _baujahr
				;
		
			/**
			Referenz auf den&#47;die Lieferanten dieses konkreten Dings.
			<p>
			
			</p>
			
			@return der Wert von Lieferant.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Lieferant
				> getLieferant() {
				return _lieferant;
			}
		
		
			/**
			Referenz auf den&#47;diejenigen, welche aktuell mit der Instandhaltung dieses konkreten Dings beauftragt sind.
			<p>
			
			</p>
			
			@return der Wert von Instandhalter.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Instandhalter
				> getInstandhalter() {
				return _instandhalter;
			}
		
		
			/**
			Die Seriennummer(n) des konkreten Dings, soweit vorhanden.
			<p>
			
			</p>
			
			@return der Wert von Seriennummer.
			*/
				public Feld<String
				> getSeriennummer() {
				return _seriennummer;
			}
		
		
			/**
			Die Referenznummer(n) des konkreten Dings, soweit vorhanden.
			<p>
			
			</p>
			
			@return der Wert von Referenznummer.
			*/
				public Feld<String
				> getReferenznummer() {
				return _referenznummer;
			}
		
		
			/**
			Der Erstellungszeitpunkt des konkreten Etwas.
			<p>
			
			</p>
			
			@return der Wert von Baujahr.
			*/
				public 	Zeitstempel
				 getBaujahr() {
				return _baujahr;
			}
		
			/**
			Der Erstellungszeitpunkt des konkreten Etwas.
			<p>
			
			</p>
			
			@param _baujahr der neue Wert von Baujahr.
			*/
			public void setBaujahr(	Zeitstempel
			 _baujahr) {
				this._baujahr = _baujahr;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayLieferant = datum.getReferenceArray("Lieferant");
						arrayLieferant.setLength(getLieferant().size());
						for (int i = 0; i < arrayLieferant.getLength(); ++i) {
							final Object soLieferant = getLieferant().get(i);
							final SystemObject tmpLieferant;
							if (soLieferant instanceof SystemObject) {
								tmpLieferant = (SystemObject)soLieferant;
							} else if(soLieferant instanceof SystemObjekt){
								tmpLieferant = ((SystemObjekt)soLieferant).getSystemObject();
							} else{
								tmpLieferant = null;
							}
							arrayLieferant.getReferenceValue(i).setSystemObject(tmpLieferant);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayInstandhalter = datum.getReferenceArray("Instandhalter");
						arrayInstandhalter.setLength(getInstandhalter().size());
						for (int i = 0; i < arrayInstandhalter.getLength(); ++i) {
							final Object soInstandhalter = getInstandhalter().get(i);
							final SystemObject tmpInstandhalter;
							if (soInstandhalter instanceof SystemObject) {
								tmpInstandhalter = (SystemObject)soInstandhalter;
							} else if(soInstandhalter instanceof SystemObjekt){
								tmpInstandhalter = ((SystemObjekt)soInstandhalter).getSystemObject();
							} else{
								tmpInstandhalter = null;
							}
							arrayInstandhalter.getReferenceValue(i).setSystemObject(tmpInstandhalter);
						}
					// ZeichenkettenAttributTyp
					if (getSeriennummer() != null) {
						final Data.TextArray arraySeriennummer = datum.getTextArray("Seriennummer");
						arraySeriennummer.setLength(getSeriennummer().size());
						for (int i = 0; i < arraySeriennummer.getLength(); ++i) {
							arraySeriennummer.getTextValue(i).setText(getSeriennummer().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getReferenznummer() != null) {
						final Data.TextArray arrayReferenznummer = datum.getTextArray("Referenznummer");
						arrayReferenznummer.setLength(getReferenznummer().size());
						for (int i = 0; i < arrayReferenznummer.getLength(); ++i) {
							arrayReferenznummer.getTextValue(i).setText(getReferenznummer().get(i));
						}
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Baujahr").setMillis(getBaujahr().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayLieferant = daten.getReferenceArray("Lieferant");
						for (int i = 0; i < arrayLieferant.getLength(); ++i) {
							final long idLieferant = daten.getReferenceArray("Lieferant").getReferenceValue(i).getId();
							final SystemObjekt tmpLieferant;
							if (idLieferant == 0) {
								tmpLieferant = null;
							} else {
								final SystemObject soLieferant = factory.getDav().getDataModel().getObject(idLieferant);
								if (soLieferant == null) {
										tmpLieferant = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.LieferantUngueltig(idLieferant);
								} else {
									tmpLieferant = factory.getModellobjekt(soLieferant);
								}
							}
								getLieferant().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Lieferant
								) tmpLieferant);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayInstandhalter = daten.getReferenceArray("Instandhalter");
						for (int i = 0; i < arrayInstandhalter.getLength(); ++i) {
							final long idInstandhalter = daten.getReferenceArray("Instandhalter").getReferenceValue(i).getId();
							final SystemObjekt tmpInstandhalter;
							if (idInstandhalter == 0) {
								tmpInstandhalter = null;
							} else {
								final SystemObject soInstandhalter = factory.getDav().getDataModel().getObject(idInstandhalter);
								if (soInstandhalter == null) {
										tmpInstandhalter = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.InstandhalterUngueltig(idInstandhalter);
								} else {
									tmpInstandhalter = factory.getModellobjekt(soInstandhalter);
								}
							}
								getInstandhalter().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.Instandhalter
								) tmpInstandhalter);
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arraySeriennummer = daten.getTextArray("Seriennummer");
						for (int i = 0; i < arraySeriennummer.getLength(); ++i) {
							getSeriennummer().add(arraySeriennummer.getText(i));
						}
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayReferenznummer = daten.getTextArray("Referenznummer");
						for (int i = 0; i < arrayReferenznummer.getLength(); ++i) {
							getReferenznummer().add(arrayReferenznummer.getText(i));
						}
					// ZeitstempelAttributTyp
						setBaujahr(new
							Zeitstempel
							(daten.getTimeValue("Baujahr").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._lieferant = getLieferant().clone();
						klon._instandhalter = getInstandhalter().clone();
						klon._seriennummer = getSeriennummer().clone();
						klon._referenznummer = getReferenznummer().clone();
							klon.setBaujahr(getBaujahr());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.konkretesEtwas";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdKonkretesEtwas(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
