/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz für das zu benutzende Modem.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlModemParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _cOMPort
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttBaud
			 _baudRate
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _empfangsTimeout
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttModemTyp
			 _modemTyp
			;
			private String
			 _gsmPin
			= new String
			()
			;
			private String
			 _initialisierungsBefehl
			= new String
			()
			;
			private String
			 _wahlPraefix
			= new String
			()
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von COMPort.
		*/
			public String
			 getCOMPort() {
			return _cOMPort;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _cOMPort der neue Wert von COMPort.
		*/
		public void setCOMPort(String
		 _cOMPort) {
			if (_cOMPort.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._cOMPort = _cOMPort;
		}
	
		/**
		Baudraten-Definitionen.
		<p>
		
		</p>
		
		@return der Wert von BaudRate.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttBaud
			 getBaudRate() {
			return _baudRate;
		}
	
		/**
		Baudraten-Definitionen.
		<p>
		
		</p>
		
		@param _baudRate der neue Wert von BaudRate.
		*/
		public void setBaudRate(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttBaud
		 _baudRate) {
			this._baudRate = _baudRate;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von EmpfangsTimeout.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getEmpfangsTimeout() {
			return _empfangsTimeout;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _empfangsTimeout der neue Wert von EmpfangsTimeout.
		*/
		public void setEmpfangsTimeout(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _empfangsTimeout) {
			this._empfangsTimeout = _empfangsTimeout;
		}
	
		/**
		Typ des Modems.
		<p>
		
		</p>
		
		@return der Wert von ModemTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttModemTyp
			 getModemTyp() {
			return _modemTyp;
		}
	
		/**
		Typ des Modems.
		<p>
		
		</p>
		
		@param _modemTyp der neue Wert von ModemTyp.
		*/
		public void setModemTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttModemTyp
		 _modemTyp) {
			this._modemTyp = _modemTyp;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von GsmPin.
		*/
			public String
			 getGsmPin() {
			return _gsmPin;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _gsmPin der neue Wert von GsmPin.
		*/
		public void setGsmPin(String
		 _gsmPin) {
			if (_gsmPin.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._gsmPin = _gsmPin;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von InitialisierungsBefehl.
		*/
			public String
			 getInitialisierungsBefehl() {
			return _initialisierungsBefehl;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _initialisierungsBefehl der neue Wert von InitialisierungsBefehl.
		*/
		public void setInitialisierungsBefehl(String
		 _initialisierungsBefehl) {
			if (_initialisierungsBefehl.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._initialisierungsBefehl = _initialisierungsBefehl;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von WahlPraefix.
		*/
			public String
			 getWahlPraefix() {
			return _wahlPraefix;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _wahlPraefix der neue Wert von WahlPraefix.
		*/
		public void setWahlPraefix(String
		 _wahlPraefix) {
			if (_wahlPraefix.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._wahlPraefix = _wahlPraefix;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getCOMPort() != null) {
					datum.getTextValue("COM-Port").setText(getCOMPort());
				}
				// GanzzahlAttributTyp
				if (getBaudRate() != null) {
	                if (getBaudRate().isZustand()) {
	                    datum.getUnscaledValue("BaudRate").setText(getBaudRate().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BaudRate").set(getBaudRate().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEmpfangsTimeout() != null) {
	                if (getEmpfangsTimeout().isZustand()) {
	                    datum.getUnscaledValue("EmpfangsTimeout").setText(getEmpfangsTimeout().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EmpfangsTimeout").set(getEmpfangsTimeout().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getModemTyp() != null) {
	                if (getModemTyp().isZustand()) {
	                    datum.getUnscaledValue("ModemTyp").setText(getModemTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ModemTyp").set(getModemTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getGsmPin() != null) {
					datum.getTextValue("GsmPin").setText(getGsmPin());
				}
				// ZeichenkettenAttributTyp
				if (getInitialisierungsBefehl() != null) {
					datum.getTextValue("InitialisierungsBefehl").setText(getInitialisierungsBefehl());
				}
				// ZeichenkettenAttributTyp
				if (getWahlPraefix() != null) {
					datum.getTextValue("WahlPraefix").setText(getWahlPraefix());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setCOMPort(daten.getTextValue("COM-Port").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BaudRate").isState()) {
							setBaudRate(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttBaud
							.getZustand(daten.getScaledValue("BaudRate").getText()));
						} else {
						setBaudRate(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttBaud
						(daten.
							getUnscaledValue
						("BaudRate").
								intValue
						()));
						}
				// GanzzahlAttributTyp
						setEmpfangsTimeout(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("EmpfangsTimeout").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ModemTyp").isState()) {
							setModemTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttModemTyp
							.getZustand(daten.getScaledValue("ModemTyp").getText()));
						} else {
						setModemTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttModemTyp
						(daten.
							getUnscaledValue
						("ModemTyp").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setGsmPin(daten.getTextValue("GsmPin").getText());
				// ZeichenkettenAttributTyp
					setInitialisierungsBefehl(daten.getTextValue("InitialisierungsBefehl").getText());
				// ZeichenkettenAttributTyp
					setWahlPraefix(daten.getTextValue("WahlPraefix").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlModemParameter clone() {
		AtlModemParameter klon = new AtlModemParameter();
		
						klon.setCOMPort(getCOMPort());
						klon.setBaudRate(getBaudRate());
						klon.setEmpfangsTimeout(getEmpfangsTimeout());
						klon.setModemTyp(getModemTyp());
						klon.setGsmPin(getGsmPin());
						klon.setInitialisierungsBefehl(getInitialisierungsBefehl());
						klon.setWahlPraefix(getWahlPraefix());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
