/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz für den Versand von Sprachnachrichten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlSprachAnsageParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _ansageVorNachricht
			= new String
			()
			;
			private String
			 _ansageNachNachricht
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _warteZeitRufAnnahme
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von AnsageVorNachricht.
		*/
			public String
			 getAnsageVorNachricht() {
			return _ansageVorNachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _ansageVorNachricht der neue Wert von AnsageVorNachricht.
		*/
		public void setAnsageVorNachricht(String
		 _ansageVorNachricht) {
			if (_ansageVorNachricht.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ansageVorNachricht = _ansageVorNachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von AnsageNachNachricht.
		*/
			public String
			 getAnsageNachNachricht() {
			return _ansageNachNachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _ansageNachNachricht der neue Wert von AnsageNachNachricht.
		*/
		public void setAnsageNachNachricht(String
		 _ansageNachNachricht) {
			if (_ansageNachNachricht.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._ansageNachNachricht = _ansageNachNachricht;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von WarteZeitRufAnnahme.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getWarteZeitRufAnnahme() {
			return _warteZeitRufAnnahme;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _warteZeitRufAnnahme der neue Wert von WarteZeitRufAnnahme.
		*/
		public void setWarteZeitRufAnnahme(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _warteZeitRufAnnahme) {
			this._warteZeitRufAnnahme = _warteZeitRufAnnahme;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAnsageVorNachricht() != null) {
					datum.getTextValue("AnsageVorNachricht").setText(getAnsageVorNachricht());
				}
				// ZeichenkettenAttributTyp
				if (getAnsageNachNachricht() != null) {
					datum.getTextValue("AnsageNachNachricht").setText(getAnsageNachNachricht());
				}
				// GanzzahlAttributTyp
				if (getWarteZeitRufAnnahme() != null) {
	                if (getWarteZeitRufAnnahme().isZustand()) {
	                    datum.getUnscaledValue("WarteZeitRufAnnahme").setText(getWarteZeitRufAnnahme().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("WarteZeitRufAnnahme").set(getWarteZeitRufAnnahme().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAnsageVorNachricht(daten.getTextValue("AnsageVorNachricht").getText());
				// ZeichenkettenAttributTyp
					setAnsageNachNachricht(daten.getTextValue("AnsageNachNachricht").getText());
				// GanzzahlAttributTyp
						setWarteZeitRufAnnahme(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("WarteZeitRufAnnahme").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSprachAnsageParameter clone() {
		AtlSprachAnsageParameter klon = new AtlSprachAnsageParameter();
		
						klon.setAnsageVorNachricht(getAnsageVorNachricht());
						klon.setAnsageNachNachricht(getAnsageNachNachricht());
						klon.setWarteZeitRufAnnahme(getWarteZeitRufAnnahme());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
