/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz für den Versand über VoIP.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlVoIPParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _voIPSenderHost
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _voIPSenderPort
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von VoIPSenderHost.
		*/
			public String
			 getVoIPSenderHost() {
			return _voIPSenderHost;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _voIPSenderHost der neue Wert von VoIPSenderHost.
		*/
		public void setVoIPSenderHost(String
		 _voIPSenderHost) {
			if (_voIPSenderHost.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._voIPSenderHost = _voIPSenderHost;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von VoIPSenderPort.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getVoIPSenderPort() {
			return _voIPSenderPort;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _voIPSenderPort der neue Wert von VoIPSenderPort.
		*/
		public void setVoIPSenderPort(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _voIPSenderPort) {
			this._voIPSenderPort = _voIPSenderPort;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getVoIPSenderHost() != null) {
					datum.getTextValue("VoIPSenderHost").setText(getVoIPSenderHost());
				}
				// GanzzahlAttributTyp
				if (getVoIPSenderPort() != null) {
	                if (getVoIPSenderPort().isZustand()) {
	                    datum.getUnscaledValue("VoIPSenderPort").setText(getVoIPSenderPort().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VoIPSenderPort").set(getVoIPSenderPort().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setVoIPSenderHost(daten.getTextValue("VoIPSenderHost").getText());
				// GanzzahlAttributTyp
						setVoIPSenderPort(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("VoIPSenderPort").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVoIPParameter clone() {
		AtlVoIPParameter klon = new AtlVoIPParameter();
		
						klon.setVoIPSenderHost(getVoIPSenderHost());
						klon.setVoIPSenderPort(getVoIPSenderPort());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
