/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationspartner ExternerMeldungsEmpfänger (über Email oder Fax).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface VersandModulExterneMeldungen extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.versandModulExterneMeldungen"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für Fax-Versand.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungenFax.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungenFax getPdVersandModulExterneMeldungenFax();
	
	/**
	Onlinedatensatz für einen Auftrag zum Versenden eines Fax.
	<p>
	
	</p>
	@return der Datensatz FaxVersandAuftrag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdFaxVersandAuftrag getOdFaxVersandAuftrag();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungen getPdVersandModulExterneMeldungen();
	
	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für SMS-Versand.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungenSms.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungenSms getPdVersandModulExterneMeldungenSms();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Onlinedatensatz für einen Auftrag zum Versenden einer E-Mail.
	<p>
	
	</p>
	@return der Datensatz EmailVersandAuftrag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdEmailVersandAuftrag getOdEmailVersandAuftrag();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Onlinedatensatz für die Rückmeldung der Ergebnisse eines Versandauftrags.
	<p>
	
	</p>
	@return der Datensatz VersandStatus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdVersandStatus getOdVersandStatus();
	
	/**
	Onlinedatensatz für einen Auftrag zum Versenden einer SMS.
	<p>
	
	</p>
	@return der Datensatz SmsVersandAuftrag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdSmsVersandAuftrag getOdSmsVersandAuftrag();
	
	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für VoIP-Fax-Versand.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungenVoIPFax.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungenVoIPFax getPdVersandModulExterneMeldungenVoIPFax();
	
	/**
	Onlinedatensatz für einen Auftrag zum Versenden eines Fax über VoIP.
	<p>
	
	</p>
	@return der Datensatz VoIPFaxVersandAuftrag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdVoIPFaxVersandAuftrag getOdVoIPFaxVersandAuftrag();
	
	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für Sprachnachrichten.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungenSprache.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungenSprache getPdVersandModulExterneMeldungenSprache();
	
	/**
	Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für E-Mail-Versand.
	<p>
	
	</p>
	@return der Datensatz VersandModulExterneMeldungenEmail.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter.PdVersandModulExterneMeldungenEmail getPdVersandModulExterneMeldungenEmail();
	
	/**
	Onlinedatensatz für einen Auftrag zum Versenden einer Sprachnachricht.
	<p>
	
	</p>
	@return der Datensatz SprachAnsageAuftrag.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten.OdSprachAnsageAuftrag getOdSprachAnsageAuftrag();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
