/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Onlinedatensatz für einen Auftrag zum Versenden eines Fax über VoIP.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdVoIPFaxVersandAuftrag extends AbstractOnlineDatensatz<OdVoIPFaxVersandAuftrag.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Auftrag,
				};
			}
	
			/**
			 * Aspekt zum Übertragen von Aufträgen.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Auftrag = new Aspekte("", "asp.auftrag");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AtlMeldungsID
				 _meldungsID
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AtlMeldungsID
				()
				;
				private Feld<String
				> _empfaenger = new Feld<String
				>(0, true);
				private String
				 _text
				= new String
				()
				;
		
			/**
			ID der Meldung.
			<p>
			
			</p>
			
			@return der Wert von MeldungsID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AtlMeldungsID
				 getMeldungsID() {
				return _meldungsID;
			}
		
			/**
			ID der Meldung.
			<p>
			
			</p>
			
			@param _meldungsID der neue Wert von MeldungsID.
			*/
			public void setMeldungsID(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AtlMeldungsID
			 _meldungsID) {
				this._meldungsID = _meldungsID;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Empfaenger.
			*/
				public Feld<String
				> getEmpfaenger() {
				return _empfaenger;
			}
		
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Text.
			*/
				public String
				 getText() {
				return _text;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _text der neue Wert von Text.
			*/
			public void setText(String
			 _text) {
				if (_text.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._text = _text;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getMeldungsID().bean2Atl(datum.getItem("MeldungsID"), factory);
					// ZeichenkettenAttributTyp
					if (getEmpfaenger() != null) {
						final Data.TextArray arrayEmpfaenger = datum.getTextArray("Empfaenger");
						arrayEmpfaenger.setLength(getEmpfaenger().size());
						for (int i = 0; i < arrayEmpfaenger.getLength(); ++i) {
							arrayEmpfaenger.getTextValue(i).setText(getEmpfaenger().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getText() != null) {
						datum.getTextValue("Text").setText(getText());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getMeldungsID().atl2Bean(daten.getItem("MeldungsID"), factory);
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayEmpfaenger = daten.getTextArray("Empfaenger");
						for (int i = 0; i < arrayEmpfaenger.getLength(); ++i) {
							getEmpfaenger().add(arrayEmpfaenger.getText(i));
						}
					// ZeichenkettenAttributTyp
						setText(daten.getTextValue("Text").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._meldungsID = getMeldungsID().clone();
						klon._empfaenger = getEmpfaenger().clone();
							klon.setText(getText());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.VoIPFaxVersandAuftrag";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVoIPFaxVersandAuftrag(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
