/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametersatz mit zur Laufzeit änderbaren Kommunikationseinstellungen für E-Mail-Versand.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdVersandModulExterneMeldungenEmail extends AbstractParameterDatensatz<PdVersandModulExterneMeldungenEmail.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _mailServer
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttAuthentificationMode
				 _authentifizierung
				;
				private String
				 _benutzer
				= new String
				()
				;
				private String
				 _passwort
				= new String
				()
				;
				private String
				 _standardSender
				= new String
				()
				;
				private String
				 _standardEmpfaenger
				= new String
				()
				;
				private String
				 _standardBetreff
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von MailServer.
			*/
				public String
				 getMailServer() {
				return _mailServer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _mailServer der neue Wert von MailServer.
			*/
			public void setMailServer(String
			 _mailServer) {
				if (_mailServer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._mailServer = _mailServer;
			}
		
			/**
			Authentifizierungsart.
			<p>
			
			</p>
			
			@return der Wert von Authentifizierung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttAuthentificationMode
				 getAuthentifizierung() {
				return _authentifizierung;
			}
		
			/**
			Authentifizierungsart.
			<p>
			
			</p>
			
			@param _authentifizierung der neue Wert von Authentifizierung.
			*/
			public void setAuthentifizierung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttAuthentificationMode
			 _authentifizierung) {
				this._authentifizierung = _authentifizierung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Benutzer.
			*/
				public String
				 getBenutzer() {
				return _benutzer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _benutzer der neue Wert von Benutzer.
			*/
			public void setBenutzer(String
			 _benutzer) {
				if (_benutzer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._benutzer = _benutzer;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Passwort.
			*/
				public String
				 getPasswort() {
				return _passwort;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _passwort der neue Wert von Passwort.
			*/
			public void setPasswort(String
			 _passwort) {
				if (_passwort.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._passwort = _passwort;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von StandardSender.
			*/
				public String
				 getStandardSender() {
				return _standardSender;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _standardSender der neue Wert von StandardSender.
			*/
			public void setStandardSender(String
			 _standardSender) {
				if (_standardSender.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._standardSender = _standardSender;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von StandardEmpfaenger.
			*/
				public String
				 getStandardEmpfaenger() {
				return _standardEmpfaenger;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _standardEmpfaenger der neue Wert von StandardEmpfaenger.
			*/
			public void setStandardEmpfaenger(String
			 _standardEmpfaenger) {
				if (_standardEmpfaenger.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._standardEmpfaenger = _standardEmpfaenger;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von StandardBetreff.
			*/
				public String
				 getStandardBetreff() {
				return _standardBetreff;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _standardBetreff der neue Wert von StandardBetreff.
			*/
			public void setStandardBetreff(String
			 _standardBetreff) {
				if (_standardBetreff.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._standardBetreff = _standardBetreff;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getMailServer() != null) {
						datum.getTextValue("MailServer").setText(getMailServer());
					}
					// GanzzahlAttributTyp
					if (getAuthentifizierung() != null) {
		                if (getAuthentifizierung().isZustand()) {
		                    datum.getUnscaledValue("Authentifizierung").setText(getAuthentifizierung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Authentifizierung").set(getAuthentifizierung().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getBenutzer() != null) {
						datum.getTextValue("Benutzer").setText(getBenutzer());
					}
					// ZeichenkettenAttributTyp
					if (getPasswort() != null) {
						datum.getTextValue("Passwort").setText(getPasswort());
					}
					// ZeichenkettenAttributTyp
					if (getStandardSender() != null) {
						datum.getTextValue("StandardSender").setText(getStandardSender());
					}
					// ZeichenkettenAttributTyp
					if (getStandardEmpfaenger() != null) {
						datum.getTextValue("StandardEmpfaenger").setText(getStandardEmpfaenger());
					}
					// ZeichenkettenAttributTyp
					if (getStandardBetreff() != null) {
						datum.getTextValue("StandardBetreff").setText(getStandardBetreff());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setMailServer(daten.getTextValue("MailServer").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Authentifizierung").isState()) {
								setAuthentifizierung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttAuthentificationMode
								.getZustand(daten.getScaledValue("Authentifizierung").getText()));
							} else {
							setAuthentifizierung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexemailfaxglobal.attribute.AttAuthentificationMode
							(daten.
								getUnscaledValue
							("Authentifizierung").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setBenutzer(daten.getTextValue("Benutzer").getText());
					// ZeichenkettenAttributTyp
						setPasswort(daten.getTextValue("Passwort").getText());
					// ZeichenkettenAttributTyp
						setStandardSender(daten.getTextValue("StandardSender").getText());
					// ZeichenkettenAttributTyp
						setStandardEmpfaenger(daten.getTextValue("StandardEmpfaenger").getText());
					// ZeichenkettenAttributTyp
						setStandardBetreff(daten.getTextValue("StandardBetreff").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setMailServer(getMailServer());
							klon.setAuthentifizierung(getAuthentifizierung());
							klon.setBenutzer(getBenutzer());
							klon.setPasswort(getPasswort());
							klon.setStandardSender(getStandardSender());
							klon.setStandardEmpfaenger(getStandardEmpfaenger());
							klon.setStandardBetreff(getStandardBetreff());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.versandModulExterneMeldungenEmail";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVersandModulExterneMeldungenEmail(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
