/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusätzliche Verkehrsmerkmale einer Meldung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRdsAttribute implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "National")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsGeographischeRelevanz
			 _geographischeRelevanz
			;
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _vorhersage
			;
	
		/**
		Geographische Relevanz der Meldung.
		<p>
		TIC Info XML Element: AttributAreaOfInterest, Geographische Relevanz der Meldung.
		</p>
		
		@return der Wert von GeographischeRelevanz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsGeographischeRelevanz
			 getGeographischeRelevanz() {
			return _geographischeRelevanz;
		}
	
		/**
		Geographische Relevanz der Meldung.
		<p>
		TIC Info XML Element: AttributAreaOfInterest, Geographische Relevanz der Meldung.
		</p>
		
		@param _geographischeRelevanz der neue Wert von GeographischeRelevanz.
		*/
		public void setGeographischeRelevanz(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsGeographischeRelevanz
		 _geographischeRelevanz) {
			this._geographischeRelevanz = _geographischeRelevanz;
		}
	
		/**
		Die Information ist eine Vorhersage (ja) oder aktuelle Meldung (nein).
		<p>
		TIC Info XML Element: AttributeForecast, gibt an, ob die Information eine Vorhersage oder eine aktuelle Meldung ist .
		</p>
		
		@return der Wert von Vorhersage.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getVorhersage() {
			return _vorhersage;
		}
	
		/**
		Die Information ist eine Vorhersage (ja) oder aktuelle Meldung (nein).
		<p>
		TIC Info XML Element: AttributeForecast, gibt an, ob die Information eine Vorhersage oder eine aktuelle Meldung ist .
		</p>
		
		@param _vorhersage der neue Wert von Vorhersage.
		*/
		public void setVorhersage(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _vorhersage) {
			this._vorhersage = _vorhersage;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getGeographischeRelevanz() != null) {
	                if (getGeographischeRelevanz().isZustand()) {
	                    datum.getUnscaledValue("GeographischeRelevanz").setText(getGeographischeRelevanz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GeographischeRelevanz").set(getGeographischeRelevanz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVorhersage() != null) {
	                if (getVorhersage().isZustand()) {
	                    datum.getUnscaledValue("Vorhersage").setText(getVorhersage().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Vorhersage").set(getVorhersage().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GeographischeRelevanz").isState()) {
							setGeographischeRelevanz(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsGeographischeRelevanz
							.getZustand(daten.getScaledValue("GeographischeRelevanz").getText()));
						} else {
						setGeographischeRelevanz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsGeographischeRelevanz
						(daten.
							getUnscaledValue
						("GeographischeRelevanz").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vorhersage").isState()) {
							setVorhersage(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Vorhersage").getText()));
						} else {
						setVorhersage(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Vorhersage").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsAttribute clone() {
		AtlRdsAttribute klon = new AtlRdsAttribute();
		
						klon.setGeographischeRelevanz(getGeographischeRelevanz());
						klon.setVorhersage(getVorhersage());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
